/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateVehicleResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<BatchUpdateVehicleResponse.Builder, BatchUpdateVehicleResponse> {
    private static final SdkField<List<UpdateVehicleResponseItem>> VEHICLES_FIELD = SdkField
            .<List<UpdateVehicleResponseItem>> builder(MarshallingType.LIST)
            .memberName("vehicles")
            .getter(getter(BatchUpdateVehicleResponse::vehicles))
            .setter(setter(Builder::vehicles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateVehicleResponseItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateVehicleResponseItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UpdateVehicleError>> ERRORS_FIELD = SdkField
            .<List<UpdateVehicleError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchUpdateVehicleResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateVehicleError> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateVehicleError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UpdateVehicleResponseItem> vehicles;

    private final List<UpdateVehicleError> errors;

    private BatchUpdateVehicleResponse(BuilderImpl builder) {
        super(builder);
        this.vehicles = builder.vehicles;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vehicles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVehicles() {
        return vehicles != null && !(vehicles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about the batch of updated vehicles.
     * </p>
     * <note>
     * <p>
     * This list contains only unique IDs for the vehicles that were updated.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVehicles} method.
     * </p>
     * 
     * @return A list of information about the batch of updated vehicles. </p> <note>
     *         <p>
     *         This list contains only unique IDs for the vehicles that were updated.
     *         </p>
     */
    public final List<UpdateVehicleResponseItem> vehicles() {
        return vehicles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about errors returned while updating a batch of vehicles, or, if there aren't any errors,
     * an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of information about errors returned while updating a batch of vehicles, or, if there aren't any
     *         errors, an empty list.
     */
    public final List<UpdateVehicleError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVehicles() ? vehicles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateVehicleResponse)) {
            return false;
        }
        BatchUpdateVehicleResponse other = (BatchUpdateVehicleResponse) obj;
        return hasVehicles() == other.hasVehicles() && Objects.equals(vehicles(), other.vehicles())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateVehicleResponse").add("Vehicles", hasVehicles() ? vehicles() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicles":
            return Optional.ofNullable(clazz.cast(vehicles()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vehicles", VEHICLES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateVehicleResponse, T> g) {
        return obj -> g.apply((BatchUpdateVehicleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateVehicleResponse> {
        /**
         * <p>
         * A list of information about the batch of updated vehicles.
         * </p>
         * <note>
         * <p>
         * This list contains only unique IDs for the vehicles that were updated.
         * </p>
         * </note>
         * 
         * @param vehicles
         *        A list of information about the batch of updated vehicles. </p> <note>
         *        <p>
         *        This list contains only unique IDs for the vehicles that were updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicles(Collection<UpdateVehicleResponseItem> vehicles);

        /**
         * <p>
         * A list of information about the batch of updated vehicles.
         * </p>
         * <note>
         * <p>
         * This list contains only unique IDs for the vehicles that were updated.
         * </p>
         * </note>
         * 
         * @param vehicles
         *        A list of information about the batch of updated vehicles. </p> <note>
         *        <p>
         *        This list contains only unique IDs for the vehicles that were updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicles(UpdateVehicleResponseItem... vehicles);

        /**
         * <p>
         * A list of information about the batch of updated vehicles.
         * </p>
         * <note>
         * <p>
         * This list contains only unique IDs for the vehicles that were updated.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem.Builder#build()} is
         * called immediately and its result is passed to {@link #vehicles(List<UpdateVehicleResponseItem>)}.
         * 
         * @param vehicles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vehicles(java.util.Collection<UpdateVehicleResponseItem>)
         */
        Builder vehicles(Consumer<UpdateVehicleResponseItem.Builder>... vehicles);

        /**
         * <p>
         * A list of information about errors returned while updating a batch of vehicles, or, if there aren't any
         * errors, an empty list.
         * </p>
         * 
         * @param errors
         *        A list of information about errors returned while updating a batch of vehicles, or, if there aren't
         *        any errors, an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<UpdateVehicleError> errors);

        /**
         * <p>
         * A list of information about errors returned while updating a batch of vehicles, or, if there aren't any
         * errors, an empty list.
         * </p>
         * 
         * @param errors
         *        A list of information about errors returned while updating a batch of vehicles, or, if there aren't
         *        any errors, an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(UpdateVehicleError... errors);

        /**
         * <p>
         * A list of information about errors returned while updating a batch of vehicles, or, if there aren't any
         * errors, an empty list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<UpdateVehicleError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<UpdateVehicleError>)
         */
        Builder errors(Consumer<UpdateVehicleError.Builder>... errors);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private List<UpdateVehicleResponseItem> vehicles = DefaultSdkAutoConstructList.getInstance();

        private List<UpdateVehicleError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateVehicleResponse model) {
            super(model);
            vehicles(model.vehicles);
            errors(model.errors);
        }

        public final List<UpdateVehicleResponseItem.Builder> getVehicles() {
            List<UpdateVehicleResponseItem.Builder> result = _updateVehicleResponseItemsCopier.copyToBuilder(this.vehicles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicles(Collection<UpdateVehicleResponseItem.BuilderImpl> vehicles) {
            this.vehicles = _updateVehicleResponseItemsCopier.copyFromBuilder(vehicles);
        }

        @Override
        public final Builder vehicles(Collection<UpdateVehicleResponseItem> vehicles) {
            this.vehicles = _updateVehicleResponseItemsCopier.copy(vehicles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(UpdateVehicleResponseItem... vehicles) {
            vehicles(Arrays.asList(vehicles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(Consumer<UpdateVehicleResponseItem.Builder>... vehicles) {
            vehicles(Stream.of(vehicles).map(c -> UpdateVehicleResponseItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UpdateVehicleError.Builder> getErrors() {
            List<UpdateVehicleError.Builder> result = _updateVehicleErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<UpdateVehicleError.BuilderImpl> errors) {
            this.errors = _updateVehicleErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<UpdateVehicleError> errors) {
            this.errors = _updateVehicleErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(UpdateVehicleError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<UpdateVehicleError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> UpdateVehicleError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateVehicleResponse build() {
            return new BatchUpdateVehicleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
