/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a campaign.
 * </p>
 * <p>
 * You can use the API operation to return this information about multiple created campaigns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignSummary implements SdkPojo, Serializable, ToCopyableBuilder<CampaignSummary.Builder, CampaignSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CampaignSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CampaignSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CampaignSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(CampaignSummary::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(CampaignSummary::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CampaignSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(CampaignSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(CampaignSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SIGNAL_CATALOG_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String signalCatalogArn;

    private final String targetArn;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private CampaignSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.signalCatalogArn = builder.signalCatalogArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a campaign.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of a campaign.
     * </p>
     * 
     * @return The name of a campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the campaign.
     * </p>
     * 
     * @return The description of the campaign.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the signal catalog associated with the campaign.
     * </p>
     * 
     * @return The ARN of the signal catalog associated with the campaign.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * <p>
     * The ARN of a vehicle or fleet to which the campaign is deployed.
     * </p>
     * 
     * @return The ARN of a vehicle or fleet to which the campaign is deployed.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The state of a campaign. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the <code>WAITING_FOR_APPROVAL</code>
     * state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the
     * API operation to approve the campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> - The campaign is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of a campaign. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the
     *         campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
     *         <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the
     *         campaign to the target vehicle or fleet, use the API operation to approve the campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - The campaign is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
     *         </p>
     *         </li>
     * @see CampaignStatus
     */
    public final CampaignStatus status() {
        return CampaignStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of a campaign. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the <code>WAITING_FOR_APPROVAL</code>
     * state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the
     * API operation to approve the campaign.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> - The campaign is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of a campaign. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the
     *         campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
     *         <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the
     *         campaign to the target vehicle or fleet, use the API operation to approve the campaign.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - The campaign is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
     *         </p>
     *         </li>
     * @see CampaignStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the campaign was created.
     * </p>
     * 
     * @return The time the campaign was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the campaign was modified.
     * </p>
     * 
     * @return The last time the campaign was modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSummary)) {
            return false;
        }
        CampaignSummary other = (CampaignSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignSummary").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("SignalCatalogArn", signalCatalogArn()).add("TargetArn", targetArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignSummary, T> g) {
        return obj -> g.apply((CampaignSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a campaign.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of a campaign.
         * </p>
         * 
         * @param name
         *        The name of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the campaign.
         * </p>
         * 
         * @param description
         *        The description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the signal catalog associated with the campaign.
         * </p>
         * 
         * @param signalCatalogArn
         *        The ARN of the signal catalog associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * The ARN of a vehicle or fleet to which the campaign is deployed.
         * </p>
         * 
         * @param targetArn
         *        The ARN of a vehicle or fleet to which the campaign is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The state of a campaign. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
         * <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to
         * the target vehicle or fleet, use the API operation to approve the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> - The campaign is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The state of a campaign. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the
         *        campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
         *        <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the
         *        campaign to the target vehicle or fleet, use the API operation to approve the campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - The campaign is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
         *        </p>
         *        </li>
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of a campaign. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
         * <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to
         * the target vehicle or fleet, use the API operation to approve the campaign.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> - The campaign is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The state of a campaign. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the
         *        campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the
         *        <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the
         *        campaign to the target vehicle or fleet, use the API operation to approve the campaign.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - The campaign is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation.
         *        </p>
         *        </li>
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder status(CampaignStatus status);

        /**
         * <p>
         * The time the campaign was created.
         * </p>
         * 
         * @param creationTime
         *        The time the campaign was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the campaign was modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The last time the campaign was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String signalCatalogArn;

        private String targetArn;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSummary model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            signalCatalogArn(model.signalCatalogArn);
            targetArn(model.targetArn);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CampaignStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public CampaignSummary build() {
            return new CampaignSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
