/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations used to create a decoder manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanDbcDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<CanDbcDefinition.Builder, CanDbcDefinition> {
    private static final SdkField<String> NETWORK_INTERFACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkInterface").getter(getter(CanDbcDefinition::networkInterface))
            .setter(setter(Builder::networkInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()).build();

    private static final SdkField<List<SdkBytes>> CAN_DBC_FILES_FIELD = SdkField
            .<List<SdkBytes>> builder(MarshallingType.LIST)
            .memberName("canDbcFiles")
            .getter(getter(CanDbcDefinition::canDbcFiles))
            .setter(setter(Builder::canDbcFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canDbcFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SIGNALS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("signalsMap")
            .getter(getter(CanDbcDefinition::signalsMap))
            .setter(setter(Builder::signalsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_FIELD,
            CAN_DBC_FILES_FIELD, SIGNALS_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkInterface;

    private final List<SdkBytes> canDbcFiles;

    private final Map<String, String> signalsMap;

    private CanDbcDefinition(BuilderImpl builder) {
        this.networkInterface = builder.networkInterface;
        this.canDbcFiles = builder.canDbcFiles;
        this.signalsMap = builder.signalsMap;
    }

    /**
     * <p>
     * Contains information about a network interface.
     * </p>
     * 
     * @return Contains information about a network interface.
     */
    public final String networkInterface() {
        return networkInterface;
    }

    /**
     * For responses, this returns true if the service returned a value for the CanDbcFiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCanDbcFiles() {
        return canDbcFiles != null && !(canDbcFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DBC files. You can upload only one DBC file for each network interface and specify up to five
     * (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCanDbcFiles} method.
     * </p>
     * 
     * @return A list of DBC files. You can upload only one DBC file for each network interface and specify up to five
     *         (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
     */
    public final List<SdkBytes> canDbcFiles() {
        return canDbcFiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalsMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSignalsMap() {
        return signalsMap != null && !(signalsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Pairs every signal specified in your vehicle model with a signal decoder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalsMap} method.
     * </p>
     * 
     * @return Pairs every signal specified in your vehicle model with a signal decoder.
     */
    public final Map<String, String> signalsMap() {
        return signalsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(hasCanDbcFiles() ? canDbcFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalsMap() ? signalsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanDbcDefinition)) {
            return false;
        }
        CanDbcDefinition other = (CanDbcDefinition) obj;
        return Objects.equals(networkInterface(), other.networkInterface()) && hasCanDbcFiles() == other.hasCanDbcFiles()
                && Objects.equals(canDbcFiles(), other.canDbcFiles()) && hasSignalsMap() == other.hasSignalsMap()
                && Objects.equals(signalsMap(), other.signalsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanDbcDefinition").add("NetworkInterface", networkInterface())
                .add("CanDbcFiles", hasCanDbcFiles() ? canDbcFiles() : null)
                .add("SignalsMap", hasSignalsMap() ? signalsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkInterface":
            return Optional.ofNullable(clazz.cast(networkInterface()));
        case "canDbcFiles":
            return Optional.ofNullable(clazz.cast(canDbcFiles()));
        case "signalsMap":
            return Optional.ofNullable(clazz.cast(signalsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkInterface", NETWORK_INTERFACE_FIELD);
        map.put("canDbcFiles", CAN_DBC_FILES_FIELD);
        map.put("signalsMap", SIGNALS_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanDbcDefinition, T> g) {
        return obj -> g.apply((CanDbcDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanDbcDefinition> {
        /**
         * <p>
         * Contains information about a network interface.
         * </p>
         * 
         * @param networkInterface
         *        Contains information about a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(String networkInterface);

        /**
         * <p>
         * A list of DBC files. You can upload only one DBC file for each network interface and specify up to five
         * (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
         * </p>
         * 
         * @param canDbcFiles
         *        A list of DBC files. You can upload only one DBC file for each network interface and specify up to
         *        five (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canDbcFiles(Collection<SdkBytes> canDbcFiles);

        /**
         * <p>
         * A list of DBC files. You can upload only one DBC file for each network interface and specify up to five
         * (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
         * </p>
         * 
         * @param canDbcFiles
         *        A list of DBC files. You can upload only one DBC file for each network interface and specify up to
         *        five (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canDbcFiles(SdkBytes... canDbcFiles);

        /**
         * <p>
         * Pairs every signal specified in your vehicle model with a signal decoder.
         * </p>
         * 
         * @param signalsMap
         *        Pairs every signal specified in your vehicle model with a signal decoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalsMap(Map<String, String> signalsMap);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterface;

        private List<SdkBytes> canDbcFiles = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> signalsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanDbcDefinition model) {
            networkInterface(model.networkInterface);
            canDbcFiles(model.canDbcFiles);
            signalsMap(model.signalsMap);
        }

        public final String getNetworkInterface() {
            return networkInterface;
        }

        public final void setNetworkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
        }

        @Override
        public final Builder networkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final List<ByteBuffer> getCanDbcFiles() {
            if (canDbcFiles instanceof SdkAutoConstructList) {
                return null;
            }
            return canDbcFiles == null ? null : canDbcFiles.stream().map(SdkBytes::asByteBuffer).collect(Collectors.toList());
        }

        public final void setCanDbcFiles(Collection<ByteBuffer> canDbcFiles) {
            canDbcFiles(canDbcFiles == null ? null : canDbcFiles.stream().map(SdkBytes::fromByteBuffer)
                    .collect(Collectors.toList()));
        }

        @Override
        public final Builder canDbcFiles(Collection<SdkBytes> canDbcFiles) {
            this.canDbcFiles = NetworkFilesListCopier.copy(canDbcFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canDbcFiles(SdkBytes... canDbcFiles) {
            canDbcFiles(Arrays.asList(canDbcFiles));
            return this;
        }

        public final Map<String, String> getSignalsMap() {
            if (signalsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return signalsMap;
        }

        public final void setSignalsMap(Map<String, String> signalsMap) {
            this.signalsMap = ModelSignalsMapCopier.copy(signalsMap);
        }

        @Override
        public final Builder signalsMap(Map<String, String> signalsMap) {
            this.signalsMap = ModelSignalsMapCopier.copy(signalsMap);
            return this;
        }

        @Override
        public CanDbcDefinition build() {
            return new CanDbcDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
