/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a single controller area network (CAN) signal and the messages it receives and transmits.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanSignal implements SdkPojo, Serializable, ToCopyableBuilder<CanSignal.Builder, CanSignal> {
    private static final SdkField<Integer> MESSAGE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("messageId").getter(getter(CanSignal::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<Boolean> IS_BIG_ENDIAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isBigEndian").getter(getter(CanSignal::isBigEndian)).setter(setter(Builder::isBigEndian))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBigEndian").build()).build();

    private static final SdkField<Boolean> IS_SIGNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSigned").getter(getter(CanSignal::isSigned)).setter(setter(Builder::isSigned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSigned").build()).build();

    private static final SdkField<Integer> START_BIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startBit").getter(getter(CanSignal::startBit)).setter(setter(Builder::startBit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startBit").build()).build();

    private static final SdkField<Double> OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("offset")
            .getter(getter(CanSignal::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<Double> FACTOR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("factor")
            .getter(getter(CanSignal::factor)).setter(setter(Builder::factor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("factor").build()).build();

    private static final SdkField<Integer> LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("length").getter(getter(CanSignal::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CanSignal::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SIGNAL_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalValueType").getter(getter(CanSignal::signalValueTypeAsString))
            .setter(setter(Builder::signalValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalValueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            IS_BIG_ENDIAN_FIELD, IS_SIGNED_FIELD, START_BIT_FIELD, OFFSET_FIELD, FACTOR_FIELD, LENGTH_FIELD, NAME_FIELD,
            SIGNAL_VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer messageId;

    private final Boolean isBigEndian;

    private final Boolean isSigned;

    private final Integer startBit;

    private final Double offset;

    private final Double factor;

    private final Integer length;

    private final String name;

    private final String signalValueType;

    private CanSignal(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.isBigEndian = builder.isBigEndian;
        this.isSigned = builder.isSigned;
        this.startBit = builder.startBit;
        this.offset = builder.offset;
        this.factor = builder.factor;
        this.length = builder.length;
        this.name = builder.name;
        this.signalValueType = builder.signalValueType;
    }

    /**
     * <p>
     * The ID of the message.
     * </p>
     * 
     * @return The ID of the message.
     */
    public final Integer messageId() {
        return messageId;
    }

    /**
     * <p>
     * Whether the byte ordering of a CAN message is big-endian.
     * </p>
     * 
     * @return Whether the byte ordering of a CAN message is big-endian.
     */
    public final Boolean isBigEndian() {
        return isBigEndian;
    }

    /**
     * <p>
     * Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed, the
     * message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the
     * <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type.
     * </p>
     * 
     * @return Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed,
     *         the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only
     *         applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the
     *         <code>FLOATING_POINT</code> raw signal type.
     */
    public final Boolean isSigned() {
        return isSigned;
    }

    /**
     * <p>
     * Indicates the beginning of the CAN signal. This should always be the least significant bit (LSB).
     * </p>
     * <p>
     * This value might be different from the value in a DBC file. For little endian signals, <code>startBit</code> is
     * the same value as in the DBC file. For big endian signals in a DBC file, the start bit is the most significant
     * bit (MSB). You will have to calculate the LSB instead and pass it as the <code>startBit</code>.
     * </p>
     * 
     * @return Indicates the beginning of the CAN signal. This should always be the least significant bit (LSB).</p>
     *         <p>
     *         This value might be different from the value in a DBC file. For little endian signals,
     *         <code>startBit</code> is the same value as in the DBC file. For big endian signals in a DBC file, the
     *         start bit is the most significant bit (MSB). You will have to calculate the LSB instead and pass it as
     *         the <code>startBit</code>.
     */
    public final Integer startBit() {
        return startBit;
    }

    /**
     * <p>
     * The offset used to calculate the signal value. Combined with factor, the calculation is
     * <code>value = raw_value * factor + offset</code>.
     * </p>
     * 
     * @return The offset used to calculate the signal value. Combined with factor, the calculation is
     *         <code>value = raw_value * factor + offset</code>.
     */
    public final Double offset() {
        return offset;
    }

    /**
     * <p>
     * A multiplier used to decode the CAN message.
     * </p>
     * 
     * @return A multiplier used to decode the CAN message.
     */
    public final Double factor() {
        return factor;
    }

    /**
     * <p>
     * How many bytes of data are in the message.
     * </p>
     * 
     * @return How many bytes of data are in the message.
     */
    public final Integer length() {
        return length;
    }

    /**
     * <p>
     * The name of the signal.
     * </p>
     * 
     * @return The name of the signal.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value type of the signal. The default value is <code>INTEGER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalValueType}
     * will return {@link SignalValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signalValueTypeAsString}.
     * </p>
     * 
     * @return The value type of the signal. The default value is <code>INTEGER</code>.
     * @see SignalValueType
     */
    public final SignalValueType signalValueType() {
        return SignalValueType.fromValue(signalValueType);
    }

    /**
     * <p>
     * The value type of the signal. The default value is <code>INTEGER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalValueType}
     * will return {@link SignalValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signalValueTypeAsString}.
     * </p>
     * 
     * @return The value type of the signal. The default value is <code>INTEGER</code>.
     * @see SignalValueType
     */
    public final String signalValueTypeAsString() {
        return signalValueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(isBigEndian());
        hashCode = 31 * hashCode + Objects.hashCode(isSigned());
        hashCode = 31 * hashCode + Objects.hashCode(startBit());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(factor());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(signalValueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanSignal)) {
            return false;
        }
        CanSignal other = (CanSignal) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(isBigEndian(), other.isBigEndian())
                && Objects.equals(isSigned(), other.isSigned()) && Objects.equals(startBit(), other.startBit())
                && Objects.equals(offset(), other.offset()) && Objects.equals(factor(), other.factor())
                && Objects.equals(length(), other.length()) && Objects.equals(name(), other.name())
                && Objects.equals(signalValueTypeAsString(), other.signalValueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanSignal").add("MessageId", messageId()).add("IsBigEndian", isBigEndian())
                .add("IsSigned", isSigned()).add("StartBit", startBit()).add("Offset", offset()).add("Factor", factor())
                .add("Length", length()).add("Name", name()).add("SignalValueType", signalValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "isBigEndian":
            return Optional.ofNullable(clazz.cast(isBigEndian()));
        case "isSigned":
            return Optional.ofNullable(clazz.cast(isSigned()));
        case "startBit":
            return Optional.ofNullable(clazz.cast(startBit()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "factor":
            return Optional.ofNullable(clazz.cast(factor()));
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "signalValueType":
            return Optional.ofNullable(clazz.cast(signalValueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("isBigEndian", IS_BIG_ENDIAN_FIELD);
        map.put("isSigned", IS_SIGNED_FIELD);
        map.put("startBit", START_BIT_FIELD);
        map.put("offset", OFFSET_FIELD);
        map.put("factor", FACTOR_FIELD);
        map.put("length", LENGTH_FIELD);
        map.put("name", NAME_FIELD);
        map.put("signalValueType", SIGNAL_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanSignal, T> g) {
        return obj -> g.apply((CanSignal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanSignal> {
        /**
         * <p>
         * The ID of the message.
         * </p>
         * 
         * @param messageId
         *        The ID of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(Integer messageId);

        /**
         * <p>
         * Whether the byte ordering of a CAN message is big-endian.
         * </p>
         * 
         * @param isBigEndian
         *        Whether the byte ordering of a CAN message is big-endian.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBigEndian(Boolean isBigEndian);

        /**
         * <p>
         * Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed, the
         * message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to
         * the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal
         * type.
         * </p>
         * 
         * @param isSigned
         *        Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's
         *        signed, the message can represent both positive and negative numbers. The <code>isSigned</code>
         *        parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the
         *        <code>FLOATING_POINT</code> raw signal type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSigned(Boolean isSigned);

        /**
         * <p>
         * Indicates the beginning of the CAN signal. This should always be the least significant bit (LSB).
         * </p>
         * <p>
         * This value might be different from the value in a DBC file. For little endian signals, <code>startBit</code>
         * is the same value as in the DBC file. For big endian signals in a DBC file, the start bit is the most
         * significant bit (MSB). You will have to calculate the LSB instead and pass it as the <code>startBit</code>.
         * </p>
         * 
         * @param startBit
         *        Indicates the beginning of the CAN signal. This should always be the least significant bit (LSB).</p>
         *        <p>
         *        This value might be different from the value in a DBC file. For little endian signals,
         *        <code>startBit</code> is the same value as in the DBC file. For big endian signals in a DBC file, the
         *        start bit is the most significant bit (MSB). You will have to calculate the LSB instead and pass it as
         *        the <code>startBit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startBit(Integer startBit);

        /**
         * <p>
         * The offset used to calculate the signal value. Combined with factor, the calculation is
         * <code>value = raw_value * factor + offset</code>.
         * </p>
         * 
         * @param offset
         *        The offset used to calculate the signal value. Combined with factor, the calculation is
         *        <code>value = raw_value * factor + offset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Double offset);

        /**
         * <p>
         * A multiplier used to decode the CAN message.
         * </p>
         * 
         * @param factor
         *        A multiplier used to decode the CAN message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factor(Double factor);

        /**
         * <p>
         * How many bytes of data are in the message.
         * </p>
         * 
         * @param length
         *        How many bytes of data are in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Integer length);

        /**
         * <p>
         * The name of the signal.
         * </p>
         * 
         * @param name
         *        The name of the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value type of the signal. The default value is <code>INTEGER</code>.
         * </p>
         * 
         * @param signalValueType
         *        The value type of the signal. The default value is <code>INTEGER</code>.
         * @see SignalValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalValueType
         */
        Builder signalValueType(String signalValueType);

        /**
         * <p>
         * The value type of the signal. The default value is <code>INTEGER</code>.
         * </p>
         * 
         * @param signalValueType
         *        The value type of the signal. The default value is <code>INTEGER</code>.
         * @see SignalValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalValueType
         */
        Builder signalValueType(SignalValueType signalValueType);
    }

    static final class BuilderImpl implements Builder {
        private Integer messageId;

        private Boolean isBigEndian;

        private Boolean isSigned;

        private Integer startBit;

        private Double offset;

        private Double factor;

        private Integer length;

        private String name;

        private String signalValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(CanSignal model) {
            messageId(model.messageId);
            isBigEndian(model.isBigEndian);
            isSigned(model.isSigned);
            startBit(model.startBit);
            offset(model.offset);
            factor(model.factor);
            length(model.length);
            name(model.name);
            signalValueType(model.signalValueType);
        }

        public final Integer getMessageId() {
            return messageId;
        }

        public final void setMessageId(Integer messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Boolean getIsBigEndian() {
            return isBigEndian;
        }

        public final void setIsBigEndian(Boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public final Builder isBigEndian(Boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
            return this;
        }

        public final Boolean getIsSigned() {
            return isSigned;
        }

        public final void setIsSigned(Boolean isSigned) {
            this.isSigned = isSigned;
        }

        @Override
        public final Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            return this;
        }

        public final Integer getStartBit() {
            return startBit;
        }

        public final void setStartBit(Integer startBit) {
            this.startBit = startBit;
        }

        @Override
        public final Builder startBit(Integer startBit) {
            this.startBit = startBit;
            return this;
        }

        public final Double getOffset() {
            return offset;
        }

        public final void setOffset(Double offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Double offset) {
            this.offset = offset;
            return this;
        }

        public final Double getFactor() {
            return factor;
        }

        public final void setFactor(Double factor) {
            this.factor = factor;
        }

        @Override
        public final Builder factor(Double factor) {
            this.factor = factor;
            return this;
        }

        public final Integer getLength() {
            return length;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSignalValueType() {
            return signalValueType;
        }

        public final void setSignalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
        }

        @Override
        public final Builder signalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
            return this;
        }

        @Override
        public final Builder signalValueType(SignalValueType signalValueType) {
            this.signalValueType(signalValueType == null ? null : signalValueType.toString());
            return this;
        }

        @Override
        public CanSignal build() {
            return new CanSignal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
