/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies what data to collect and how often or when to collect it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectionScheme implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectionScheme.Builder, CollectionScheme> {
    private static final SdkField<TimeBasedCollectionScheme> TIME_BASED_COLLECTION_SCHEME_FIELD = SdkField
            .<TimeBasedCollectionScheme> builder(MarshallingType.SDK_POJO).memberName("timeBasedCollectionScheme")
            .getter(getter(CollectionScheme::timeBasedCollectionScheme)).setter(setter(Builder::timeBasedCollectionScheme))
            .constructor(TimeBasedCollectionScheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedCollectionScheme").build())
            .build();

    private static final SdkField<ConditionBasedCollectionScheme> CONDITION_BASED_COLLECTION_SCHEME_FIELD = SdkField
            .<ConditionBasedCollectionScheme> builder(MarshallingType.SDK_POJO)
            .memberName("conditionBasedCollectionScheme")
            .getter(getter(CollectionScheme::conditionBasedCollectionScheme))
            .setter(setter(Builder::conditionBasedCollectionScheme))
            .constructor(ConditionBasedCollectionScheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionBasedCollectionScheme")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIME_BASED_COLLECTION_SCHEME_FIELD, CONDITION_BASED_COLLECTION_SCHEME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimeBasedCollectionScheme timeBasedCollectionScheme;

    private final ConditionBasedCollectionScheme conditionBasedCollectionScheme;

    private final Type type;

    private CollectionScheme(BuilderImpl builder) {
        this.timeBasedCollectionScheme = builder.timeBasedCollectionScheme;
        this.conditionBasedCollectionScheme = builder.conditionBasedCollectionScheme;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a collection scheme that uses a time period to decide how often to collect data.
     * </p>
     * 
     * @return Information about a collection scheme that uses a time period to decide how often to collect data.
     */
    public final TimeBasedCollectionScheme timeBasedCollectionScheme() {
        return timeBasedCollectionScheme;
    }

    /**
     * <p>
     * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
     * </p>
     * 
     * @return Information about a collection scheme that uses a simple logical expression to recognize what data to
     *         collect.
     */
    public final ConditionBasedCollectionScheme conditionBasedCollectionScheme() {
        return conditionBasedCollectionScheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeBasedCollectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(conditionBasedCollectionScheme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionScheme)) {
            return false;
        }
        CollectionScheme other = (CollectionScheme) obj;
        return Objects.equals(timeBasedCollectionScheme(), other.timeBasedCollectionScheme())
                && Objects.equals(conditionBasedCollectionScheme(), other.conditionBasedCollectionScheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectionScheme").add("TimeBasedCollectionScheme", timeBasedCollectionScheme())
                .add("ConditionBasedCollectionScheme", conditionBasedCollectionScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeBasedCollectionScheme":
            return Optional.ofNullable(clazz.cast(timeBasedCollectionScheme()));
        case "conditionBasedCollectionScheme":
            return Optional.ofNullable(clazz.cast(conditionBasedCollectionScheme()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #timeBasedCollectionScheme()} initialized to the given value.
     *
     * <p>
     * Information about a collection scheme that uses a time period to decide how often to collect data.
     * </p>
     * 
     * @param timeBasedCollectionScheme
     *        Information about a collection scheme that uses a time period to decide how often to collect data.
     */
    public static CollectionScheme fromTimeBasedCollectionScheme(TimeBasedCollectionScheme timeBasedCollectionScheme) {
        return builder().timeBasedCollectionScheme(timeBasedCollectionScheme).build();
    }

    /**
     * Create an instance of this class with {@link #timeBasedCollectionScheme()} initialized to the given value.
     *
     * <p>
     * Information about a collection scheme that uses a time period to decide how often to collect data.
     * </p>
     * 
     * @param timeBasedCollectionScheme
     *        Information about a collection scheme that uses a time period to decide how often to collect data.
     */
    public static CollectionScheme fromTimeBasedCollectionScheme(
            Consumer<TimeBasedCollectionScheme.Builder> timeBasedCollectionScheme) {
        TimeBasedCollectionScheme.Builder builder = TimeBasedCollectionScheme.builder();
        timeBasedCollectionScheme.accept(builder);
        return fromTimeBasedCollectionScheme(builder.build());
    }

    /**
     * Create an instance of this class with {@link #conditionBasedCollectionScheme()} initialized to the given value.
     *
     * <p>
     * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
     * </p>
     * 
     * @param conditionBasedCollectionScheme
     *        Information about a collection scheme that uses a simple logical expression to recognize what data to
     *        collect.
     */
    public static CollectionScheme fromConditionBasedCollectionScheme(
            ConditionBasedCollectionScheme conditionBasedCollectionScheme) {
        return builder().conditionBasedCollectionScheme(conditionBasedCollectionScheme).build();
    }

    /**
     * Create an instance of this class with {@link #conditionBasedCollectionScheme()} initialized to the given value.
     *
     * <p>
     * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
     * </p>
     * 
     * @param conditionBasedCollectionScheme
     *        Information about a collection scheme that uses a simple logical expression to recognize what data to
     *        collect.
     */
    public static CollectionScheme fromConditionBasedCollectionScheme(
            Consumer<ConditionBasedCollectionScheme.Builder> conditionBasedCollectionScheme) {
        ConditionBasedCollectionScheme.Builder builder = ConditionBasedCollectionScheme.builder();
        conditionBasedCollectionScheme.accept(builder);
        return fromConditionBasedCollectionScheme(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeBasedCollectionScheme", TIME_BASED_COLLECTION_SCHEME_FIELD);
        map.put("conditionBasedCollectionScheme", CONDITION_BASED_COLLECTION_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionScheme, T> g) {
        return obj -> g.apply((CollectionScheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectionScheme> {
        /**
         * <p>
         * Information about a collection scheme that uses a time period to decide how often to collect data.
         * </p>
         * 
         * @param timeBasedCollectionScheme
         *        Information about a collection scheme that uses a time period to decide how often to collect data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBasedCollectionScheme(TimeBasedCollectionScheme timeBasedCollectionScheme);

        /**
         * <p>
         * Information about a collection scheme that uses a time period to decide how often to collect data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeBasedCollectionScheme.Builder}
         * avoiding the need to create one manually via {@link TimeBasedCollectionScheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeBasedCollectionScheme.Builder#build()} is called immediately
         * and its result is passed to {@link #timeBasedCollectionScheme(TimeBasedCollectionScheme)}.
         * 
         * @param timeBasedCollectionScheme
         *        a consumer that will call methods on {@link TimeBasedCollectionScheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeBasedCollectionScheme(TimeBasedCollectionScheme)
         */
        default Builder timeBasedCollectionScheme(Consumer<TimeBasedCollectionScheme.Builder> timeBasedCollectionScheme) {
            return timeBasedCollectionScheme(TimeBasedCollectionScheme.builder().applyMutation(timeBasedCollectionScheme).build());
        }

        /**
         * <p>
         * Information about a collection scheme that uses a simple logical expression to recognize what data to
         * collect.
         * </p>
         * 
         * @param conditionBasedCollectionScheme
         *        Information about a collection scheme that uses a simple logical expression to recognize what data to
         *        collect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionBasedCollectionScheme(ConditionBasedCollectionScheme conditionBasedCollectionScheme);

        /**
         * <p>
         * Information about a collection scheme that uses a simple logical expression to recognize what data to
         * collect.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionBasedCollectionScheme.Builder}
         * avoiding the need to create one manually via {@link ConditionBasedCollectionScheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionBasedCollectionScheme.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #conditionBasedCollectionScheme(ConditionBasedCollectionScheme)}.
         * 
         * @param conditionBasedCollectionScheme
         *        a consumer that will call methods on {@link ConditionBasedCollectionScheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionBasedCollectionScheme(ConditionBasedCollectionScheme)
         */
        default Builder conditionBasedCollectionScheme(
                Consumer<ConditionBasedCollectionScheme.Builder> conditionBasedCollectionScheme) {
            return conditionBasedCollectionScheme(ConditionBasedCollectionScheme.builder()
                    .applyMutation(conditionBasedCollectionScheme).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeBasedCollectionScheme timeBasedCollectionScheme;

        private ConditionBasedCollectionScheme conditionBasedCollectionScheme;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionScheme model) {
            timeBasedCollectionScheme(model.timeBasedCollectionScheme);
            conditionBasedCollectionScheme(model.conditionBasedCollectionScheme);
        }

        public final TimeBasedCollectionScheme.Builder getTimeBasedCollectionScheme() {
            return timeBasedCollectionScheme != null ? timeBasedCollectionScheme.toBuilder() : null;
        }

        public final void setTimeBasedCollectionScheme(TimeBasedCollectionScheme.BuilderImpl timeBasedCollectionScheme) {
            Object oldValue = this.timeBasedCollectionScheme;
            this.timeBasedCollectionScheme = timeBasedCollectionScheme != null ? timeBasedCollectionScheme.build() : null;
            handleUnionValueChange(Type.TIME_BASED_COLLECTION_SCHEME, oldValue, this.timeBasedCollectionScheme);
        }

        @Override
        public final Builder timeBasedCollectionScheme(TimeBasedCollectionScheme timeBasedCollectionScheme) {
            Object oldValue = this.timeBasedCollectionScheme;
            this.timeBasedCollectionScheme = timeBasedCollectionScheme;
            handleUnionValueChange(Type.TIME_BASED_COLLECTION_SCHEME, oldValue, this.timeBasedCollectionScheme);
            return this;
        }

        public final ConditionBasedCollectionScheme.Builder getConditionBasedCollectionScheme() {
            return conditionBasedCollectionScheme != null ? conditionBasedCollectionScheme.toBuilder() : null;
        }

        public final void setConditionBasedCollectionScheme(
                ConditionBasedCollectionScheme.BuilderImpl conditionBasedCollectionScheme) {
            Object oldValue = this.conditionBasedCollectionScheme;
            this.conditionBasedCollectionScheme = conditionBasedCollectionScheme != null ? conditionBasedCollectionScheme.build()
                    : null;
            handleUnionValueChange(Type.CONDITION_BASED_COLLECTION_SCHEME, oldValue, this.conditionBasedCollectionScheme);
        }

        @Override
        public final Builder conditionBasedCollectionScheme(ConditionBasedCollectionScheme conditionBasedCollectionScheme) {
            Object oldValue = this.conditionBasedCollectionScheme;
            this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
            handleUnionValueChange(Type.CONDITION_BASED_COLLECTION_SCHEME, oldValue, this.conditionBasedCollectionScheme);
            return this;
        }

        @Override
        public CollectionScheme build() {
            return new CollectionScheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CollectionScheme#type()
     */
    public enum Type {
        TIME_BASED_COLLECTION_SCHEME,

        CONDITION_BASED_COLLECTION_SCHEME,

        UNKNOWN_TO_SDK_VERSION
    }
}
