/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The upload options for the data partition. If upload options are specified, you must also specify storage options.
 * See <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DataPartitionStorageOptions.html">
 * DataPartitionStorageOptions</a>.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPartitionUploadOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPartitionUploadOptions.Builder, DataPartitionUploadOptions> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(DataPartitionUploadOptions::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<Integer> CONDITION_LANGUAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("conditionLanguageVersion").getter(getter(DataPartitionUploadOptions::conditionLanguageVersion))
            .setter(setter(Builder::conditionLanguageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionLanguageVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            CONDITION_LANGUAGE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final Integer conditionLanguageVersion;

    private DataPartitionUploadOptions(BuilderImpl builder) {
        this.expression = builder.expression;
        this.conditionLanguageVersion = builder.conditionLanguageVersion;
    }

    /**
     * <p>
     * The logical expression used to recognize what data to collect. For example,
     * <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
     * </p>
     * 
     * @return The logical expression used to recognize what data to collect. For example,
     *         <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The version of the condition language. Defaults to the most recent condition language version.
     * </p>
     * 
     * @return The version of the condition language. Defaults to the most recent condition language version.
     */
    public final Integer conditionLanguageVersion() {
        return conditionLanguageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(conditionLanguageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPartitionUploadOptions)) {
            return false;
        }
        DataPartitionUploadOptions other = (DataPartitionUploadOptions) obj;
        return Objects.equals(expression(), other.expression())
                && Objects.equals(conditionLanguageVersion(), other.conditionLanguageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPartitionUploadOptions")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConditionLanguageVersion", conditionLanguageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "conditionLanguageVersion":
            return Optional.ofNullable(clazz.cast(conditionLanguageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("conditionLanguageVersion", CONDITION_LANGUAGE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPartitionUploadOptions, T> g) {
        return obj -> g.apply((DataPartitionUploadOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPartitionUploadOptions> {
        /**
         * <p>
         * The logical expression used to recognize what data to collect. For example,
         * <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
         * </p>
         * 
         * @param expression
         *        The logical expression used to recognize what data to collect. For example,
         *        <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The version of the condition language. Defaults to the most recent condition language version.
         * </p>
         * 
         * @param conditionLanguageVersion
         *        The version of the condition language. Defaults to the most recent condition language version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionLanguageVersion(Integer conditionLanguageVersion);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private Integer conditionLanguageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPartitionUploadOptions model) {
            expression(model.expression);
            conditionLanguageVersion(model.conditionLanguageVersion);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Integer getConditionLanguageVersion() {
            return conditionLanguageVersion;
        }

        public final void setConditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
        }

        @Override
        public final Builder conditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            return this;
        }

        @Override
        public DataPartitionUploadOptions build() {
            return new DataPartitionUploadOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
