/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reason a vehicle network interface isn't valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidNetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidNetworkInterface.Builder, InvalidNetworkInterface> {
    private static final SdkField<String> INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceId").getter(getter(InvalidNetworkInterface::interfaceId)).setter(setter(Builder::interfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(InvalidNetworkInterface::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_ID_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interfaceId;

    private final String reason;

    private InvalidNetworkInterface(BuilderImpl builder) {
        this.interfaceId = builder.interfaceId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The ID of the interface that isn't valid.
     * </p>
     * 
     * @return The ID of the interface that isn't valid.
     */
    public final String interfaceId() {
        return interfaceId;
    }

    /**
     * <p>
     * A message about why the interface isn't valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link NetworkInterfaceFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return A message about why the interface isn't valid.
     * @see NetworkInterfaceFailureReason
     */
    public final NetworkInterfaceFailureReason reason() {
        return NetworkInterfaceFailureReason.fromValue(reason);
    }

    /**
     * <p>
     * A message about why the interface isn't valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link NetworkInterfaceFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return A message about why the interface isn't valid.
     * @see NetworkInterfaceFailureReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidNetworkInterface)) {
            return false;
        }
        InvalidNetworkInterface other = (InvalidNetworkInterface) obj;
        return Objects.equals(interfaceId(), other.interfaceId()) && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidNetworkInterface").add("InterfaceId", interfaceId()).add("Reason", reasonAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interfaceId":
            return Optional.ofNullable(clazz.cast(interfaceId()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interfaceId", INTERFACE_ID_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidNetworkInterface, T> g) {
        return obj -> g.apply((InvalidNetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidNetworkInterface> {
        /**
         * <p>
         * The ID of the interface that isn't valid.
         * </p>
         * 
         * @param interfaceId
         *        The ID of the interface that isn't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceId(String interfaceId);

        /**
         * <p>
         * A message about why the interface isn't valid.
         * </p>
         * 
         * @param reason
         *        A message about why the interface isn't valid.
         * @see NetworkInterfaceFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceFailureReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * A message about why the interface isn't valid.
         * </p>
         * 
         * @param reason
         *        A message about why the interface isn't valid.
         * @see NetworkInterfaceFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceFailureReason
         */
        Builder reason(NetworkInterfaceFailureReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String interfaceId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNetworkInterface model) {
            interfaceId(model.interfaceId);
            reason(model.reason);
        }

        public final String getInterfaceId() {
            return interfaceId;
        }

        public final void setInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
        }

        @Override
        public final Builder interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(NetworkInterfaceFailureReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public InvalidNetworkInterface build() {
            return new InvalidNetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
