/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified node type doesn't match the expected node type for a node. You can specify the node type as branch,
 * sensor, actuator, or attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidNodeException extends IoTFleetWiseException implements
        ToCopyableBuilder<InvalidNodeException.Builder, InvalidNodeException> {
    private static final SdkField<List<Node>> INVALID_NODES_FIELD = SdkField
            .<List<Node>> builder(MarshallingType.LIST)
            .memberName("invalidNodes")
            .getter(getter(InvalidNodeException::invalidNodes))
            .setter(setter(Builder::invalidNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Node> builder(MarshallingType.SDK_POJO)
                                            .constructor(Node::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(InvalidNodeException::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_NODES_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Node> invalidNodes;

    private final String reason;

    private InvalidNodeException(BuilderImpl builder) {
        super(builder);
        this.invalidNodes = builder.invalidNodes;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidNodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasInvalidNodes() {
        return invalidNodes != null && !(invalidNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specified node type isn't valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidNodes} method.
     * </p>
     * 
     * @return The specified node type isn't valid.
     */
    public List<Node> invalidNodes() {
        return invalidNodes;
    }

    /**
     * <p>
     * The reason the node validation failed.
     * </p>
     * 
     * @return The reason the node validation failed.
     */
    public String reason() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invalidNodes", INVALID_NODES_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidNodeException, T> g) {
        return obj -> g.apply((InvalidNodeException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidNodeException>, IoTFleetWiseException.Builder {
        /**
         * <p>
         * The specified node type isn't valid.
         * </p>
         * 
         * @param invalidNodes
         *        The specified node type isn't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidNodes(Collection<Node> invalidNodes);

        /**
         * <p>
         * The specified node type isn't valid.
         * </p>
         * 
         * @param invalidNodes
         *        The specified node type isn't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidNodes(Node... invalidNodes);

        /**
         * <p>
         * The specified node type isn't valid.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Node#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidNodes(List<Node>)}.
         * 
         * @param invalidNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidNodes(java.util.Collection<Node>)
         */
        Builder invalidNodes(Consumer<Node.Builder>... invalidNodes);

        /**
         * <p>
         * The reason the node validation failed.
         * </p>
         * 
         * @param reason
         *        The reason the node validation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends IoTFleetWiseException.BuilderImpl implements Builder {
        private List<Node> invalidNodes = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNodeException model) {
            super(model);
            invalidNodes(model.invalidNodes);
            reason(model.reason);
        }

        public final List<Node.Builder> getInvalidNodes() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.invalidNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidNodes(Collection<Node.BuilderImpl> invalidNodes) {
            this.invalidNodes = NodesCopier.copyFromBuilder(invalidNodes);
        }

        @Override
        public final Builder invalidNodes(Collection<Node> invalidNodes) {
            this.invalidNodes = NodesCopier.copy(invalidNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNodes(Node... invalidNodes) {
            invalidNodes(Arrays.asList(invalidNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNodes(Consumer<Node.Builder>... invalidNodes) {
            invalidNodes(Stream.of(invalidNodes).map(c -> Node.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidNodeException build() {
            return new InvalidNodeException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
