/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCampaignsRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<ListCampaignsRequest.Builder, ListCampaignsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCampaignsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCampaignsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListCampaignsRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> LIST_RESPONSE_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listResponseScope").getter(getter(ListCampaignsRequest::listResponseScopeAsString))
            .setter(setter(Builder::listResponseScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listResponseScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, STATUS_FIELD, LIST_RESPONSE_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String status;

    private final String listResponseScope;

    private ListCampaignsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.listResponseScope = builder.listResponseScope;
    }

    /**
     * <p>
     * A pagination token for the next set of results.
     * </p>
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next set of results, reissue the search request and
     * include the returned token. When all results have been returned, the response does not contain a pagination token
     * value.
     * </p>
     * 
     * @return A pagination token for the next set of results.</p>
     *         <p>
     *         If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
     *         reissue the search request and include the returned token. When all results have been returned, the
     *         response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return, between 1 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return, between 1 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional parameter to filter the results by the status of each created campaign in your account. The status
     * can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, or
     * <code>SUSPENDED</code>.
     * </p>
     * 
     * @return An optional parameter to filter the results by the status of each created campaign in your account. The
     *         status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, or
     *         <code>SUSPENDED</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
     * includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listResponseScope}
     * will return {@link ListResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #listResponseScopeAsString}.
     * </p>
     * 
     * @return When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
     *         response includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
     * @see ListResponseScope
     */
    public final ListResponseScope listResponseScope() {
        return ListResponseScope.fromValue(listResponseScope);
    }

    /**
     * <p>
     * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
     * includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listResponseScope}
     * will return {@link ListResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #listResponseScopeAsString}.
     * </p>
     * 
     * @return When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
     *         response includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
     * @see ListResponseScope
     */
    public final String listResponseScopeAsString() {
        return listResponseScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(listResponseScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsRequest)) {
            return false;
        }
        ListCampaignsRequest other = (ListCampaignsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(status(), other.status())
                && Objects.equals(listResponseScopeAsString(), other.listResponseScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCampaignsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Status", status()).add("ListResponseScope", listResponseScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "listResponseScope":
            return Optional.ofNullable(clazz.cast(listResponseScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("listResponseScope", LIST_RESPONSE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsRequest, T> g) {
        return obj -> g.apply((ListCampaignsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCampaignsRequest> {
        /**
         * <p>
         * A pagination token for the next set of results.
         * </p>
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next set of results.</p>
         *        <p>
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return, between 1 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return, between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional parameter to filter the results by the status of each created campaign in your account. The
         * status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, or
         * <code>SUSPENDED</code>.
         * </p>
         * 
         * @param status
         *        An optional parameter to filter the results by the status of each created campaign in your account.
         *        The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>,
         *        <code>RUNNING</code>, or <code>SUSPENDED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
         * includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
         * </p>
         * 
         * @param listResponseScope
         *        When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
         *        response includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification
         *        time.
         * @see ListResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListResponseScope
         */
        Builder listResponseScope(String listResponseScope);

        /**
         * <p>
         * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
         * includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification time.
         * </p>
         * 
         * @param listResponseScope
         *        When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
         *        response includes: campaign name, Amazon Resource Name (ARN), creation time, and last modification
         *        time.
         * @see ListResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListResponseScope
         */
        Builder listResponseScope(ListResponseScope listResponseScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String status;

        private String listResponseScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            status(model.status);
            listResponseScope(model.listResponseScope);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getListResponseScope() {
            return listResponseScope;
        }

        public final void setListResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
        }

        @Override
        public final Builder listResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
            return this;
        }

        @Override
        public final Builder listResponseScope(ListResponseScope listResponseScope) {
            this.listResponseScope(listResponseScope == null ? null : listResponseScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCampaignsRequest build() {
            return new ListCampaignsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
