/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelManifestsRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<ListModelManifestsRequest.Builder, ListModelManifestsRequest> {
    private static final SdkField<String> SIGNAL_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalCatalogArn").getter(getter(ListModelManifestsRequest::signalCatalogArn))
            .setter(setter(Builder::signalCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalCatalogArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListModelManifestsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListModelManifestsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LIST_RESPONSE_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listResponseScope").getter(getter(ListModelManifestsRequest::listResponseScopeAsString))
            .setter(setter(Builder::listResponseScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listResponseScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNAL_CATALOG_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIST_RESPONSE_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String signalCatalogArn;

    private final String nextToken;

    private final Integer maxResults;

    private final String listResponseScope;

    private ListModelManifestsRequest(BuilderImpl builder) {
        super(builder);
        this.signalCatalogArn = builder.signalCatalogArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.listResponseScope = builder.listResponseScope;
    }

    /**
     * <p>
     * The ARN of a signal catalog. If you specify a signal catalog, only the vehicle models associated with it are
     * returned.
     * </p>
     * 
     * @return The ARN of a signal catalog. If you specify a signal catalog, only the vehicle models associated with it
     *         are returned.
     */
    public final String signalCatalogArn() {
        return signalCatalogArn;
    }

    /**
     * <p>
     * A pagination token for the next set of results.
     * </p>
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next set of results, reissue the search request and
     * include the returned token. When all results have been returned, the response does not contain a pagination token
     * value.
     * </p>
     * 
     * @return A pagination token for the next set of results.</p>
     *         <p>
     *         If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
     *         reissue the search request and include the returned token. When all results have been returned, the
     *         response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return, between 1 and 100, inclusive.
     * </p>
     * 
     * @return The maximum number of items to return, between 1 and 100, inclusive.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
     * includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listResponseScope}
     * will return {@link ListResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #listResponseScopeAsString}.
     * </p>
     * 
     * @return When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
     *         response includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification
     *         time.
     * @see ListResponseScope
     */
    public final ListResponseScope listResponseScope() {
        return ListResponseScope.fromValue(listResponseScope);
    }

    /**
     * <p>
     * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
     * includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listResponseScope}
     * will return {@link ListResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #listResponseScopeAsString}.
     * </p>
     * 
     * @return When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
     *         response includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification
     *         time.
     * @see ListResponseScope
     */
    public final String listResponseScopeAsString() {
        return listResponseScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signalCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(listResponseScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelManifestsRequest)) {
            return false;
        }
        ListModelManifestsRequest other = (ListModelManifestsRequest) obj;
        return Objects.equals(signalCatalogArn(), other.signalCatalogArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(listResponseScopeAsString(), other.listResponseScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelManifestsRequest").add("SignalCatalogArn", signalCatalogArn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ListResponseScope", listResponseScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signalCatalogArn":
            return Optional.ofNullable(clazz.cast(signalCatalogArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "listResponseScope":
            return Optional.ofNullable(clazz.cast(listResponseScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signalCatalogArn", SIGNAL_CATALOG_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("listResponseScope", LIST_RESPONSE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelManifestsRequest, T> g) {
        return obj -> g.apply((ListModelManifestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelManifestsRequest> {
        /**
         * <p>
         * The ARN of a signal catalog. If you specify a signal catalog, only the vehicle models associated with it are
         * returned.
         * </p>
         * 
         * @param signalCatalogArn
         *        The ARN of a signal catalog. If you specify a signal catalog, only the vehicle models associated with
         *        it are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalCatalogArn(String signalCatalogArn);

        /**
         * <p>
         * A pagination token for the next set of results.
         * </p>
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next set of results.</p>
         *        <p>
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return, between 1 and 100, inclusive.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return, between 1 and 100, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
         * includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification time.
         * </p>
         * 
         * @param listResponseScope
         *        When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
         *        response includes: model manifest name, Amazon Resource Name (ARN), creation time, and last
         *        modification time.
         * @see ListResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListResponseScope
         */
        Builder listResponseScope(String listResponseScope);

        /**
         * <p>
         * When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list response
         * includes: model manifest name, Amazon Resource Name (ARN), creation time, and last modification time.
         * </p>
         * 
         * @param listResponseScope
         *        When you set the <code>listResponseScope</code> parameter to <code>METADATA_ONLY</code>, the list
         *        response includes: model manifest name, Amazon Resource Name (ARN), creation time, and last
         *        modification time.
         * @see ListResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListResponseScope
         */
        Builder listResponseScope(ListResponseScope listResponseScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String signalCatalogArn;

        private String nextToken;

        private Integer maxResults;

        private String listResponseScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelManifestsRequest model) {
            super(model);
            signalCatalogArn(model.signalCatalogArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            listResponseScope(model.listResponseScope);
        }

        public final String getSignalCatalogArn() {
            return signalCatalogArn;
        }

        public final void setSignalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
        }

        @Override
        public final Builder signalCatalogArn(String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getListResponseScope() {
            return listResponseScope;
        }

        public final void setListResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
        }

        @Override
        public final Builder listResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
            return this;
        }

        @Override
        public final Builder listResponseScope(ListResponseScope listResponseScope) {
            this.listResponseScope(listResponseScope == null ? null : listResponseScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelManifestsRequest build() {
            return new ListModelManifestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
