/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum NetworkInterfaceFailureReason {
    DUPLICATE_NETWORK_INTERFACE("DUPLICATE_NETWORK_INTERFACE"),

    CONFLICTING_NETWORK_INTERFACE("CONFLICTING_NETWORK_INTERFACE"),

    NETWORK_INTERFACE_TO_ADD_ALREADY_EXISTS("NETWORK_INTERFACE_TO_ADD_ALREADY_EXISTS"),

    CAN_NETWORK_INTERFACE_INFO_IS_NULL("CAN_NETWORK_INTERFACE_INFO_IS_NULL"),

    OBD_NETWORK_INTERFACE_INFO_IS_NULL("OBD_NETWORK_INTERFACE_INFO_IS_NULL"),

    NETWORK_INTERFACE_TO_REMOVE_ASSOCIATED_WITH_SIGNALS("NETWORK_INTERFACE_TO_REMOVE_ASSOCIATED_WITH_SIGNALS"),

    VEHICLE_MIDDLEWARE_NETWORK_INTERFACE_INFO_IS_NULL("VEHICLE_MIDDLEWARE_NETWORK_INTERFACE_INFO_IS_NULL"),

    CUSTOM_DECODING_SIGNAL_NETWORK_INTERFACE_INFO_IS_NULL("CUSTOM_DECODING_SIGNAL_NETWORK_INTERFACE_INFO_IS_NULL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceFailureReason> VALUE_MAP = EnumUtils.uniqueIndex(
            NetworkInterfaceFailureReason.class, NetworkInterfaceFailureReason::toString);

    private final String value;

    private NetworkInterfaceFailureReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NetworkInterfaceFailureReason corresponding to the value
     */
    public static NetworkInterfaceFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NetworkInterfaceFailureReason}s
     */
    public static Set<NetworkInterfaceFailureReason> knownValues() {
        Set<NetworkInterfaceFailureReason> knownValues = EnumSet.allOf(NetworkInterfaceFailureReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
