/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObdSignal implements SdkPojo, Serializable, ToCopyableBuilder<ObdSignal.Builder, ObdSignal> {
    private static final SdkField<Integer> PID_RESPONSE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pidResponseLength").getter(getter(ObdSignal::pidResponseLength))
            .setter(setter(Builder::pidResponseLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidResponseLength").build()).build();

    private static final SdkField<Integer> SERVICE_MODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("serviceMode").getter(getter(ObdSignal::serviceMode)).setter(setter(Builder::serviceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceMode").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("pid")
            .getter(getter(ObdSignal::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()).build();

    private static final SdkField<Double> SCALING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("scaling")
            .getter(getter(ObdSignal::scaling)).setter(setter(Builder::scaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaling").build()).build();

    private static final SdkField<Double> OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("offset")
            .getter(getter(ObdSignal::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<Integer> START_BYTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startByte").getter(getter(ObdSignal::startByte)).setter(setter(Builder::startByte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startByte").build()).build();

    private static final SdkField<Integer> BYTE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("byteLength").getter(getter(ObdSignal::byteLength)).setter(setter(Builder::byteLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteLength").build()).build();

    private static final SdkField<Integer> BIT_RIGHT_SHIFT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("bitRightShift").getter(getter(ObdSignal::bitRightShift)).setter(setter(Builder::bitRightShift))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitRightShift").build()).build();

    private static final SdkField<Integer> BIT_MASK_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("bitMaskLength").getter(getter(ObdSignal::bitMaskLength)).setter(setter(Builder::bitMaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitMaskLength").build()).build();

    private static final SdkField<Boolean> IS_SIGNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSigned").getter(getter(ObdSignal::isSigned)).setter(setter(Builder::isSigned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSigned").build()).build();

    private static final SdkField<String> SIGNAL_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signalValueType").getter(getter(ObdSignal::signalValueTypeAsString))
            .setter(setter(Builder::signalValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalValueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PID_RESPONSE_LENGTH_FIELD,
            SERVICE_MODE_FIELD, PID_FIELD, SCALING_FIELD, OFFSET_FIELD, START_BYTE_FIELD, BYTE_LENGTH_FIELD,
            BIT_RIGHT_SHIFT_FIELD, BIT_MASK_LENGTH_FIELD, IS_SIGNED_FIELD, SIGNAL_VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer pidResponseLength;

    private final Integer serviceMode;

    private final Integer pid;

    private final Double scaling;

    private final Double offset;

    private final Integer startByte;

    private final Integer byteLength;

    private final Integer bitRightShift;

    private final Integer bitMaskLength;

    private final Boolean isSigned;

    private final String signalValueType;

    private ObdSignal(BuilderImpl builder) {
        this.pidResponseLength = builder.pidResponseLength;
        this.serviceMode = builder.serviceMode;
        this.pid = builder.pid;
        this.scaling = builder.scaling;
        this.offset = builder.offset;
        this.startByte = builder.startByte;
        this.byteLength = builder.byteLength;
        this.bitRightShift = builder.bitRightShift;
        this.bitMaskLength = builder.bitMaskLength;
        this.isSigned = builder.isSigned;
        this.signalValueType = builder.signalValueType;
    }

    /**
     * <p>
     * The length of the requested data.
     * </p>
     * 
     * @return The length of the requested data.
     */
    public final Integer pidResponseLength() {
        return pidResponseLength;
    }

    /**
     * <p>
     * The mode of operation (diagnostic service) in a message.
     * </p>
     * 
     * @return The mode of operation (diagnostic service) in a message.
     */
    public final Integer serviceMode() {
        return serviceMode;
    }

    /**
     * <p>
     * The diagnostic code used to request data from a vehicle for this signal.
     * </p>
     * 
     * @return The diagnostic code used to request data from a vehicle for this signal.
     */
    public final Integer pid() {
        return pid;
    }

    /**
     * <p>
     * A multiplier used to decode the message.
     * </p>
     * 
     * @return A multiplier used to decode the message.
     */
    public final Double scaling() {
        return scaling;
    }

    /**
     * <p>
     * The offset used to calculate the signal value. Combined with scaling, the calculation is
     * <code>value = raw_value * scaling + offset</code>.
     * </p>
     * 
     * @return The offset used to calculate the signal value. Combined with scaling, the calculation is
     *         <code>value = raw_value * scaling + offset</code>.
     */
    public final Double offset() {
        return offset;
    }

    /**
     * <p>
     * Indicates the beginning of the message.
     * </p>
     * 
     * @return Indicates the beginning of the message.
     */
    public final Integer startByte() {
        return startByte;
    }

    /**
     * <p>
     * The length of a message.
     * </p>
     * 
     * @return The length of a message.
     */
    public final Integer byteLength() {
        return byteLength;
    }

    /**
     * <p>
     * The number of positions to shift bits in the message.
     * </p>
     * 
     * @return The number of positions to shift bits in the message.
     */
    public final Integer bitRightShift() {
        return bitRightShift;
    }

    /**
     * <p>
     * The number of bits to mask in a message.
     * </p>
     * 
     * @return The number of bits to mask in a message.
     */
    public final Integer bitMaskLength() {
        return bitMaskLength;
    }

    /**
     * <p>
     * Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed, the
     * message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to the
     * <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal type. The
     * default value is <code>false</code>.
     * </p>
     * 
     * @return Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed,
     *         the message can represent both positive and negative numbers. The <code>isSigned</code> parameter only
     *         applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the
     *         <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code>.
     */
    public final Boolean isSigned() {
        return isSigned;
    }

    /**
     * <p>
     * The value type of the signal. The default value is <code>INTEGER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalValueType}
     * will return {@link SignalValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signalValueTypeAsString}.
     * </p>
     * 
     * @return The value type of the signal. The default value is <code>INTEGER</code>.
     * @see SignalValueType
     */
    public final SignalValueType signalValueType() {
        return SignalValueType.fromValue(signalValueType);
    }

    /**
     * <p>
     * The value type of the signal. The default value is <code>INTEGER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalValueType}
     * will return {@link SignalValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #signalValueTypeAsString}.
     * </p>
     * 
     * @return The value type of the signal. The default value is <code>INTEGER</code>.
     * @see SignalValueType
     */
    public final String signalValueTypeAsString() {
        return signalValueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pidResponseLength());
        hashCode = 31 * hashCode + Objects.hashCode(serviceMode());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        hashCode = 31 * hashCode + Objects.hashCode(scaling());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(startByte());
        hashCode = 31 * hashCode + Objects.hashCode(byteLength());
        hashCode = 31 * hashCode + Objects.hashCode(bitRightShift());
        hashCode = 31 * hashCode + Objects.hashCode(bitMaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(isSigned());
        hashCode = 31 * hashCode + Objects.hashCode(signalValueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObdSignal)) {
            return false;
        }
        ObdSignal other = (ObdSignal) obj;
        return Objects.equals(pidResponseLength(), other.pidResponseLength())
                && Objects.equals(serviceMode(), other.serviceMode()) && Objects.equals(pid(), other.pid())
                && Objects.equals(scaling(), other.scaling()) && Objects.equals(offset(), other.offset())
                && Objects.equals(startByte(), other.startByte()) && Objects.equals(byteLength(), other.byteLength())
                && Objects.equals(bitRightShift(), other.bitRightShift())
                && Objects.equals(bitMaskLength(), other.bitMaskLength()) && Objects.equals(isSigned(), other.isSigned())
                && Objects.equals(signalValueTypeAsString(), other.signalValueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObdSignal").add("PidResponseLength", pidResponseLength()).add("ServiceMode", serviceMode())
                .add("Pid", pid()).add("Scaling", scaling()).add("Offset", offset()).add("StartByte", startByte())
                .add("ByteLength", byteLength()).add("BitRightShift", bitRightShift()).add("BitMaskLength", bitMaskLength())
                .add("IsSigned", isSigned()).add("SignalValueType", signalValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pidResponseLength":
            return Optional.ofNullable(clazz.cast(pidResponseLength()));
        case "serviceMode":
            return Optional.ofNullable(clazz.cast(serviceMode()));
        case "pid":
            return Optional.ofNullable(clazz.cast(pid()));
        case "scaling":
            return Optional.ofNullable(clazz.cast(scaling()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "startByte":
            return Optional.ofNullable(clazz.cast(startByte()));
        case "byteLength":
            return Optional.ofNullable(clazz.cast(byteLength()));
        case "bitRightShift":
            return Optional.ofNullable(clazz.cast(bitRightShift()));
        case "bitMaskLength":
            return Optional.ofNullable(clazz.cast(bitMaskLength()));
        case "isSigned":
            return Optional.ofNullable(clazz.cast(isSigned()));
        case "signalValueType":
            return Optional.ofNullable(clazz.cast(signalValueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pidResponseLength", PID_RESPONSE_LENGTH_FIELD);
        map.put("serviceMode", SERVICE_MODE_FIELD);
        map.put("pid", PID_FIELD);
        map.put("scaling", SCALING_FIELD);
        map.put("offset", OFFSET_FIELD);
        map.put("startByte", START_BYTE_FIELD);
        map.put("byteLength", BYTE_LENGTH_FIELD);
        map.put("bitRightShift", BIT_RIGHT_SHIFT_FIELD);
        map.put("bitMaskLength", BIT_MASK_LENGTH_FIELD);
        map.put("isSigned", IS_SIGNED_FIELD);
        map.put("signalValueType", SIGNAL_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObdSignal, T> g) {
        return obj -> g.apply((ObdSignal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObdSignal> {
        /**
         * <p>
         * The length of the requested data.
         * </p>
         * 
         * @param pidResponseLength
         *        The length of the requested data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pidResponseLength(Integer pidResponseLength);

        /**
         * <p>
         * The mode of operation (diagnostic service) in a message.
         * </p>
         * 
         * @param serviceMode
         *        The mode of operation (diagnostic service) in a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceMode(Integer serviceMode);

        /**
         * <p>
         * The diagnostic code used to request data from a vehicle for this signal.
         * </p>
         * 
         * @param pid
         *        The diagnostic code used to request data from a vehicle for this signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);

        /**
         * <p>
         * A multiplier used to decode the message.
         * </p>
         * 
         * @param scaling
         *        A multiplier used to decode the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaling(Double scaling);

        /**
         * <p>
         * The offset used to calculate the signal value. Combined with scaling, the calculation is
         * <code>value = raw_value * scaling + offset</code>.
         * </p>
         * 
         * @param offset
         *        The offset used to calculate the signal value. Combined with scaling, the calculation is
         *        <code>value = raw_value * scaling + offset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Double offset);

        /**
         * <p>
         * Indicates the beginning of the message.
         * </p>
         * 
         * @param startByte
         *        Indicates the beginning of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startByte(Integer startByte);

        /**
         * <p>
         * The length of a message.
         * </p>
         * 
         * @param byteLength
         *        The length of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteLength(Integer byteLength);

        /**
         * <p>
         * The number of positions to shift bits in the message.
         * </p>
         * 
         * @param bitRightShift
         *        The number of positions to shift bits in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitRightShift(Integer bitRightShift);

        /**
         * <p>
         * The number of bits to mask in a message.
         * </p>
         * 
         * @param bitMaskLength
         *        The number of bits to mask in a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitMaskLength(Integer bitMaskLength);

        /**
         * <p>
         * Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's signed, the
         * message can represent both positive and negative numbers. The <code>isSigned</code> parameter only applies to
         * the <code>INTEGER</code> raw signal type, and it doesn't affect the <code>FLOATING_POINT</code> raw signal
         * type. The default value is <code>false</code>.
         * </p>
         * 
         * @param isSigned
         *        Determines whether the message is signed (<code>true</code>) or not (<code>false</code>). If it's
         *        signed, the message can represent both positive and negative numbers. The <code>isSigned</code>
         *        parameter only applies to the <code>INTEGER</code> raw signal type, and it doesn't affect the
         *        <code>FLOATING_POINT</code> raw signal type. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSigned(Boolean isSigned);

        /**
         * <p>
         * The value type of the signal. The default value is <code>INTEGER</code>.
         * </p>
         * 
         * @param signalValueType
         *        The value type of the signal. The default value is <code>INTEGER</code>.
         * @see SignalValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalValueType
         */
        Builder signalValueType(String signalValueType);

        /**
         * <p>
         * The value type of the signal. The default value is <code>INTEGER</code>.
         * </p>
         * 
         * @param signalValueType
         *        The value type of the signal. The default value is <code>INTEGER</code>.
         * @see SignalValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalValueType
         */
        Builder signalValueType(SignalValueType signalValueType);
    }

    static final class BuilderImpl implements Builder {
        private Integer pidResponseLength;

        private Integer serviceMode;

        private Integer pid;

        private Double scaling;

        private Double offset;

        private Integer startByte;

        private Integer byteLength;

        private Integer bitRightShift;

        private Integer bitMaskLength;

        private Boolean isSigned;

        private String signalValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(ObdSignal model) {
            pidResponseLength(model.pidResponseLength);
            serviceMode(model.serviceMode);
            pid(model.pid);
            scaling(model.scaling);
            offset(model.offset);
            startByte(model.startByte);
            byteLength(model.byteLength);
            bitRightShift(model.bitRightShift);
            bitMaskLength(model.bitMaskLength);
            isSigned(model.isSigned);
            signalValueType(model.signalValueType);
        }

        public final Integer getPidResponseLength() {
            return pidResponseLength;
        }

        public final void setPidResponseLength(Integer pidResponseLength) {
            this.pidResponseLength = pidResponseLength;
        }

        @Override
        public final Builder pidResponseLength(Integer pidResponseLength) {
            this.pidResponseLength = pidResponseLength;
            return this;
        }

        public final Integer getServiceMode() {
            return serviceMode;
        }

        public final void setServiceMode(Integer serviceMode) {
            this.serviceMode = serviceMode;
        }

        @Override
        public final Builder serviceMode(Integer serviceMode) {
            this.serviceMode = serviceMode;
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Double getScaling() {
            return scaling;
        }

        public final void setScaling(Double scaling) {
            this.scaling = scaling;
        }

        @Override
        public final Builder scaling(Double scaling) {
            this.scaling = scaling;
            return this;
        }

        public final Double getOffset() {
            return offset;
        }

        public final void setOffset(Double offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Double offset) {
            this.offset = offset;
            return this;
        }

        public final Integer getStartByte() {
            return startByte;
        }

        public final void setStartByte(Integer startByte) {
            this.startByte = startByte;
        }

        @Override
        public final Builder startByte(Integer startByte) {
            this.startByte = startByte;
            return this;
        }

        public final Integer getByteLength() {
            return byteLength;
        }

        public final void setByteLength(Integer byteLength) {
            this.byteLength = byteLength;
        }

        @Override
        public final Builder byteLength(Integer byteLength) {
            this.byteLength = byteLength;
            return this;
        }

        public final Integer getBitRightShift() {
            return bitRightShift;
        }

        public final void setBitRightShift(Integer bitRightShift) {
            this.bitRightShift = bitRightShift;
        }

        @Override
        public final Builder bitRightShift(Integer bitRightShift) {
            this.bitRightShift = bitRightShift;
            return this;
        }

        public final Integer getBitMaskLength() {
            return bitMaskLength;
        }

        public final void setBitMaskLength(Integer bitMaskLength) {
            this.bitMaskLength = bitMaskLength;
        }

        @Override
        public final Builder bitMaskLength(Integer bitMaskLength) {
            this.bitMaskLength = bitMaskLength;
            return this;
        }

        public final Boolean getIsSigned() {
            return isSigned;
        }

        public final void setIsSigned(Boolean isSigned) {
            this.isSigned = isSigned;
        }

        @Override
        public final Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            return this;
        }

        public final String getSignalValueType() {
            return signalValueType;
        }

        public final void setSignalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
        }

        @Override
        public final Builder signalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
            return this;
        }

        @Override
        public final Builder signalValueType(SignalValueType signalValueType) {
            this.signalValueType(signalValueType == null ? null : signalValueType.toString());
            return this;
        }

        @Override
        public ObdSignal build() {
            return new ObdSignal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
