/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAccountResponse extends IoTFleetWiseResponse implements
        ToCopyableBuilder<RegisterAccountResponse.Builder, RegisterAccountResponse> {
    private static final SdkField<String> REGISTER_ACCOUNT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registerAccountStatus").getter(getter(RegisterAccountResponse::registerAccountStatusAsString))
            .setter(setter(Builder::registerAccountStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerAccountStatus").build())
            .build();

    private static final SdkField<TimestreamResources> TIMESTREAM_RESOURCES_FIELD = SdkField
            .<TimestreamResources> builder(MarshallingType.SDK_POJO).memberName("timestreamResources")
            .getter(getter(RegisterAccountResponse::timestreamResources)).setter(setter(Builder::timestreamResources))
            .constructor(TimestreamResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamResources").build())
            .build();

    private static final SdkField<IamResources> IAM_RESOURCES_FIELD = SdkField.<IamResources> builder(MarshallingType.SDK_POJO)
            .memberName("iamResources").getter(getter(RegisterAccountResponse::iamResources))
            .setter(setter(Builder::iamResources)).constructor(IamResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamResources").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(RegisterAccountResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModificationTime").getter(getter(RegisterAccountResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTER_ACCOUNT_STATUS_FIELD,
            TIMESTREAM_RESOURCES_FIELD, IAM_RESOURCES_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registerAccountStatus;

    private final TimestreamResources timestreamResources;

    private final IamResources iamResources;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private RegisterAccountResponse(BuilderImpl builder) {
        super(builder);
        this.registerAccountStatus = builder.registerAccountStatus;
        this.timestreamResources = builder.timestreamResources;
        this.iamResources = builder.iamResources;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registerAccountStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #registerAccountStatusAsString}.
     * </p>
     * 
     * @return The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registerAccountStatus() {
        return RegistrationStatus.fromValue(registerAccountStatus);
    }

    /**
     * <p>
     * The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registerAccountStatus} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #registerAccountStatusAsString}.
     * </p>
     * 
     * @return The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
     * @see RegistrationStatus
     */
    public final String registerAccountStatusAsString() {
        return registerAccountStatus;
    }

    /**
     * Returns the value of the TimestreamResources property for this object.
     * 
     * @return The value of the TimestreamResources property for this object.
     */
    public final TimestreamResources timestreamResources() {
        return timestreamResources;
    }

    /**
     * <p>
     * The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
     * </p>
     * 
     * @return The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon
     *         Timestream.
     */
    public final IamResources iamResources() {
        return iamResources;
    }

    /**
     * <p>
     * The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time).
     * </p>
     * 
     * @return The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC
     *         time).
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registerAccountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamResources());
        hashCode = 31 * hashCode + Objects.hashCode(iamResources());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountResponse)) {
            return false;
        }
        RegisterAccountResponse other = (RegisterAccountResponse) obj;
        return Objects.equals(registerAccountStatusAsString(), other.registerAccountStatusAsString())
                && Objects.equals(timestreamResources(), other.timestreamResources())
                && Objects.equals(iamResources(), other.iamResources()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAccountResponse").add("RegisterAccountStatus", registerAccountStatusAsString())
                .add("TimestreamResources", timestreamResources()).add("IamResources", iamResources())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registerAccountStatus":
            return Optional.ofNullable(clazz.cast(registerAccountStatusAsString()));
        case "timestreamResources":
            return Optional.ofNullable(clazz.cast(timestreamResources()));
        case "iamResources":
            return Optional.ofNullable(clazz.cast(iamResources()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registerAccountStatus", REGISTER_ACCOUNT_STATUS_FIELD);
        map.put("timestreamResources", TIMESTREAM_RESOURCES_FIELD);
        map.put("iamResources", IAM_RESOURCES_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountResponse, T> g) {
        return obj -> g.apply((RegisterAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAccountResponse> {
        /**
         * <p>
         * The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
         * </p>
         * 
         * @param registerAccountStatus
         *        The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registerAccountStatus(String registerAccountStatus);

        /**
         * <p>
         * The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
         * </p>
         * 
         * @param registerAccountStatus
         *        The status of registering your Amazon Web Services account, IAM role, and Timestream resources.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registerAccountStatus(RegistrationStatus registerAccountStatus);

        /**
         * Sets the value of the TimestreamResources property for this object.
         *
         * @param timestreamResources
         *        The new value for the TimestreamResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamResources(TimestreamResources timestreamResources);

        /**
         * Sets the value of the TimestreamResources property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimestreamResources.Builder} avoiding the
         * need to create one manually via {@link TimestreamResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamResources.Builder#build()} is called immediately and
         * its result is passed to {@link #timestreamResources(TimestreamResources)}.
         * 
         * @param timestreamResources
         *        a consumer that will call methods on {@link TimestreamResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamResources(TimestreamResources)
         */
        default Builder timestreamResources(Consumer<TimestreamResources.Builder> timestreamResources) {
            return timestreamResources(TimestreamResources.builder().applyMutation(timestreamResources).build());
        }

        /**
         * <p>
         * The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
         * </p>
         * 
         * @param iamResources
         *        The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon
         *        Timestream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamResources(IamResources iamResources);

        /**
         * <p>
         * The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamResources.Builder} avoiding the need
         * to create one manually via {@link IamResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamResources.Builder#build()} is called immediately and its
         * result is passed to {@link #iamResources(IamResources)}.
         * 
         * @param iamResources
         *        a consumer that will call methods on {@link IamResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamResources(IamResources)
         */
        default Builder iamResources(Consumer<IamResources.Builder> iamResources) {
            return iamResources(IamResources.builder().applyMutation(iamResources).build());
        }

        /**
         * <p>
         * The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param creationTime
         *        The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time).
         * </p>
         * 
         * @param lastModificationTime
         *        The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC
         *        time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl extends IoTFleetWiseResponse.BuilderImpl implements Builder {
        private String registerAccountStatus;

        private TimestreamResources timestreamResources;

        private IamResources iamResources;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountResponse model) {
            super(model);
            registerAccountStatus(model.registerAccountStatus);
            timestreamResources(model.timestreamResources);
            iamResources(model.iamResources);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getRegisterAccountStatus() {
            return registerAccountStatus;
        }

        public final void setRegisterAccountStatus(String registerAccountStatus) {
            this.registerAccountStatus = registerAccountStatus;
        }

        @Override
        public final Builder registerAccountStatus(String registerAccountStatus) {
            this.registerAccountStatus = registerAccountStatus;
            return this;
        }

        @Override
        public final Builder registerAccountStatus(RegistrationStatus registerAccountStatus) {
            this.registerAccountStatus(registerAccountStatus == null ? null : registerAccountStatus.toString());
            return this;
        }

        public final TimestreamResources.Builder getTimestreamResources() {
            return timestreamResources != null ? timestreamResources.toBuilder() : null;
        }

        public final void setTimestreamResources(TimestreamResources.BuilderImpl timestreamResources) {
            this.timestreamResources = timestreamResources != null ? timestreamResources.build() : null;
        }

        @Override
        public final Builder timestreamResources(TimestreamResources timestreamResources) {
            this.timestreamResources = timestreamResources;
            return this;
        }

        public final IamResources.Builder getIamResources() {
            return iamResources != null ? iamResources.toBuilder() : null;
        }

        public final void setIamResources(IamResources.BuilderImpl iamResources) {
            this.iamResources = iamResources != null ? iamResources.build() : null;
        }

        @Override
        public final Builder iamResources(IamResources iamResources) {
            this.iamResources = iamResources;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public RegisterAccountResponse build() {
            return new RegisterAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
