/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state template associated with a vehicle. State templates contain state properties, which are signals that belong
 * to a signal catalog that is synchronized between the Amazon Web Services IoT FleetWise Edge and the Amazon Web
 * Services Cloud.
 * </p>
 * <important>
 * <p>
 * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
 * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateTemplateAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<StateTemplateAssociation.Builder, StateTemplateAssociation> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(StateTemplateAssociation::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<StateTemplateUpdateStrategy> STATE_TEMPLATE_UPDATE_STRATEGY_FIELD = SdkField
            .<StateTemplateUpdateStrategy> builder(MarshallingType.SDK_POJO)
            .memberName("stateTemplateUpdateStrategy")
            .getter(getter(StateTemplateAssociation::stateTemplateUpdateStrategy))
            .setter(setter(Builder::stateTemplateUpdateStrategy))
            .constructor(StateTemplateUpdateStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplateUpdateStrategy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            STATE_TEMPLATE_UPDATE_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final StateTemplateUpdateStrategy stateTemplateUpdateStrategy;

    private StateTemplateAssociation(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.stateTemplateUpdateStrategy = builder.stateTemplateUpdateStrategy;
    }

    /**
     * <p>
     * The unique ID of the state template.
     * </p>
     * 
     * @return The unique ID of the state template.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * Returns the value of the StateTemplateUpdateStrategy property for this object.
     * 
     * @return The value of the StateTemplateUpdateStrategy property for this object.
     */
    public final StateTemplateUpdateStrategy stateTemplateUpdateStrategy() {
        return stateTemplateUpdateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(stateTemplateUpdateStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateTemplateAssociation)) {
            return false;
        }
        StateTemplateAssociation other = (StateTemplateAssociation) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(stateTemplateUpdateStrategy(), other.stateTemplateUpdateStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateTemplateAssociation").add("Identifier", identifier())
                .add("StateTemplateUpdateStrategy", stateTemplateUpdateStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "stateTemplateUpdateStrategy":
            return Optional.ofNullable(clazz.cast(stateTemplateUpdateStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("stateTemplateUpdateStrategy", STATE_TEMPLATE_UPDATE_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateTemplateAssociation, T> g) {
        return obj -> g.apply((StateTemplateAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateTemplateAssociation> {
        /**
         * <p>
         * The unique ID of the state template.
         * </p>
         * 
         * @param identifier
         *        The unique ID of the state template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * Sets the value of the StateTemplateUpdateStrategy property for this object.
         *
         * @param stateTemplateUpdateStrategy
         *        The new value for the StateTemplateUpdateStrategy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTemplateUpdateStrategy(StateTemplateUpdateStrategy stateTemplateUpdateStrategy);

        /**
         * Sets the value of the StateTemplateUpdateStrategy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StateTemplateUpdateStrategy.Builder}
         * avoiding the need to create one manually via {@link StateTemplateUpdateStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateTemplateUpdateStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #stateTemplateUpdateStrategy(StateTemplateUpdateStrategy)}.
         * 
         * @param stateTemplateUpdateStrategy
         *        a consumer that will call methods on {@link StateTemplateUpdateStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateTemplateUpdateStrategy(StateTemplateUpdateStrategy)
         */
        default Builder stateTemplateUpdateStrategy(Consumer<StateTemplateUpdateStrategy.Builder> stateTemplateUpdateStrategy) {
            return stateTemplateUpdateStrategy(StateTemplateUpdateStrategy.builder().applyMutation(stateTemplateUpdateStrategy)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private StateTemplateUpdateStrategy stateTemplateUpdateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StateTemplateAssociation model) {
            identifier(model.identifier);
            stateTemplateUpdateStrategy(model.stateTemplateUpdateStrategy);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final StateTemplateUpdateStrategy.Builder getStateTemplateUpdateStrategy() {
            return stateTemplateUpdateStrategy != null ? stateTemplateUpdateStrategy.toBuilder() : null;
        }

        public final void setStateTemplateUpdateStrategy(StateTemplateUpdateStrategy.BuilderImpl stateTemplateUpdateStrategy) {
            this.stateTemplateUpdateStrategy = stateTemplateUpdateStrategy != null ? stateTemplateUpdateStrategy.build() : null;
        }

        @Override
        public final Builder stateTemplateUpdateStrategy(StateTemplateUpdateStrategy stateTemplateUpdateStrategy) {
            this.stateTemplateUpdateStrategy = stateTemplateUpdateStrategy;
            return this;
        }

        @Override
        public StateTemplateAssociation build() {
            return new StateTemplateAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
