/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a collection scheme that uses a time period to decide how often to collect data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeBasedCollectionScheme implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeBasedCollectionScheme.Builder, TimeBasedCollectionScheme> {
    private static final SdkField<Long> PERIOD_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("periodMs")
            .getter(getter(TimeBasedCollectionScheme::periodMs)).setter(setter(Builder::periodMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_MS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long periodMs;

    private TimeBasedCollectionScheme(BuilderImpl builder) {
        this.periodMs = builder.periodMs;
    }

    /**
     * <p>
     * The time period (in milliseconds) to decide how often to collect data. For example, if the time period is
     * <code>60000</code>, the Edge Agent software collects data once every minute.
     * </p>
     * 
     * @return The time period (in milliseconds) to decide how often to collect data. For example, if the time period is
     *         <code>60000</code>, the Edge Agent software collects data once every minute.
     */
    public final Long periodMs() {
        return periodMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedCollectionScheme)) {
            return false;
        }
        TimeBasedCollectionScheme other = (TimeBasedCollectionScheme) obj;
        return Objects.equals(periodMs(), other.periodMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeBasedCollectionScheme").add("PeriodMs", periodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "periodMs":
            return Optional.ofNullable(clazz.cast(periodMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("periodMs", PERIOD_MS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedCollectionScheme, T> g) {
        return obj -> g.apply((TimeBasedCollectionScheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeBasedCollectionScheme> {
        /**
         * <p>
         * The time period (in milliseconds) to decide how often to collect data. For example, if the time period is
         * <code>60000</code>, the Edge Agent software collects data once every minute.
         * </p>
         * 
         * @param periodMs
         *        The time period (in milliseconds) to decide how often to collect data. For example, if the time period
         *        is <code>60000</code>, the Edge Agent software collects data once every minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodMs(Long periodMs);
    }

    static final class BuilderImpl implements Builder {
        private Long periodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedCollectionScheme model) {
            periodMs(model.periodMs);
        }

        public final Long getPeriodMs() {
            return periodMs;
        }

        public final void setPeriodMs(Long periodMs) {
            this.periodMs = periodMs;
        }

        @Override
        public final Builder periodMs(Long periodMs) {
            this.periodMs = periodMs;
            return this;
        }

        @Override
        public TimeBasedCollectionScheme build() {
            return new TimeBasedCollectionScheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
