/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDecoderManifestRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<UpdateDecoderManifestRequest.Builder, UpdateDecoderManifestRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDecoderManifestRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDecoderManifestRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SignalDecoder>> SIGNAL_DECODERS_TO_ADD_FIELD = SdkField
            .<List<SignalDecoder>> builder(MarshallingType.LIST)
            .memberName("signalDecodersToAdd")
            .getter(getter(UpdateDecoderManifestRequest::signalDecodersToAdd))
            .setter(setter(Builder::signalDecodersToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalDecoder> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalDecoder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SignalDecoder>> SIGNAL_DECODERS_TO_UPDATE_FIELD = SdkField
            .<List<SignalDecoder>> builder(MarshallingType.LIST)
            .memberName("signalDecodersToUpdate")
            .getter(getter(UpdateDecoderManifestRequest::signalDecodersToUpdate))
            .setter(setter(Builder::signalDecodersToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignalDecoder> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignalDecoder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SIGNAL_DECODERS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("signalDecodersToRemove")
            .getter(getter(UpdateDecoderManifestRequest::signalDecodersToRemove))
            .setter(setter(Builder::signalDecodersToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_TO_ADD_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("networkInterfacesToAdd")
            .getter(getter(UpdateDecoderManifestRequest::networkInterfacesToAdd))
            .setter(setter(Builder::networkInterfacesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_TO_UPDATE_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("networkInterfacesToUpdate")
            .getter(getter(UpdateDecoderManifestRequest::networkInterfacesToUpdate))
            .setter(setter(Builder::networkInterfacesToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("networkInterfacesToRemove")
            .getter(getter(UpdateDecoderManifestRequest::networkInterfacesToRemove))
            .setter(setter(Builder::networkInterfacesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateDecoderManifestRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultForUnmappedSignals")
            .getter(getter(UpdateDecoderManifestRequest::defaultForUnmappedSignalsAsString))
            .setter(setter(Builder::defaultForUnmappedSignals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultForUnmappedSignals").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SIGNAL_DECODERS_TO_ADD_FIELD, SIGNAL_DECODERS_TO_UPDATE_FIELD, SIGNAL_DECODERS_TO_REMOVE_FIELD,
            NETWORK_INTERFACES_TO_ADD_FIELD, NETWORK_INTERFACES_TO_UPDATE_FIELD, NETWORK_INTERFACES_TO_REMOVE_FIELD,
            STATUS_FIELD, DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final List<SignalDecoder> signalDecodersToAdd;

    private final List<SignalDecoder> signalDecodersToUpdate;

    private final List<String> signalDecodersToRemove;

    private final List<NetworkInterface> networkInterfacesToAdd;

    private final List<NetworkInterface> networkInterfacesToUpdate;

    private final List<String> networkInterfacesToRemove;

    private final String status;

    private final String defaultForUnmappedSignals;

    private UpdateDecoderManifestRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalDecodersToAdd = builder.signalDecodersToAdd;
        this.signalDecodersToUpdate = builder.signalDecodersToUpdate;
        this.signalDecodersToRemove = builder.signalDecodersToRemove;
        this.networkInterfacesToAdd = builder.networkInterfacesToAdd;
        this.networkInterfacesToUpdate = builder.networkInterfacesToUpdate;
        this.networkInterfacesToRemove = builder.networkInterfacesToRemove;
        this.status = builder.status;
        this.defaultForUnmappedSignals = builder.defaultForUnmappedSignals;
    }

    /**
     * <p>
     * The name of the decoder manifest to update.
     * </p>
     * 
     * @return The name of the decoder manifest to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A brief description of the decoder manifest to update.
     * </p>
     * 
     * @return A brief description of the decoder manifest to update.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalDecodersToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignalDecodersToAdd() {
        return signalDecodersToAdd != null && !(signalDecodersToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about decoding additional signals to add to the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalDecodersToAdd} method.
     * </p>
     * 
     * @return A list of information about decoding additional signals to add to the decoder manifest.
     */
    public final List<SignalDecoder> signalDecodersToAdd() {
        return signalDecodersToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalDecodersToUpdate property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSignalDecodersToUpdate() {
        return signalDecodersToUpdate != null && !(signalDecodersToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of updated information about decoding signals to update in the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalDecodersToUpdate} method.
     * </p>
     * 
     * @return A list of updated information about decoding signals to update in the decoder manifest.
     */
    public final List<SignalDecoder> signalDecodersToUpdate() {
        return signalDecodersToUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignalDecodersToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSignalDecodersToRemove() {
        return signalDecodersToRemove != null && !(signalDecodersToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signal decoders to remove from the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignalDecodersToRemove} method.
     * </p>
     * 
     * @return A list of signal decoders to remove from the decoder manifest.
     */
    public final List<String> signalDecodersToRemove() {
        return signalDecodersToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfacesToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInterfacesToAdd() {
        return networkInterfacesToAdd != null && !(networkInterfacesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about the network interfaces to add to the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfacesToAdd} method.
     * </p>
     * 
     * @return A list of information about the network interfaces to add to the decoder manifest.
     */
    public final List<NetworkInterface> networkInterfacesToAdd() {
        return networkInterfacesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfacesToUpdate property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInterfacesToUpdate() {
        return networkInterfacesToUpdate != null && !(networkInterfacesToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about the network interfaces to update in the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfacesToUpdate} method.
     * </p>
     * 
     * @return A list of information about the network interfaces to update in the decoder manifest.
     */
    public final List<NetworkInterface> networkInterfacesToUpdate() {
        return networkInterfacesToUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfacesToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInterfacesToRemove() {
        return networkInterfacesToRemove != null && !(networkInterfacesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of network interfaces to remove from the decoder manifest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfacesToRemove} method.
     * </p>
     * 
     * @return A list of network interfaces to remove from the decoder manifest.
     */
    public final List<String> networkInterfacesToRemove() {
        return networkInterfacesToRemove;
    }

    /**
     * <p>
     * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be edited. If
     * the status is <code>DRAFT</code>, you can edit the decoder manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
     *         edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
     * @see ManifestStatus
     */
    public final ManifestStatus status() {
        return ManifestStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be edited. If
     * the status is <code>DRAFT</code>, you can edit the decoder manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManifestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
     *         edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
     * @see ManifestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Use default decoders for all unmapped signals in the model. You don't need to provide any detailed decoding
     * information.
     * </p>
     * <important>
     * <p>
     * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
     * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultForUnmappedSignals} will return {@link DefaultForUnmappedSignalsType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #defaultForUnmappedSignalsAsString}.
     * </p>
     * 
     * @return Use default decoders for all unmapped signals in the model. You don't need to provide any detailed
     *         decoding information.</p> <important>
     *         <p>
     *         Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web
     *         Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer
     *         Guide</i>.
     *         </p>
     * @see DefaultForUnmappedSignalsType
     */
    public final DefaultForUnmappedSignalsType defaultForUnmappedSignals() {
        return DefaultForUnmappedSignalsType.fromValue(defaultForUnmappedSignals);
    }

    /**
     * <p>
     * Use default decoders for all unmapped signals in the model. You don't need to provide any detailed decoding
     * information.
     * </p>
     * <important>
     * <p>
     * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web Services
     * Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultForUnmappedSignals} will return {@link DefaultForUnmappedSignalsType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #defaultForUnmappedSignalsAsString}.
     * </p>
     * 
     * @return Use default decoders for all unmapped signals in the model. You don't need to provide any detailed
     *         decoding information.</p> <important>
     *         <p>
     *         Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web
     *         Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer
     *         Guide</i>.
     *         </p>
     * @see DefaultForUnmappedSignalsType
     */
    public final String defaultForUnmappedSignalsAsString() {
        return defaultForUnmappedSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalDecodersToAdd() ? signalDecodersToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalDecodersToUpdate() ? signalDecodersToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignalDecodersToRemove() ? signalDecodersToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfacesToAdd() ? networkInterfacesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfacesToUpdate() ? networkInterfacesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfacesToRemove() ? networkInterfacesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultForUnmappedSignalsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDecoderManifestRequest)) {
            return false;
        }
        UpdateDecoderManifestRequest other = (UpdateDecoderManifestRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasSignalDecodersToAdd() == other.hasSignalDecodersToAdd()
                && Objects.equals(signalDecodersToAdd(), other.signalDecodersToAdd())
                && hasSignalDecodersToUpdate() == other.hasSignalDecodersToUpdate()
                && Objects.equals(signalDecodersToUpdate(), other.signalDecodersToUpdate())
                && hasSignalDecodersToRemove() == other.hasSignalDecodersToRemove()
                && Objects.equals(signalDecodersToRemove(), other.signalDecodersToRemove())
                && hasNetworkInterfacesToAdd() == other.hasNetworkInterfacesToAdd()
                && Objects.equals(networkInterfacesToAdd(), other.networkInterfacesToAdd())
                && hasNetworkInterfacesToUpdate() == other.hasNetworkInterfacesToUpdate()
                && Objects.equals(networkInterfacesToUpdate(), other.networkInterfacesToUpdate())
                && hasNetworkInterfacesToRemove() == other.hasNetworkInterfacesToRemove()
                && Objects.equals(networkInterfacesToRemove(), other.networkInterfacesToRemove())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(defaultForUnmappedSignalsAsString(), other.defaultForUnmappedSignalsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDecoderManifestRequest").add("Name", name()).add("Description", description())
                .add("SignalDecodersToAdd", hasSignalDecodersToAdd() ? signalDecodersToAdd() : null)
                .add("SignalDecodersToUpdate", hasSignalDecodersToUpdate() ? signalDecodersToUpdate() : null)
                .add("SignalDecodersToRemove", hasSignalDecodersToRemove() ? signalDecodersToRemove() : null)
                .add("NetworkInterfacesToAdd", hasNetworkInterfacesToAdd() ? networkInterfacesToAdd() : null)
                .add("NetworkInterfacesToUpdate", hasNetworkInterfacesToUpdate() ? networkInterfacesToUpdate() : null)
                .add("NetworkInterfacesToRemove", hasNetworkInterfacesToRemove() ? networkInterfacesToRemove() : null)
                .add("Status", statusAsString()).add("DefaultForUnmappedSignals", defaultForUnmappedSignalsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "signalDecodersToAdd":
            return Optional.ofNullable(clazz.cast(signalDecodersToAdd()));
        case "signalDecodersToUpdate":
            return Optional.ofNullable(clazz.cast(signalDecodersToUpdate()));
        case "signalDecodersToRemove":
            return Optional.ofNullable(clazz.cast(signalDecodersToRemove()));
        case "networkInterfacesToAdd":
            return Optional.ofNullable(clazz.cast(networkInterfacesToAdd()));
        case "networkInterfacesToUpdate":
            return Optional.ofNullable(clazz.cast(networkInterfacesToUpdate()));
        case "networkInterfacesToRemove":
            return Optional.ofNullable(clazz.cast(networkInterfacesToRemove()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "defaultForUnmappedSignals":
            return Optional.ofNullable(clazz.cast(defaultForUnmappedSignalsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("signalDecodersToAdd", SIGNAL_DECODERS_TO_ADD_FIELD);
        map.put("signalDecodersToUpdate", SIGNAL_DECODERS_TO_UPDATE_FIELD);
        map.put("signalDecodersToRemove", SIGNAL_DECODERS_TO_REMOVE_FIELD);
        map.put("networkInterfacesToAdd", NETWORK_INTERFACES_TO_ADD_FIELD);
        map.put("networkInterfacesToUpdate", NETWORK_INTERFACES_TO_UPDATE_FIELD);
        map.put("networkInterfacesToRemove", NETWORK_INTERFACES_TO_REMOVE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("defaultForUnmappedSignals", DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDecoderManifestRequest, T> g) {
        return obj -> g.apply((UpdateDecoderManifestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDecoderManifestRequest> {
        /**
         * <p>
         * The name of the decoder manifest to update.
         * </p>
         * 
         * @param name
         *        The name of the decoder manifest to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A brief description of the decoder manifest to update.
         * </p>
         * 
         * @param description
         *        A brief description of the decoder manifest to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of information about decoding additional signals to add to the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToAdd
         *        A list of information about decoding additional signals to add to the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToAdd(Collection<SignalDecoder> signalDecodersToAdd);

        /**
         * <p>
         * A list of information about decoding additional signals to add to the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToAdd
         *        A list of information about decoding additional signals to add to the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToAdd(SignalDecoder... signalDecodersToAdd);

        /**
         * <p>
         * A list of information about decoding additional signals to add to the decoder manifest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder#build()} is called
         * immediately and its result is passed to {@link #signalDecodersToAdd(List<SignalDecoder>)}.
         * 
         * @param signalDecodersToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalDecodersToAdd(java.util.Collection<SignalDecoder>)
         */
        Builder signalDecodersToAdd(Consumer<SignalDecoder.Builder>... signalDecodersToAdd);

        /**
         * <p>
         * A list of updated information about decoding signals to update in the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToUpdate
         *        A list of updated information about decoding signals to update in the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToUpdate(Collection<SignalDecoder> signalDecodersToUpdate);

        /**
         * <p>
         * A list of updated information about decoding signals to update in the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToUpdate
         *        A list of updated information about decoding signals to update in the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToUpdate(SignalDecoder... signalDecodersToUpdate);

        /**
         * <p>
         * A list of updated information about decoding signals to update in the decoder manifest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder#build()} is called
         * immediately and its result is passed to {@link #signalDecodersToUpdate(List<SignalDecoder>)}.
         * 
         * @param signalDecodersToUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalDecodersToUpdate(java.util.Collection<SignalDecoder>)
         */
        Builder signalDecodersToUpdate(Consumer<SignalDecoder.Builder>... signalDecodersToUpdate);

        /**
         * <p>
         * A list of signal decoders to remove from the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToRemove
         *        A list of signal decoders to remove from the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToRemove(Collection<String> signalDecodersToRemove);

        /**
         * <p>
         * A list of signal decoders to remove from the decoder manifest.
         * </p>
         * 
         * @param signalDecodersToRemove
         *        A list of signal decoders to remove from the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalDecodersToRemove(String... signalDecodersToRemove);

        /**
         * <p>
         * A list of information about the network interfaces to add to the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToAdd
         *        A list of information about the network interfaces to add to the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToAdd(Collection<NetworkInterface> networkInterfacesToAdd);

        /**
         * <p>
         * A list of information about the network interfaces to add to the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToAdd
         *        A list of information about the network interfaces to add to the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToAdd(NetworkInterface... networkInterfacesToAdd);

        /**
         * <p>
         * A list of information about the network interfaces to add to the decoder manifest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInterfacesToAdd(List<NetworkInterface>)}.
         * 
         * @param networkInterfacesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfacesToAdd(java.util.Collection<NetworkInterface>)
         */
        Builder networkInterfacesToAdd(Consumer<NetworkInterface.Builder>... networkInterfacesToAdd);

        /**
         * <p>
         * A list of information about the network interfaces to update in the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToUpdate
         *        A list of information about the network interfaces to update in the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToUpdate(Collection<NetworkInterface> networkInterfacesToUpdate);

        /**
         * <p>
         * A list of information about the network interfaces to update in the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToUpdate
         *        A list of information about the network interfaces to update in the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToUpdate(NetworkInterface... networkInterfacesToUpdate);

        /**
         * <p>
         * A list of information about the network interfaces to update in the decoder manifest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInterfacesToUpdate(List<NetworkInterface>)}.
         * 
         * @param networkInterfacesToUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfacesToUpdate(java.util.Collection<NetworkInterface>)
         */
        Builder networkInterfacesToUpdate(Consumer<NetworkInterface.Builder>... networkInterfacesToUpdate);

        /**
         * <p>
         * A list of network interfaces to remove from the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToRemove
         *        A list of network interfaces to remove from the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToRemove(Collection<String> networkInterfacesToRemove);

        /**
         * <p>
         * A list of network interfaces to remove from the decoder manifest.
         * </p>
         * 
         * @param networkInterfacesToRemove
         *        A list of network interfaces to remove from the decoder manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacesToRemove(String... networkInterfacesToRemove);

        /**
         * <p>
         * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         * edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
         * </p>
         * 
         * @param status
         *        The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         *        edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         * edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
         * </p>
         * 
         * @param status
         *        The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can't be
         *        edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest.
         * @see ManifestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManifestStatus
         */
        Builder status(ManifestStatus status);

        /**
         * <p>
         * Use default decoders for all unmapped signals in the model. You don't need to provide any detailed decoding
         * information.
         * </p>
         * <important>
         * <p>
         * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web
         * Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
         * </p>
         * </important>
         * 
         * @param defaultForUnmappedSignals
         *        Use default decoders for all unmapped signals in the model. You don't need to provide any detailed
         *        decoding information.</p> <important>
         *        <p>
         *        Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon
         *        Web Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer
         *        Guide</i>.
         *        </p>
         * @see DefaultForUnmappedSignalsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultForUnmappedSignalsType
         */
        Builder defaultForUnmappedSignals(String defaultForUnmappedSignals);

        /**
         * <p>
         * Use default decoders for all unmapped signals in the model. You don't need to provide any detailed decoding
         * information.
         * </p>
         * <important>
         * <p>
         * Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon Web
         * Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.
         * </p>
         * </important>
         * 
         * @param defaultForUnmappedSignals
         *        Use default decoders for all unmapped signals in the model. You don't need to provide any detailed
         *        decoding information.</p> <important>
         *        <p>
         *        Access to certain Amazon Web Services IoT FleetWise features is currently gated. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html">Amazon
         *        Web Services Region and feature availability</a> in the <i>Amazon Web Services IoT FleetWise Developer
         *        Guide</i>.
         *        </p>
         * @see DefaultForUnmappedSignalsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultForUnmappedSignalsType
         */
        Builder defaultForUnmappedSignals(DefaultForUnmappedSignalsType defaultForUnmappedSignals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<SignalDecoder> signalDecodersToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<SignalDecoder> signalDecodersToUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<String> signalDecodersToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkInterface> networkInterfacesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkInterface> networkInterfacesToUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkInterfacesToRemove = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String defaultForUnmappedSignals;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDecoderManifestRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            signalDecodersToAdd(model.signalDecodersToAdd);
            signalDecodersToUpdate(model.signalDecodersToUpdate);
            signalDecodersToRemove(model.signalDecodersToRemove);
            networkInterfacesToAdd(model.networkInterfacesToAdd);
            networkInterfacesToUpdate(model.networkInterfacesToUpdate);
            networkInterfacesToRemove(model.networkInterfacesToRemove);
            status(model.status);
            defaultForUnmappedSignals(model.defaultForUnmappedSignals);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SignalDecoder.Builder> getSignalDecodersToAdd() {
            List<SignalDecoder.Builder> result = SignalDecodersCopier.copyToBuilder(this.signalDecodersToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalDecodersToAdd(Collection<SignalDecoder.BuilderImpl> signalDecodersToAdd) {
            this.signalDecodersToAdd = SignalDecodersCopier.copyFromBuilder(signalDecodersToAdd);
        }

        @Override
        public final Builder signalDecodersToAdd(Collection<SignalDecoder> signalDecodersToAdd) {
            this.signalDecodersToAdd = SignalDecodersCopier.copy(signalDecodersToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToAdd(SignalDecoder... signalDecodersToAdd) {
            signalDecodersToAdd(Arrays.asList(signalDecodersToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToAdd(Consumer<SignalDecoder.Builder>... signalDecodersToAdd) {
            signalDecodersToAdd(Stream.of(signalDecodersToAdd).map(c -> SignalDecoder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SignalDecoder.Builder> getSignalDecodersToUpdate() {
            List<SignalDecoder.Builder> result = SignalDecodersCopier.copyToBuilder(this.signalDecodersToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalDecodersToUpdate(Collection<SignalDecoder.BuilderImpl> signalDecodersToUpdate) {
            this.signalDecodersToUpdate = SignalDecodersCopier.copyFromBuilder(signalDecodersToUpdate);
        }

        @Override
        public final Builder signalDecodersToUpdate(Collection<SignalDecoder> signalDecodersToUpdate) {
            this.signalDecodersToUpdate = SignalDecodersCopier.copy(signalDecodersToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToUpdate(SignalDecoder... signalDecodersToUpdate) {
            signalDecodersToUpdate(Arrays.asList(signalDecodersToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToUpdate(Consumer<SignalDecoder.Builder>... signalDecodersToUpdate) {
            signalDecodersToUpdate(Stream.of(signalDecodersToUpdate).map(c -> SignalDecoder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSignalDecodersToRemove() {
            if (signalDecodersToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return signalDecodersToRemove;
        }

        public final void setSignalDecodersToRemove(Collection<String> signalDecodersToRemove) {
            this.signalDecodersToRemove = FqnsCopier.copy(signalDecodersToRemove);
        }

        @Override
        public final Builder signalDecodersToRemove(Collection<String> signalDecodersToRemove) {
            this.signalDecodersToRemove = FqnsCopier.copy(signalDecodersToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToRemove(String... signalDecodersToRemove) {
            signalDecodersToRemove(Arrays.asList(signalDecodersToRemove));
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfacesToAdd() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfacesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfacesToAdd(Collection<NetworkInterface.BuilderImpl> networkInterfacesToAdd) {
            this.networkInterfacesToAdd = NetworkInterfacesCopier.copyFromBuilder(networkInterfacesToAdd);
        }

        @Override
        public final Builder networkInterfacesToAdd(Collection<NetworkInterface> networkInterfacesToAdd) {
            this.networkInterfacesToAdd = NetworkInterfacesCopier.copy(networkInterfacesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToAdd(NetworkInterface... networkInterfacesToAdd) {
            networkInterfacesToAdd(Arrays.asList(networkInterfacesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToAdd(Consumer<NetworkInterface.Builder>... networkInterfacesToAdd) {
            networkInterfacesToAdd(Stream.of(networkInterfacesToAdd)
                    .map(c -> NetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfacesToUpdate() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfacesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfacesToUpdate(Collection<NetworkInterface.BuilderImpl> networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate = NetworkInterfacesCopier.copyFromBuilder(networkInterfacesToUpdate);
        }

        @Override
        public final Builder networkInterfacesToUpdate(Collection<NetworkInterface> networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate = NetworkInterfacesCopier.copy(networkInterfacesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToUpdate(NetworkInterface... networkInterfacesToUpdate) {
            networkInterfacesToUpdate(Arrays.asList(networkInterfacesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToUpdate(Consumer<NetworkInterface.Builder>... networkInterfacesToUpdate) {
            networkInterfacesToUpdate(Stream.of(networkInterfacesToUpdate)
                    .map(c -> NetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNetworkInterfacesToRemove() {
            if (networkInterfacesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfacesToRemove;
        }

        public final void setNetworkInterfacesToRemove(Collection<String> networkInterfacesToRemove) {
            this.networkInterfacesToRemove = InterfaceIdsCopier.copy(networkInterfacesToRemove);
        }

        @Override
        public final Builder networkInterfacesToRemove(Collection<String> networkInterfacesToRemove) {
            this.networkInterfacesToRemove = InterfaceIdsCopier.copy(networkInterfacesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToRemove(String... networkInterfacesToRemove) {
            networkInterfacesToRemove(Arrays.asList(networkInterfacesToRemove));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManifestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultForUnmappedSignals() {
            return defaultForUnmappedSignals;
        }

        public final void setDefaultForUnmappedSignals(String defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals = defaultForUnmappedSignals;
        }

        @Override
        public final Builder defaultForUnmappedSignals(String defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals = defaultForUnmappedSignals;
            return this;
        }

        @Override
        public final Builder defaultForUnmappedSignals(DefaultForUnmappedSignalsType defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals(defaultForUnmappedSignals == null ? null : defaultForUnmappedSignals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDecoderManifestRequest build() {
            return new UpdateDecoderManifestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
