/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSignalCatalogRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<UpdateSignalCatalogRequest.Builder, UpdateSignalCatalogRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateSignalCatalogRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSignalCatalogRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Node>> NODES_TO_ADD_FIELD = SdkField
            .<List<Node>> builder(MarshallingType.LIST)
            .memberName("nodesToAdd")
            .getter(getter(UpdateSignalCatalogRequest::nodesToAdd))
            .setter(setter(Builder::nodesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Node> builder(MarshallingType.SDK_POJO)
                                            .constructor(Node::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Node>> NODES_TO_UPDATE_FIELD = SdkField
            .<List<Node>> builder(MarshallingType.LIST)
            .memberName("nodesToUpdate")
            .getter(getter(UpdateSignalCatalogRequest::nodesToUpdate))
            .setter(setter(Builder::nodesToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Node> builder(MarshallingType.SDK_POJO)
                                            .constructor(Node::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NODES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nodesToRemove")
            .getter(getter(UpdateSignalCatalogRequest::nodesToRemove))
            .setter(setter(Builder::nodesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            NODES_TO_ADD_FIELD, NODES_TO_UPDATE_FIELD, NODES_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final List<Node> nodesToAdd;

    private final List<Node> nodesToUpdate;

    private final List<String> nodesToRemove;

    private UpdateSignalCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.nodesToAdd = builder.nodesToAdd;
        this.nodesToUpdate = builder.nodesToUpdate;
        this.nodesToRemove = builder.nodesToRemove;
    }

    /**
     * <p>
     * The name of the signal catalog to update.
     * </p>
     * 
     * @return The name of the signal catalog to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A brief description of the signal catalog to update.
     * </p>
     * 
     * @return A brief description of the signal catalog to update.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToAdd property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodesToAdd() {
        return nodesToAdd != null && !(nodesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about nodes to add to the signal catalog.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToAdd} method.
     * </p>
     * 
     * @return A list of information about nodes to add to the signal catalog.
     */
    public final List<Node> nodesToAdd() {
        return nodesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToUpdate property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodesToUpdate() {
        return nodesToUpdate != null && !(nodesToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information about nodes to update in the signal catalog.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToUpdate} method.
     * </p>
     * 
     * @return A list of information about nodes to update in the signal catalog.
     */
    public final List<Node> nodesToUpdate() {
        return nodesToUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodesToRemove() {
        return nodesToRemove != null && !(nodesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToRemove} method.
     * </p>
     * 
     * @return A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
     */
    public final List<String> nodesToRemove() {
        return nodesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToAdd() ? nodesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToUpdate() ? nodesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToRemove() ? nodesToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSignalCatalogRequest)) {
            return false;
        }
        UpdateSignalCatalogRequest other = (UpdateSignalCatalogRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(nodesToAdd(), other.nodesToAdd())
                && hasNodesToUpdate() == other.hasNodesToUpdate() && Objects.equals(nodesToUpdate(), other.nodesToUpdate())
                && hasNodesToRemove() == other.hasNodesToRemove() && Objects.equals(nodesToRemove(), other.nodesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSignalCatalogRequest").add("Name", name()).add("Description", description())
                .add("NodesToAdd", hasNodesToAdd() ? nodesToAdd() : null)
                .add("NodesToUpdate", hasNodesToUpdate() ? nodesToUpdate() : null)
                .add("NodesToRemove", hasNodesToRemove() ? nodesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nodesToAdd":
            return Optional.ofNullable(clazz.cast(nodesToAdd()));
        case "nodesToUpdate":
            return Optional.ofNullable(clazz.cast(nodesToUpdate()));
        case "nodesToRemove":
            return Optional.ofNullable(clazz.cast(nodesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nodesToAdd", NODES_TO_ADD_FIELD);
        map.put("nodesToUpdate", NODES_TO_UPDATE_FIELD);
        map.put("nodesToRemove", NODES_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSignalCatalogRequest, T> g) {
        return obj -> g.apply((UpdateSignalCatalogRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSignalCatalogRequest> {
        /**
         * <p>
         * The name of the signal catalog to update.
         * </p>
         * 
         * @param name
         *        The name of the signal catalog to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A brief description of the signal catalog to update.
         * </p>
         * 
         * @param description
         *        A brief description of the signal catalog to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of information about nodes to add to the signal catalog.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of information about nodes to add to the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(Collection<Node> nodesToAdd);

        /**
         * <p>
         * A list of information about nodes to add to the signal catalog.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of information about nodes to add to the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(Node... nodesToAdd);

        /**
         * <p>
         * A list of information about nodes to add to the signal catalog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Node#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder#build()} is called immediately and its
         * result is passed to {@link #nodesToAdd(List<Node>)}.
         * 
         * @param nodesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodesToAdd(java.util.Collection<Node>)
         */
        Builder nodesToAdd(Consumer<Node.Builder>... nodesToAdd);

        /**
         * <p>
         * A list of information about nodes to update in the signal catalog.
         * </p>
         * 
         * @param nodesToUpdate
         *        A list of information about nodes to update in the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToUpdate(Collection<Node> nodesToUpdate);

        /**
         * <p>
         * A list of information about nodes to update in the signal catalog.
         * </p>
         * 
         * @param nodesToUpdate
         *        A list of information about nodes to update in the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToUpdate(Node... nodesToUpdate);

        /**
         * <p>
         * A list of information about nodes to update in the signal catalog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotfleetwise.model.Node#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder#build()} is called immediately and its
         * result is passed to {@link #nodesToUpdate(List<Node>)}.
         * 
         * @param nodesToUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.Node.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodesToUpdate(java.util.Collection<Node>)
         */
        Builder nodesToUpdate(Consumer<Node.Builder>... nodesToUpdate);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
         * </p>
         * 
         * @param nodesToRemove
         *        A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToRemove(Collection<String> nodesToRemove);

        /**
         * <p>
         * A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
         * </p>
         * 
         * @param nodesToRemove
         *        A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToRemove(String... nodesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<Node> nodesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<Node> nodesToUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSignalCatalogRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            nodesToAdd(model.nodesToAdd);
            nodesToUpdate(model.nodesToUpdate);
            nodesToRemove(model.nodesToRemove);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Node.Builder> getNodesToAdd() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.nodesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToAdd(Collection<Node.BuilderImpl> nodesToAdd) {
            this.nodesToAdd = NodesCopier.copyFromBuilder(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<Node> nodesToAdd) {
            this.nodesToAdd = NodesCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Node... nodesToAdd) {
            nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Consumer<Node.Builder>... nodesToAdd) {
            nodesToAdd(Stream.of(nodesToAdd).map(c -> Node.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Node.Builder> getNodesToUpdate() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.nodesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToUpdate(Collection<Node.BuilderImpl> nodesToUpdate) {
            this.nodesToUpdate = NodesCopier.copyFromBuilder(nodesToUpdate);
        }

        @Override
        public final Builder nodesToUpdate(Collection<Node> nodesToUpdate) {
            this.nodesToUpdate = NodesCopier.copy(nodesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToUpdate(Node... nodesToUpdate) {
            nodesToUpdate(Arrays.asList(nodesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToUpdate(Consumer<Node.Builder>... nodesToUpdate) {
            nodesToUpdate(Stream.of(nodesToUpdate).map(c -> Node.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNodesToRemove() {
            if (nodesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return nodesToRemove;
        }

        public final void setNodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
        }

        @Override
        public final Builder nodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToRemove(String... nodesToRemove) {
            nodesToRemove(Arrays.asList(nodesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSignalCatalogRequest build() {
            return new UpdateSignalCatalogRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
