/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a campaign associated with a vehicle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VehicleStatus implements SdkPojo, Serializable, ToCopyableBuilder<VehicleStatus.Builder, VehicleStatus> {
    private static final SdkField<String> CAMPAIGN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignName").getter(getter(VehicleStatus::campaignName)).setter(setter(Builder::campaignName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignName").build()).build();

    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(VehicleStatus::vehicleName)).setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(VehicleStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_NAME_FIELD,
            VEHICLE_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String campaignName;

    private final String vehicleName;

    private final String status;

    private VehicleStatus(BuilderImpl builder) {
        this.campaignName = builder.campaignName;
        this.vehicleName = builder.vehicleName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of a campaign.
     * </p>
     * 
     * @return The name of a campaign.
     */
    public final String campaignName() {
        return campaignName;
    }

    /**
     * <p>
     * The unique ID of the vehicle.
     * </p>
     * 
     * @return The unique ID of the vehicle.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The status of a campaign, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED</code> - The campaign exists but is not yet approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not arrived at
     * the vehicle yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HEALTHY</code> - The campaign is deployed to the vehicle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The campaign is being removed from the vehicle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VehicleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a campaign, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The campaign exists but is not yet approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not
     *         arrived at the vehicle yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> - The campaign is deployed to the vehicle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The campaign is being removed from the vehicle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before
     *         deployment.
     *         </p>
     *         </li>
     * @see VehicleState
     */
    public final VehicleState status() {
        return VehicleState.fromValue(status);
    }

    /**
     * <p>
     * The status of a campaign, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED</code> - The campaign exists but is not yet approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not arrived at
     * the vehicle yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HEALTHY</code> - The campaign is deployed to the vehicle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The campaign is being removed from the vehicle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VehicleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a campaign, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The campaign exists but is not yet approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not
     *         arrived at the vehicle yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> - The campaign is deployed to the vehicle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The campaign is being removed from the vehicle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before
     *         deployment.
     *         </p>
     *         </li>
     * @see VehicleState
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignName());
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VehicleStatus)) {
            return false;
        }
        VehicleStatus other = (VehicleStatus) obj;
        return Objects.equals(campaignName(), other.campaignName()) && Objects.equals(vehicleName(), other.vehicleName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VehicleStatus").add("CampaignName", campaignName()).add("VehicleName", vehicleName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignName":
            return Optional.ofNullable(clazz.cast(campaignName()));
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("campaignName", CAMPAIGN_NAME_FIELD);
        map.put("vehicleName", VEHICLE_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VehicleStatus, T> g) {
        return obj -> g.apply((VehicleStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VehicleStatus> {
        /**
         * <p>
         * The name of a campaign.
         * </p>
         * 
         * @param campaignName
         *        The name of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignName(String campaignName);

        /**
         * <p>
         * The unique ID of the vehicle.
         * </p>
         * 
         * @param vehicleName
         *        The unique ID of the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The status of a campaign, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED</code> - The campaign exists but is not yet approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not arrived
         * at the vehicle yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HEALTHY</code> - The campaign is deployed to the vehicle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The campaign is being removed from the vehicle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a campaign, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The campaign exists but is not yet approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not
         *        arrived at the vehicle yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> - The campaign is deployed to the vehicle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The campaign is being removed from the vehicle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before
         *        deployment.
         *        </p>
         *        </li>
         * @see VehicleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleState
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a campaign, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED</code> - The campaign exists but is not yet approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not arrived
         * at the vehicle yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HEALTHY</code> - The campaign is deployed to the vehicle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The campaign is being removed from the vehicle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a campaign, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The campaign exists but is not yet approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The campaign is approved but has not been deployed to the vehicle. Data has not
         *        arrived at the vehicle yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> - The campaign is deployed to the vehicle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code> - The campaign is suspended and data collection is paused.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The campaign is being removed from the vehicle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY_FOR_CHECKIN</code> - The campaign is approved and waiting for vehicle check-in before
         *        deployment.
         *        </p>
         *        </li>
         * @see VehicleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleState
         */
        Builder status(VehicleState status);
    }

    static final class BuilderImpl implements Builder {
        private String campaignName;

        private String vehicleName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VehicleStatus model) {
            campaignName(model.campaignName);
            vehicleName(model.vehicleName);
            status(model.status);
        }

        public final String getCampaignName() {
            return campaignName;
        }

        public final void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        @Override
        public final Builder campaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VehicleState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public VehicleStatus build() {
            return new VehicleStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
