/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a subset of information about a job execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSummary.Builder, JobExecutionSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobExecutionSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Long> QUEUED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecutionSummary::queuedAt)).setter(setter(Builder::queuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecutionSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecutionSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecutionSummary::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(JobExecutionSummary::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, QUEUED_AT_FIELD,
            STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, VERSION_NUMBER_FIELD, EXECUTION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final Long queuedAt;

    private final Long startedAt;

    private final Long lastUpdatedAt;

    private final Long versionNumber;

    private final Long executionNumber;

    private JobExecutionSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.versionNumber = builder.versionNumber;
        this.executionNumber = builder.executionNumber;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was enqueued.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was enqueued.
     */
    public Long queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution started.
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was last updated.
     */
    public Long lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The version of the job execution. Job execution versions are incremented each time AWS IoT Jobs receives an
     * update from a device.
     * </p>
     * 
     * @return The version of the job execution. Job execution versions are incremented each time AWS IoT Jobs receives
     *         an update from a device.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * A number that identifies a particular job execution on a particular device.
     * </p>
     * 
     * @return A number that identifies a particular job execution on a particular device.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(queuedAt(), other.queuedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(executionNumber(), other.executionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobExecutionSummary").add("JobId", jobId()).add("QueuedAt", queuedAt())
                .add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt()).add("VersionNumber", versionNumber())
                .add("ExecutionNumber", executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "queuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummary, T> g) {
        return obj -> g.apply((JobExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSummary> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was enqueued.
         * </p>
         * 
         * @param queuedAt
         *        The time, in milliseconds since the epoch, when the job execution was enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Long queuedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution started.
         * </p>
         * 
         * @param startedAt
         *        The time, in milliseconds since the epoch, when the job execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the job execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Long lastUpdatedAt);

        /**
         * <p>
         * The version of the job execution. Job execution versions are incremented each time AWS IoT Jobs receives an
         * update from a device.
         * </p>
         * 
         * @param versionNumber
         *        The version of the job execution. Job execution versions are incremented each time AWS IoT Jobs
         *        receives an update from a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * A number that identifies a particular job execution on a particular device.
         * </p>
         * 
         * @param executionNumber
         *        A number that identifies a particular job execution on a particular device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private Long queuedAt;

        private Long startedAt;

        private Long lastUpdatedAt;

        private Long versionNumber;

        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            jobId(model.jobId);
            queuedAt(model.queuedAt);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            versionNumber(model.versionNumber);
            executionNumber(model.executionNumber);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Long getQueuedAt() {
            return queuedAt;
        }

        @Override
        public final Builder queuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final void setQueuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
