/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNextPendingJobExecutionRequest extends IotJobsDataPlaneRequest implements
        ToCopyableBuilder<StartNextPendingJobExecutionRequest.Builder, StartNextPendingJobExecutionRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(StartNextPendingJobExecutionRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("statusDetails")
            .getter(getter(StartNextPendingJobExecutionRequest::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> STEP_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("stepTimeoutInMinutes").getter(getter(StartNextPendingJobExecutionRequest::stepTimeoutInMinutes))
            .setter(setter(Builder::stepTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTimeoutInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            STATUS_DETAILS_FIELD, STEP_TIMEOUT_IN_MINUTES_FIELD));

    private final String thingName;

    private final Map<String, String> statusDetails;

    private final Long stepTimeoutInMinutes;

    private StartNextPendingJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.statusDetails = builder.statusDetails;
        this.stepTimeoutInMinutes = builder.stepTimeoutInMinutes;
    }

    /**
     * <p>
     * The name of the thing associated with the device.
     * </p>
     * 
     * @return The name of the thing associated with the device.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusDetails() {
        return statusDetails != null && !(statusDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of name/value pairs that describe the status of the job execution. If not specified, the
     * statusDetails are unchanged.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusDetails} method.
     * </p>
     * 
     * @return A collection of name/value pairs that describe the status of the job execution. If not specified, the
     *         statusDetails are unchanged.
     */
    public final Map<String, String> statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * Specifies the amount of time this device has to finish execution of this job. If the job execution status is not
     * set to a terminal state before this timer expires, or before the timer is reset (by calling
     * <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout
     * value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to
     * <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may have
     * been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).
     * </p>
     * 
     * @return Specifies the amount of time this device has to finish execution of this job. If the job execution status
     *         is not set to a terminal state before this timer expires, or before the timer is reset (by calling
     *         <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new
     *         timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically
     *         set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout
     *         which may have been specified when the job was created (<code>CreateJob</code> using field
     *         <code>timeoutConfig</code>).
     */
    public final Long stepTimeoutInMinutes() {
        return stepTimeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusDetails() ? statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stepTimeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNextPendingJobExecutionRequest)) {
            return false;
        }
        StartNextPendingJobExecutionRequest other = (StartNextPendingJobExecutionRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && hasStatusDetails() == other.hasStatusDetails()
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(stepTimeoutInMinutes(), other.stepTimeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartNextPendingJobExecutionRequest").add("ThingName", thingName())
                .add("StatusDetails", hasStatusDetails() ? statusDetails() : null)
                .add("StepTimeoutInMinutes", stepTimeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "stepTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(stepTimeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNextPendingJobExecutionRequest, T> g) {
        return obj -> g.apply((StartNextPendingJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartNextPendingJobExecutionRequest> {
        /**
         * <p>
         * The name of the thing associated with the device.
         * </p>
         * 
         * @param thingName
         *        The name of the thing associated with the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A collection of name/value pairs that describe the status of the job execution. If not specified, the
         * statusDetails are unchanged.
         * </p>
         * 
         * @param statusDetails
         *        A collection of name/value pairs that describe the status of the job execution. If not specified, the
         *        statusDetails are unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(Map<String, String> statusDetails);

        /**
         * <p>
         * Specifies the amount of time this device has to finish execution of this job. If the job execution status is
         * not set to a terminal state before this timer expires, or before the timer is reset (by calling
         * <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout
         * value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to
         * <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may
         * have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).
         * </p>
         * 
         * @param stepTimeoutInMinutes
         *        Specifies the amount of time this device has to finish execution of this job. If the job execution
         *        status is not set to a terminal state before this timer expires, or before the timer is reset (by
         *        calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying
         *        a new timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be
         *        automatically set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job
         *        execution timeout which may have been specified when the job was created (<code>CreateJob</code> using
         *        field <code>timeoutConfig</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotJobsDataPlaneRequest.BuilderImpl implements Builder {
        private String thingName;

        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();

        private Long stepTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNextPendingJobExecutionRequest model) {
            super(model);
            thingName(model.thingName);
            statusDetails(model.statusDetails);
            stepTimeoutInMinutes(model.stepTimeoutInMinutes);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Map<String, String> getStatusDetails() {
            if (statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusDetails;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        @Override
        @Transient
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final Long getStepTimeoutInMinutes() {
            return stepTimeoutInMinutes;
        }

        public final void setStepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
        }

        @Override
        @Transient
        public final Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNextPendingJobExecutionRequest build() {
            return new StartNextPendingJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
