/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobExecutionResponse extends IotJobsDataPlaneResponse implements
        ToCopyableBuilder<UpdateJobExecutionResponse.Builder, UpdateJobExecutionResponse> {
    private static final SdkField<JobExecutionState> EXECUTION_STATE_FIELD = SdkField
            .<JobExecutionState> builder(MarshallingType.SDK_POJO).memberName("executionState")
            .getter(getter(UpdateJobExecutionResponse::executionState)).setter(setter(Builder::executionState))
            .constructor(JobExecutionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()).build();

    private static final SdkField<String> JOB_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDocument").getter(getter(UpdateJobExecutionResponse::jobDocument))
            .setter(setter(Builder::jobDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_STATE_FIELD,
            JOB_DOCUMENT_FIELD));

    private final JobExecutionState executionState;

    private final String jobDocument;

    private UpdateJobExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionState = builder.executionState;
        this.jobDocument = builder.jobDocument;
    }

    /**
     * <p>
     * A JobExecutionState object.
     * </p>
     * 
     * @return A JobExecutionState object.
     */
    public final JobExecutionState executionState() {
        return executionState;
    }

    /**
     * <p>
     * The contents of the Job Documents.
     * </p>
     * 
     * @return The contents of the Job Documents.
     */
    public final String jobDocument() {
        return jobDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionState());
        hashCode = 31 * hashCode + Objects.hashCode(jobDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobExecutionResponse)) {
            return false;
        }
        UpdateJobExecutionResponse other = (UpdateJobExecutionResponse) obj;
        return Objects.equals(executionState(), other.executionState()) && Objects.equals(jobDocument(), other.jobDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobExecutionResponse").add("ExecutionState", executionState())
                .add("JobDocument", jobDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionState":
            return Optional.ofNullable(clazz.cast(executionState()));
        case "jobDocument":
            return Optional.ofNullable(clazz.cast(jobDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobExecutionResponse, T> g) {
        return obj -> g.apply((UpdateJobExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateJobExecutionResponse> {
        /**
         * <p>
         * A JobExecutionState object.
         * </p>
         * 
         * @param executionState
         *        A JobExecutionState object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionState(JobExecutionState executionState);

        /**
         * <p>
         * A JobExecutionState object.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobExecutionState.Builder} avoiding the
         * need to create one manually via {@link JobExecutionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionState.Builder#build()} is called immediately and its
         * result is passed to {@link #executionState(JobExecutionState)}.
         * 
         * @param executionState
         *        a consumer that will call methods on {@link JobExecutionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionState(JobExecutionState)
         */
        default Builder executionState(Consumer<JobExecutionState.Builder> executionState) {
            return executionState(JobExecutionState.builder().applyMutation(executionState).build());
        }

        /**
         * <p>
         * The contents of the Job Documents.
         * </p>
         * 
         * @param jobDocument
         *        The contents of the Job Documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDocument(String jobDocument);
    }

    static final class BuilderImpl extends IotJobsDataPlaneResponse.BuilderImpl implements Builder {
        private JobExecutionState executionState;

        private String jobDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobExecutionResponse model) {
            super(model);
            executionState(model.executionState);
            jobDocument(model.jobDocument);
        }

        public final JobExecutionState.Builder getExecutionState() {
            return executionState != null ? executionState.toBuilder() : null;
        }

        public final void setExecutionState(JobExecutionState.BuilderImpl executionState) {
            this.executionState = executionState != null ? executionState.build() : null;
        }

        @Override
        public final Builder executionState(JobExecutionState executionState) {
            this.executionState = executionState;
            return this;
        }

        public final String getJobDocument() {
            return jobDocument;
        }

        public final void setJobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
        }

        @Override
        public final Builder jobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
            return this;
        }

        @Override
        public UpdateJobExecutionResponse build() {
            return new UpdateJobExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
