/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobExecutionResponse extends IotJobsDataPlaneResponse implements
        ToCopyableBuilder<DescribeJobExecutionResponse.Builder, DescribeJobExecutionResponse> {
    private static final SdkField<JobExecution> EXECUTION_FIELD = SdkField.<JobExecution> builder(MarshallingType.SDK_POJO)
            .memberName("execution").getter(getter(DescribeJobExecutionResponse::execution)).setter(setter(Builder::execution))
            .constructor(JobExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_FIELD));

    private final JobExecution execution;

    private DescribeJobExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.execution = builder.execution;
    }

    /**
     * <p>
     * Contains data about a job execution.
     * </p>
     * 
     * @return Contains data about a job execution.
     */
    public final JobExecution execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobExecutionResponse)) {
            return false;
        }
        DescribeJobExecutionResponse other = (DescribeJobExecutionResponse) obj;
        return Objects.equals(execution(), other.execution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobExecutionResponse").add("Execution", execution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "execution":
            return Optional.ofNullable(clazz.cast(execution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobExecutionResponse, T> g) {
        return obj -> g.apply((DescribeJobExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeJobExecutionResponse> {
        /**
         * <p>
         * Contains data about a job execution.
         * </p>
         * 
         * @param execution
         *        Contains data about a job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(JobExecution execution);

        /**
         * <p>
         * Contains data about a job execution.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecution.Builder} avoiding the need to
         * create one manually via {@link JobExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #execution(JobExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link JobExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(JobExecution)
         */
        default Builder execution(Consumer<JobExecution.Builder> execution) {
            return execution(JobExecution.builder().applyMutation(execution).build());
        }
    }

    static final class BuilderImpl extends IotJobsDataPlaneResponse.BuilderImpl implements Builder {
        private JobExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobExecutionResponse model) {
            super(model);
            execution(model.execution);
        }

        public final JobExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        public final void setExecution(JobExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        @Transient
        public final Builder execution(JobExecution execution) {
            this.execution = execution;
            return this;
        }

        @Override
        public DescribeJobExecutionResponse build() {
            return new DescribeJobExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
