/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains data about a job execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecution implements SdkPojo, Serializable, ToCopyableBuilder<JobExecution.Builder, JobExecution> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobExecution::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(JobExecution::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("statusDetails")
            .getter(getter(JobExecution::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> QUEUED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("queuedAt")
            .getter(getter(JobExecution::queuedAt)).setter(setter(Builder::queuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(JobExecution::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> LAST_UPDATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastUpdatedAt").getter(getter(JobExecution::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Long> APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("approximateSecondsBeforeTimedOut")
            .getter(getter(JobExecution::approximateSecondsBeforeTimedOut))
            .setter(setter(Builder::approximateSecondsBeforeTimedOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateSecondsBeforeTimedOut")
                    .build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionNumber").getter(getter(JobExecution::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("executionNumber").getter(getter(JobExecution::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()).build();

    private static final SdkField<String> JOB_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDocument").getter(getter(JobExecution::jobDocument)).setter(setter(Builder::jobDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            THING_NAME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, QUEUED_AT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD,
            APPROXIMATE_SECONDS_BEFORE_TIMED_OUT_FIELD, VERSION_NUMBER_FIELD, EXECUTION_NUMBER_FIELD, JOB_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String thingName;

    private final String status;

    private final Map<String, String> statusDetails;

    private final Long queuedAt;

    private final Long startedAt;

    private final Long lastUpdatedAt;

    private final Long approximateSecondsBeforeTimedOut;

    private final Long versionNumber;

    private final Long executionNumber;

    private final String jobDocument;

    private JobExecution(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.approximateSecondsBeforeTimedOut = builder.approximateSecondsBeforeTimedOut;
        this.versionNumber = builder.versionNumber;
        this.executionNumber = builder.executionNumber;
        this.jobDocument = builder.jobDocument;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the thing that is executing the job.
     * </p>
     * 
     * @return The name of the thing that is executing the job.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
     * "REJECTED", or "REMOVED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
     *         "REJECTED", or "REMOVED".
     * @see JobExecutionStatus
     */
    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
     * "REJECTED", or "REMOVED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
     *         "REJECTED", or "REMOVED".
     * @see JobExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusDetails() {
        return statusDetails != null && !(statusDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of name/value pairs that describe the status of the job execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusDetails} method.
     * </p>
     * 
     * @return A collection of name/value pairs that describe the status of the job execution.
     */
    public final Map<String, String> statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was enqueued.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was enqueued.
     */
    public final Long queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was started.
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the job execution was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the job execution was last updated.
     */
    public final Long lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The estimated number of seconds that remain before the job execution status will be changed to
     * <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return The estimated number of seconds that remain before the job execution status will be changed to
     *         <code>TIMED_OUT</code>.
     */
    public final Long approximateSecondsBeforeTimedOut() {
        return approximateSecondsBeforeTimedOut;
    }

    /**
     * <p>
     * The version of the job execution. Job execution versions are incremented each time they are updated by a device.
     * </p>
     * 
     * @return The version of the job execution. Job execution versions are incremented each time they are updated by a
     *         device.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * A number that identifies a particular job execution on a particular device. It can be used later in commands that
     * return or update job execution information.
     * </p>
     * 
     * @return A number that identifies a particular job execution on a particular device. It can be used later in
     *         commands that return or update job execution information.
     */
    public final Long executionNumber() {
        return executionNumber;
    }

    /**
     * <p>
     * The content of the job document.
     * </p>
     * 
     * @return The content of the job document.
     */
    public final String jobDocument() {
        return jobDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusDetails() ? statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(approximateSecondsBeforeTimedOut());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(jobDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecution)) {
            return false;
        }
        JobExecution other = (JobExecution) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasStatusDetails() == other.hasStatusDetails()
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(queuedAt(), other.queuedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(approximateSecondsBeforeTimedOut(), other.approximateSecondsBeforeTimedOut())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(executionNumber(), other.executionNumber())
                && Objects.equals(jobDocument(), other.jobDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobExecution").add("JobId", jobId()).add("ThingName", thingName())
                .add("Status", statusAsString()).add("StatusDetails", hasStatusDetails() ? statusDetails() : null)
                .add("QueuedAt", queuedAt()).add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ApproximateSecondsBeforeTimedOut", approximateSecondsBeforeTimedOut())
                .add("VersionNumber", versionNumber()).add("ExecutionNumber", executionNumber())
                .add("JobDocument", jobDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "queuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "approximateSecondsBeforeTimedOut":
            return Optional.ofNullable(clazz.cast(approximateSecondsBeforeTimedOut()));
        case "versionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        case "jobDocument":
            return Optional.ofNullable(clazz.cast(jobDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecution, T> g) {
        return obj -> g.apply((JobExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecution> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the thing that is executing the job.
         * </p>
         * 
         * @param thingName
         *        The name of the thing that is executing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
         * "REJECTED", or "REMOVED".
         * </p>
         * 
         * @param status
         *        The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS",
         *        "CANCELED", "REJECTED", or "REMOVED".
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS", "CANCELED",
         * "REJECTED", or "REMOVED".
         * </p>
         * 
         * @param status
         *        The status of the job execution. Can be one of: "QUEUED", "IN_PROGRESS", "FAILED", "SUCCESS",
         *        "CANCELED", "REJECTED", or "REMOVED".
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * A collection of name/value pairs that describe the status of the job execution.
         * </p>
         * 
         * @param statusDetails
         *        A collection of name/value pairs that describe the status of the job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(Map<String, String> statusDetails);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was enqueued.
         * </p>
         * 
         * @param queuedAt
         *        The time, in milliseconds since the epoch, when the job execution was enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Long queuedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was started.
         * </p>
         * 
         * @param startedAt
         *        The time, in milliseconds since the epoch, when the job execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the job execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the job execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Long lastUpdatedAt);

        /**
         * <p>
         * The estimated number of seconds that remain before the job execution status will be changed to
         * <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param approximateSecondsBeforeTimedOut
         *        The estimated number of seconds that remain before the job execution status will be changed to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut);

        /**
         * <p>
         * The version of the job execution. Job execution versions are incremented each time they are updated by a
         * device.
         * </p>
         * 
         * @param versionNumber
         *        The version of the job execution. Job execution versions are incremented each time they are updated by
         *        a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * A number that identifies a particular job execution on a particular device. It can be used later in commands
         * that return or update job execution information.
         * </p>
         * 
         * @param executionNumber
         *        A number that identifies a particular job execution on a particular device. It can be used later in
         *        commands that return or update job execution information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        /**
         * <p>
         * The content of the job document.
         * </p>
         * 
         * @param jobDocument
         *        The content of the job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDocument(String jobDocument);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String thingName;

        private String status;

        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();

        private Long queuedAt;

        private Long startedAt;

        private Long lastUpdatedAt;

        private Long approximateSecondsBeforeTimedOut;

        private Long versionNumber;

        private Long executionNumber;

        private String jobDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecution model) {
            jobId(model.jobId);
            thingName(model.thingName);
            status(model.status);
            statusDetails(model.statusDetails);
            queuedAt(model.queuedAt);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            approximateSecondsBeforeTimedOut(model.approximateSecondsBeforeTimedOut);
            versionNumber(model.versionNumber);
            executionNumber(model.executionNumber);
            jobDocument(model.jobDocument);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusDetails() {
            if (statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusDetails;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        @Override
        @Transient
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final Long getQueuedAt() {
            return queuedAt;
        }

        public final void setQueuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        @Transient
        public final Builder queuedAt(Long queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        @Transient
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Long lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Long getApproximateSecondsBeforeTimedOut() {
            return approximateSecondsBeforeTimedOut;
        }

        public final void setApproximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
        }

        @Override
        @Transient
        public final Builder approximateSecondsBeforeTimedOut(Long approximateSecondsBeforeTimedOut) {
            this.approximateSecondsBeforeTimedOut = approximateSecondsBeforeTimedOut;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        @Transient
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final String getJobDocument() {
            return jobDocument;
        }

        public final void setJobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
        }

        @Override
        @Transient
        public final Builder jobDocument(String jobDocument) {
            this.jobDocument = jobDocument;
            return this;
        }

        @Override
        public JobExecution build() {
            return new JobExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
