/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse;

/**
 * Service client for accessing AWS IoT Jobs Data Plane asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS IoT Jobs is a service that allows you to define a set of jobs — remote operations that are sent to and executed
 * on one or more devices connected to AWS IoT. For example, you can define a job that instructs a set of devices to
 * download and install application or firmware updates, reboot, rotate certificates, or perform remote troubleshooting
 * operations.
 * </p>
 * <p>
 * To create a job, you make a job document which is a description of the remote operations to be performed, and you
 * specify a list of targets that should perform the operations. The targets can be individual things, thing groups or
 * both.
 * </p>
 * <p>
 * AWS IoT Jobs sends a message to inform the targets that a job is available. The target starts the execution of the
 * job by downloading the job document, performing the operations it specifies, and reporting its progress to AWS IoT.
 * The Jobs service provides commands to track the progress of a job on a specific target and for all the targets of the
 * job
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotJobsDataPlaneAsyncClient extends AwsClient {
    String SERVICE_NAME = "iot-jobs-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.jobs.iot";

    /**
     * <p>
     * Gets details of a job execution.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return A Java Future containing the result of the DescribeJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>TerminalStateException The job is in a terminal state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.DescribeJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/DescribeJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(
            DescribeJobExecutionRequest describeJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a job execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobExecutionRequest#builder()}
     * </p>
     *
     * @param describeJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>TerminalStateException The job is in a terminal state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.DescribeJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/DescribeJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(
            Consumer<DescribeJobExecutionRequest.Builder> describeJobExecutionRequest) {
        return describeJobExecution(DescribeJobExecutionRequest.builder().applyMutation(describeJobExecutionRequest).build());
    }

    /**
     * <p>
     * Gets the list of all jobs for a thing that are not in a terminal status.
     * </p>
     *
     * @param getPendingJobExecutionsRequest
     * @return A Java Future containing the result of the GetPendingJobExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.GetPendingJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/GetPendingJobExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPendingJobExecutionsResponse> getPendingJobExecutions(
            GetPendingJobExecutionsRequest getPendingJobExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the list of all jobs for a thing that are not in a terminal status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPendingJobExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetPendingJobExecutionsRequest#builder()}
     * </p>
     *
     * @param getPendingJobExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPendingJobExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.GetPendingJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/GetPendingJobExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPendingJobExecutionsResponse> getPendingJobExecutions(
            Consumer<GetPendingJobExecutionsRequest.Builder> getPendingJobExecutionsRequest) {
        return getPendingJobExecutions(GetPendingJobExecutionsRequest.builder().applyMutation(getPendingJobExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution for a thing.
     * </p>
     *
     * @param startNextPendingJobExecutionRequest
     * @return A Java Future containing the result of the StartNextPendingJobExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.StartNextPendingJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartNextPendingJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartNextPendingJobExecutionResponse> startNextPendingJobExecution(
            StartNextPendingJobExecutionRequest startNextPendingJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution for a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNextPendingJobExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link StartNextPendingJobExecutionRequest#builder()}
     * </p>
     *
     * @param startNextPendingJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartNextPendingJobExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.StartNextPendingJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartNextPendingJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartNextPendingJobExecutionResponse> startNextPendingJobExecution(
            Consumer<StartNextPendingJobExecutionRequest.Builder> startNextPendingJobExecutionRequest) {
        return startNextPendingJobExecution(StartNextPendingJobExecutionRequest.builder()
                .applyMutation(startNextPendingJobExecutionRequest).build());
    }

    /**
     * <p>
     * Updates the status of a job execution.
     * </p>
     *
     * @param updateJobExecutionRequest
     * @return A Java Future containing the result of the UpdateJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>InvalidStateTransitionException An update attempted to change the job execution to a state that is
     *         invalid because of the job execution's current state (for example, an attempt to change a request in
     *         state SUCCESS to state IN_PROGRESS). In this case, the body of the error message also contains the
     *         executionState field.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.UpdateJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/UpdateJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateJobExecutionResponse> updateJobExecution(UpdateJobExecutionRequest updateJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a job execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateJobExecutionRequest#builder()}
     * </p>
     *
     * @param updateJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The contents of the request were invalid. For example, this code is returned
     *         when an UpdateJobExecution request contains invalid status details. The message contains details about
     *         the error.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>InvalidStateTransitionException An update attempted to change the job execution to a state that is
     *         invalid because of the job execution's current state (for example, an attempt to change a request in
     *         state SUCCESS to state IN_PROGRESS). In this case, the body of the error message also contains the
     *         executionState field.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotJobsDataPlaneException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IotJobsDataPlaneAsyncClient.UpdateJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/UpdateJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateJobExecutionResponse> updateJobExecution(
            Consumer<UpdateJobExecutionRequest.Builder> updateJobExecutionRequest) {
        return updateJobExecution(UpdateJobExecutionRequest.builder().applyMutation(updateJobExecutionRequest).build());
    }

    @Override
    default IotJobsDataPlaneServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotJobsDataPlaneAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotJobsDataPlaneAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotJobsDataPlaneAsyncClient}.
     */
    static IotJobsDataPlaneAsyncClientBuilder builder() {
        return new DefaultIotJobsDataPlaneAsyncClientBuilder();
    }
}
