/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPendingJobExecutionsResponse extends IotJobsDataPlaneResponse implements
        ToCopyableBuilder<GetPendingJobExecutionsResponse.Builder, GetPendingJobExecutionsResponse> {
    private static final SdkField<List<JobExecutionSummary>> IN_PROGRESS_JOBS_FIELD = SdkField
            .<List<JobExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("inProgressJobs")
            .getter(getter(GetPendingJobExecutionsResponse::inProgressJobs))
            .setter(setter(Builder::inProgressJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<JobExecutionSummary>> QUEUED_JOBS_FIELD = SdkField
            .<List<JobExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("queuedJobs")
            .getter(getter(GetPendingJobExecutionsResponse::queuedJobs))
            .setter(setter(Builder::queuedJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IN_PROGRESS_JOBS_FIELD,
            QUEUED_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<JobExecutionSummary> inProgressJobs;

    private final List<JobExecutionSummary> queuedJobs;

    private GetPendingJobExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.inProgressJobs = builder.inProgressJobs;
        this.queuedJobs = builder.queuedJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the InProgressJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInProgressJobs() {
        return inProgressJobs != null && !(inProgressJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of JobExecutionSummary objects with status IN_PROGRESS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInProgressJobs} method.
     * </p>
     * 
     * @return A list of JobExecutionSummary objects with status IN_PROGRESS.
     */
    public final List<JobExecutionSummary> inProgressJobs() {
        return inProgressJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueuedJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueuedJobs() {
        return queuedJobs != null && !(queuedJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of JobExecutionSummary objects with status QUEUED.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueuedJobs} method.
     * </p>
     * 
     * @return A list of JobExecutionSummary objects with status QUEUED.
     */
    public final List<JobExecutionSummary> queuedJobs() {
        return queuedJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInProgressJobs() ? inProgressJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueuedJobs() ? queuedJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPendingJobExecutionsResponse)) {
            return false;
        }
        GetPendingJobExecutionsResponse other = (GetPendingJobExecutionsResponse) obj;
        return hasInProgressJobs() == other.hasInProgressJobs() && Objects.equals(inProgressJobs(), other.inProgressJobs())
                && hasQueuedJobs() == other.hasQueuedJobs() && Objects.equals(queuedJobs(), other.queuedJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPendingJobExecutionsResponse")
                .add("InProgressJobs", hasInProgressJobs() ? inProgressJobs() : null)
                .add("QueuedJobs", hasQueuedJobs() ? queuedJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inProgressJobs":
            return Optional.ofNullable(clazz.cast(inProgressJobs()));
        case "queuedJobs":
            return Optional.ofNullable(clazz.cast(queuedJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inProgressJobs", IN_PROGRESS_JOBS_FIELD);
        map.put("queuedJobs", QUEUED_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPendingJobExecutionsResponse, T> g) {
        return obj -> g.apply((GetPendingJobExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPendingJobExecutionsResponse> {
        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * 
         * @param inProgressJobs
         *        A list of JobExecutionSummary objects with status IN_PROGRESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressJobs(Collection<JobExecutionSummary> inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * 
         * @param inProgressJobs
         *        A list of JobExecutionSummary objects with status IN_PROGRESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressJobs(JobExecutionSummary... inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status IN_PROGRESS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #inProgressJobs(List<JobExecutionSummary>)}.
         * 
         * @param inProgressJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inProgressJobs(java.util.Collection<JobExecutionSummary>)
         */
        Builder inProgressJobs(Consumer<JobExecutionSummary.Builder>... inProgressJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * 
         * @param queuedJobs
         *        A list of JobExecutionSummary objects with status QUEUED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedJobs(Collection<JobExecutionSummary> queuedJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * 
         * @param queuedJobs
         *        A list of JobExecutionSummary objects with status QUEUED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedJobs(JobExecutionSummary... queuedJobs);

        /**
         * <p>
         * A list of JobExecutionSummary objects with status QUEUED.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #queuedJobs(List<JobExecutionSummary>)}.
         * 
         * @param queuedJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queuedJobs(java.util.Collection<JobExecutionSummary>)
         */
        Builder queuedJobs(Consumer<JobExecutionSummary.Builder>... queuedJobs);
    }

    static final class BuilderImpl extends IotJobsDataPlaneResponse.BuilderImpl implements Builder {
        private List<JobExecutionSummary> inProgressJobs = DefaultSdkAutoConstructList.getInstance();

        private List<JobExecutionSummary> queuedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPendingJobExecutionsResponse model) {
            super(model);
            inProgressJobs(model.inProgressJobs);
            queuedJobs(model.queuedJobs);
        }

        public final List<JobExecutionSummary.Builder> getInProgressJobs() {
            List<JobExecutionSummary.Builder> result = JobExecutionSummaryListCopier.copyToBuilder(this.inProgressJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInProgressJobs(Collection<JobExecutionSummary.BuilderImpl> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copyFromBuilder(inProgressJobs);
        }

        @Override
        public final Builder inProgressJobs(Collection<JobExecutionSummary> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copy(inProgressJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(JobExecutionSummary... inProgressJobs) {
            inProgressJobs(Arrays.asList(inProgressJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(Consumer<JobExecutionSummary.Builder>... inProgressJobs) {
            inProgressJobs(Stream.of(inProgressJobs).map(c -> JobExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<JobExecutionSummary.Builder> getQueuedJobs() {
            List<JobExecutionSummary.Builder> result = JobExecutionSummaryListCopier.copyToBuilder(this.queuedJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueuedJobs(Collection<JobExecutionSummary.BuilderImpl> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copyFromBuilder(queuedJobs);
        }

        @Override
        public final Builder queuedJobs(Collection<JobExecutionSummary> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copy(queuedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(JobExecutionSummary... queuedJobs) {
            queuedJobs(Arrays.asList(queuedJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(Consumer<JobExecutionSummary.Builder>... queuedJobs) {
            queuedJobs(Stream.of(queuedJobs).map(c -> JobExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPendingJobExecutionsResponse build() {
            return new GetPendingJobExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
