/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCommandExecutionRequest extends IotJobsDataPlaneRequest implements
        ToCopyableBuilder<StartCommandExecutionRequest.Builder, StartCommandExecutionRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(StartCommandExecutionRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(StartCommandExecutionRequest::commandArn))
            .setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final SdkField<Map<String, CommandParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, CommandParameterValue>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(StartCommandExecutionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CommandParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("executionTimeoutSeconds").getter(getter(StartCommandExecutionRequest::executionTimeoutSeconds))
            .setter(setter(Builder::executionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartCommandExecutionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            COMMAND_ARN_FIELD, PARAMETERS_FIELD, EXECUTION_TIMEOUT_SECONDS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetArn;

    private final String commandArn;

    private final Map<String, CommandParameterValue> parameters;

    private final Long executionTimeoutSeconds;

    private final String clientToken;

    private StartCommandExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.commandArn = builder.commandArn;
        this.parameters = builder.parameters;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the device where the command execution is occurring.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the device where the command execution is occurring.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the command. For example,
     * <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandName&gt;</code>
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the command. For example,
     *         <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandName&gt;</code>
     */
    public final String commandArn() {
        return commandArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of parameters that are required by the <code>StartCommandExecution</code> API when performing the command
     * on a device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameters that are required by the <code>StartCommandExecution</code> API when performing the
     *         command on a device.
     */
    public final Map<String, CommandParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Specifies the amount of time in second the device has to finish the command execution. A timer is started as soon
     * as the command execution is created. If the command execution status is not set to another terminal state before
     * the timer expires, it will automatically update to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time in second the device has to finish the command execution. A timer is started
     *         as soon as the command execution is created. If the command execution status is not set to another
     *         terminal state before the timer expires, it will automatically update to <code>TIMED_OUT</code>.
     */
    public final Long executionTimeoutSeconds() {
        return executionTimeoutSeconds;
    }

    /**
     * <p>
     * The client token is used to implement idempotency. It ensures that the request completes no more than one time.
     * If you retry a request with the same token and the same parameters, the request will complete successfully.
     * However, if you retry the request using the same token but different parameters, an HTTP 409 conflict occurs. If
     * you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.
     * </p>
     * 
     * @return The client token is used to implement idempotency. It ensures that the request completes no more than one
     *         time. If you retry a request with the same token and the same parameters, the request will complete
     *         successfully. However, if you retry the request using the same token but different parameters, an HTTP
     *         409 conflict occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a
     *         unique client request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommandExecutionRequest)) {
            return false;
        }
        StartCommandExecutionRequest other = (StartCommandExecutionRequest) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(commandArn(), other.commandArn())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(executionTimeoutSeconds(), other.executionTimeoutSeconds())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCommandExecutionRequest").add("TargetArn", targetArn()).add("CommandArn", commandArn())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("ExecutionTimeoutSeconds", executionTimeoutSeconds()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "executionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(executionTimeoutSeconds()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommandExecutionRequest, T> g) {
        return obj -> g.apply((StartCommandExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotJobsDataPlaneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCommandExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the device where the command execution is occurring.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Number (ARN) of the device where the command execution is occurring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the command. For example,
         * <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandName&gt;</code>
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Number (ARN) of the command. For example,
         *        <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandName&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        /**
         * <p>
         * A list of parameters that are required by the <code>StartCommandExecution</code> API when performing the
         * command on a device.
         * </p>
         * 
         * @param parameters
         *        A list of parameters that are required by the <code>StartCommandExecution</code> API when performing
         *        the command on a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, CommandParameterValue> parameters);

        /**
         * <p>
         * Specifies the amount of time in second the device has to finish the command execution. A timer is started as
         * soon as the command execution is created. If the command execution status is not set to another terminal
         * state before the timer expires, it will automatically update to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param executionTimeoutSeconds
         *        Specifies the amount of time in second the device has to finish the command execution. A timer is
         *        started as soon as the command execution is created. If the command execution status is not set to
         *        another terminal state before the timer expires, it will automatically update to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeoutSeconds(Long executionTimeoutSeconds);

        /**
         * <p>
         * The client token is used to implement idempotency. It ensures that the request completes no more than one
         * time. If you retry a request with the same token and the same parameters, the request will complete
         * successfully. However, if you retry the request using the same token but different parameters, an HTTP 409
         * conflict occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client
         * request.
         * </p>
         * 
         * @param clientToken
         *        The client token is used to implement idempotency. It ensures that the request completes no more than
         *        one time. If you retry a request with the same token and the same parameters, the request will
         *        complete successfully. However, if you retry the request using the same token but different
         *        parameters, an HTTP 409 conflict occurs. If you omit this value, Amazon Web Services SDKs will
         *        automatically generate a unique client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotJobsDataPlaneRequest.BuilderImpl implements Builder {
        private String targetArn;

        private String commandArn;

        private Map<String, CommandParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Long executionTimeoutSeconds;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommandExecutionRequest model) {
            super(model);
            targetArn(model.targetArn);
            commandArn(model.commandArn);
            parameters(model.parameters);
            executionTimeoutSeconds(model.executionTimeoutSeconds);
            clientToken(model.clientToken);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final Map<String, CommandParameterValue.Builder> getParameters() {
            Map<String, CommandParameterValue.Builder> result = CommandExecutionParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, CommandParameterValue.BuilderImpl> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, CommandParameterValue> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Long getExecutionTimeoutSeconds() {
            return executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCommandExecutionRequest build() {
            return new StartCommandExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
