/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotjobsdataplane.model.CommandExecutionParameterMapCopier;
import software.amazon.awssdk.services.iotjobsdataplane.model.CommandParameterValue;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCommandExecutionRequest
extends IotJobsDataPlaneRequest
implements ToCopyableBuilder<Builder, StartCommandExecutionRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::targetArn)).setter(StartCommandExecutionRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::commandArn)).setter(StartCommandExecutionRequest.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final SdkField<Map<String, CommandParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::parameters)).setter(StartCommandExecutionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionTimeoutSeconds").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::executionTimeoutSeconds)).setter(StartCommandExecutionRequest.setter(Builder::executionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::clientToken)).setter(StartCommandExecutionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, COMMAND_ARN_FIELD, PARAMETERS_FIELD, EXECUTION_TIMEOUT_SECONDS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCommandExecutionRequest.memberNameToFieldInitializer();
    private final String targetArn;
    private final String commandArn;
    private final Map<String, CommandParameterValue> parameters;
    private final Long executionTimeoutSeconds;
    private final String clientToken;

    private StartCommandExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.commandArn = builder.commandArn;
        this.parameters = builder.parameters;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.clientToken = builder.clientToken;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, CommandParameterValue> parameters() {
        return this.parameters;
    }

    public final Long executionTimeoutSeconds() {
        return this.executionTimeoutSeconds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommandExecutionRequest)) {
            return false;
        }
        StartCommandExecutionRequest other = (StartCommandExecutionRequest)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.commandArn(), other.commandArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.executionTimeoutSeconds(), other.executionTimeoutSeconds()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartCommandExecutionRequest").add("TargetArn", (Object)this.targetArn()).add("CommandArn", (Object)this.commandArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ExecutionTimeoutSeconds", (Object)this.executionTimeoutSeconds()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "executionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutSeconds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommandExecutionRequest, T> g) {
        return obj -> g.apply((StartCommandExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotJobsDataPlaneRequest.BuilderImpl
    implements Builder {
        private String targetArn;
        private String commandArn;
        private Map<String, CommandParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Long executionTimeoutSeconds;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommandExecutionRequest model) {
            super(model);
            this.targetArn(model.targetArn);
            this.commandArn(model.commandArn);
            this.parameters(model.parameters);
            this.executionTimeoutSeconds(model.executionTimeoutSeconds);
            this.clientToken(model.clientToken);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final Map<String, CommandParameterValue.Builder> getParameters() {
            Map<String, CommandParameterValue.Builder> result = CommandExecutionParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, CommandParameterValue.BuilderImpl> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, CommandParameterValue> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Long getExecutionTimeoutSeconds() {
            return this.executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCommandExecutionRequest build() {
            return new StartCommandExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotJobsDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCommandExecutionRequest> {
        public Builder targetArn(String var1);

        public Builder commandArn(String var1);

        public Builder parameters(Map<String, CommandParameterValue> var1);

        public Builder executionTimeoutSeconds(Long var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

