/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotjobsdataplane;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotjobsdataplane.model.CertificateValidationException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ConflictException;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.InternalServerException;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidRequestException;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartCommandExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartCommandExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.TerminalStateException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ThrottlingException;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.ValidationException;

/**
 * Service client for accessing AWS IoT Jobs Data Plane. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * IoT Jobs is a service that allows you to define a set of jobs — remote operations that are sent to and executed on
 * one or more devices connected to Amazon Web Services IoT Core. For example, you can define a job that instructs a set
 * of devices to download and install application or firmware updates, reboot, rotate certificates, or perform remote
 * troubleshooting operations.
 * </p>
 * <p>
 * Find the endpoint address for actions in the IoT jobs data plane by running this CLI command:
 * </p>
 * <p>
 * <code>aws iot describe-endpoint --endpoint-type iot:Jobs</code>
 * </p>
 * <p>
 * The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Amazon Web
 * Services Signature Version 4</a> to sign requests is: <i>iot-jobs-data</i>.
 * </p>
 * <p>
 * To create a job, you make a job document which is a description of the remote operations to be performed, and you
 * specify a list of targets that should perform the operations. The targets can be individual things, thing groups or
 * both.
 * </p>
 * <p>
 * IoT Jobs sends a message to inform the targets that a job is available. The target starts the execution of the job by
 * downloading the job document, performing the operations it specifies, and reporting its progress to Amazon Web
 * Services IoT Core. The Jobs service provides commands to track the progress of a job on a specific target and for all
 * the targets of the job
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotJobsDataPlaneClient extends AwsClient {
    String SERVICE_NAME = "iot-jobs-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.jobs.iot";

    /**
     * <p>
     * Gets details of a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJobExecution</a> action.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return Result of the DescribeJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws TerminalStateException
     *         The job is in a terminal state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.DescribeJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/DescribeJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeJobExecutionResponse describeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            CertificateValidationException, TerminalStateException, AwsServiceException, SdkClientException,
            IotJobsDataPlaneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobExecutionRequest#builder()}
     * </p>
     *
     * @param describeJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws TerminalStateException
     *         The job is in a terminal state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.DescribeJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/DescribeJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeJobExecutionResponse describeJobExecution(
            Consumer<DescribeJobExecutionRequest.Builder> describeJobExecutionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException,
            TerminalStateException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        return describeJobExecution(DescribeJobExecutionRequest.builder().applyMutation(describeJobExecutionRequest).build());
    }

    /**
     * <p>
     * Gets the list of all jobs for a thing that are not in a terminal status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPendingJobExecutions</a> action.
     * </p>
     *
     * @param getPendingJobExecutionsRequest
     * @return Result of the GetPendingJobExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.GetPendingJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/GetPendingJobExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPendingJobExecutionsResponse getPendingJobExecutions(GetPendingJobExecutionsRequest getPendingJobExecutionsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the list of all jobs for a thing that are not in a terminal status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPendingJobExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPendingJobExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetPendingJobExecutionsRequest#builder()}
     * </p>
     *
     * @param getPendingJobExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the GetPendingJobExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.GetPendingJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/GetPendingJobExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPendingJobExecutionsResponse getPendingJobExecutions(
            Consumer<GetPendingJobExecutionsRequest.Builder> getPendingJobExecutionsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException,
            AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        return getPendingJobExecutions(GetPendingJobExecutionsRequest.builder().applyMutation(getPendingJobExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Using the command created with the <code>CreateCommand</code> API, start a command execution on a specific
     * device.
     * </p>
     *
     * @param startCommandExecutionRequest
     * @return Result of the StartCommandExecution operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         A conflict has occurred when performing the API request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws InternalServerException
     *         An internal server error occurred when performing the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.StartCommandExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartCommandExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCommandExecutionResponse startCommandExecution(StartCommandExecutionRequest startCommandExecutionRequest)
            throws ValidationException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException,
            IotJobsDataPlaneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using the command created with the <code>CreateCommand</code> API, start a command execution on a specific
     * device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCommandExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartCommandExecutionRequest#builder()}
     * </p>
     *
     * @param startCommandExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.StartCommandExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the StartCommandExecution operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         A conflict has occurred when performing the API request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws InternalServerException
     *         An internal server error occurred when performing the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.StartCommandExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartCommandExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCommandExecutionResponse startCommandExecution(
            Consumer<StartCommandExecutionRequest.Builder> startCommandExecutionRequest) throws ValidationException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        return startCommandExecution(StartCommandExecutionRequest.builder().applyMutation(startCommandExecutionRequest).build());
    }

    /**
     * <p>
     * Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution for a thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartNextPendingJobExecution</a> action.
     * </p>
     *
     * @param startNextPendingJobExecutionRequest
     * @return Result of the StartNextPendingJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.StartNextPendingJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartNextPendingJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNextPendingJobExecutionResponse startNextPendingJobExecution(
            StartNextPendingJobExecutionRequest startNextPendingJobExecutionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException,
            AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution for a thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartNextPendingJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNextPendingJobExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link StartNextPendingJobExecutionRequest#builder()}
     * </p>
     *
     * @param startNextPendingJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest.Builder}
     *        to create a request.
     * @return Result of the StartNextPendingJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.StartNextPendingJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/StartNextPendingJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNextPendingJobExecutionResponse startNextPendingJobExecution(
            Consumer<StartNextPendingJobExecutionRequest.Builder> startNextPendingJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        return startNextPendingJobExecution(StartNextPendingJobExecutionRequest.builder()
                .applyMutation(startNextPendingJobExecutionRequest).build());
    }

    /**
     * <p>
     * Updates the status of a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a
     * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotjobsdataplane.html"
     * >UpdateJobExecution</a> action.
     * </p>
     *
     * @param updateJobExecutionRequest
     * @return Result of the UpdateJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws InvalidStateTransitionException
     *         An update attempted to change the job execution to a state that is invalid because of the job execution's
     *         current state (for example, an attempt to change a request in state SUCCESS to state IN_PROGRESS). In
     *         this case, the body of the error message also contains the executionState field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.UpdateJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/UpdateJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobExecutionResponse updateJobExecution(UpdateJobExecutionRequest updateJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            CertificateValidationException, InvalidStateTransitionException, AwsServiceException, SdkClientException,
            IotJobsDataPlaneException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a
     * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotjobsdataplane.html"
     * >UpdateJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateJobExecutionRequest#builder()}
     * </p>
     *
     * @param updateJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The contents of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws InvalidStateTransitionException
     *         An update attempted to change the job execution to a state that is invalid because of the job execution's
     *         current state (for example, an attempt to change a request in state SUCCESS to state IN_PROGRESS). In
     *         this case, the body of the error message also contains the executionState field.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotJobsDataPlaneException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotJobsDataPlaneClient.UpdateJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-jobs-data-2017-09-29/UpdateJobExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobExecutionResponse updateJobExecution(Consumer<UpdateJobExecutionRequest.Builder> updateJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            CertificateValidationException, InvalidStateTransitionException, AwsServiceException, SdkClientException,
            IotJobsDataPlaneException {
        return updateJobExecution(UpdateJobExecutionRequest.builder().applyMutation(updateJobExecutionRequest).build());
    }

    /**
     * Create a {@link IotJobsDataPlaneClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotJobsDataPlaneClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotJobsDataPlaneClient}.
     */
    static IotJobsDataPlaneClientBuilder builder() {
        return new DefaultIotJobsDataPlaneClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IotJobsDataPlaneServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
