/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OtaType {
    ONE_TIME("ONE_TIME"),
    CONTINUOUS("CONTINUOUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OtaType> VALUE_MAP;
    private final String value;

    private OtaType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OtaType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OtaType> knownValues() {
        EnumSet<OtaType> knownValues = EnumSet.allOf(OtaType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OtaType.class, OtaType::toString);
    }
}

