/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConfigurationStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EncryptionType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDefaultEncryptionConfigurationResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, PutDefaultEncryptionConfigurationResponse> {
    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationStatus").getter(PutDefaultEncryptionConfigurationResponse.getter(PutDefaultEncryptionConfigurationResponse::configurationStatus)).setter(PutDefaultEncryptionConfigurationResponse.setter(Builder::configurationStatus)).constructor(ConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionType").getter(PutDefaultEncryptionConfigurationResponse.getter(PutDefaultEncryptionConfigurationResponse::encryptionTypeAsString)).setter(PutDefaultEncryptionConfigurationResponse.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(PutDefaultEncryptionConfigurationResponse.getter(PutDefaultEncryptionConfigurationResponse::kmsKeyArn)).setter(PutDefaultEncryptionConfigurationResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_STATUS_FIELD, ENCRYPTION_TYPE_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDefaultEncryptionConfigurationResponse.memberNameToFieldInitializer();
    private final ConfigurationStatus configurationStatus;
    private final String encryptionType;
    private final String kmsKeyArn;

    private PutDefaultEncryptionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configurationStatus = builder.configurationStatus;
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final ConfigurationStatus configurationStatus() {
        return this.configurationStatus;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDefaultEncryptionConfigurationResponse)) {
            return false;
        }
        PutDefaultEncryptionConfigurationResponse other = (PutDefaultEncryptionConfigurationResponse)((Object)obj);
        return Objects.equals(this.configurationStatus(), other.configurationStatus()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutDefaultEncryptionConfigurationResponse").add("ConfigurationStatus", (Object)this.configurationStatus()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatus()));
            }
            case "encryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDefaultEncryptionConfigurationResponse, T> g) {
        return obj -> g.apply((PutDefaultEncryptionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private ConfigurationStatus configurationStatus;
        private String encryptionType;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDefaultEncryptionConfigurationResponse model) {
            super(model);
            this.configurationStatus(model.configurationStatus);
            this.encryptionType(model.encryptionType);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return this.configurationStatus != null ? this.configurationStatus.toBuilder() : null;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public PutDefaultEncryptionConfigurationResponse build() {
            return new PutDefaultEncryptionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDefaultEncryptionConfigurationResponse> {
        public Builder configurationStatus(ConfigurationStatus var1);

        default public Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return this.configurationStatus((ConfigurationStatus)((ConfigurationStatus.Builder)ConfigurationStatus.builder().applyMutation(configurationStatus)).build());
        }

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder kmsKeyArn(String var1);
    }
}

