/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthMaterialType {
    WIFI_SETUP_QR_BAR_CODE("WIFI_SETUP_QR_BAR_CODE"),
    ZWAVE_QR_BAR_CODE("ZWAVE_QR_BAR_CODE"),
    ZIGBEE_QR_BAR_CODE("ZIGBEE_QR_BAR_CODE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthMaterialType> VALUE_MAP;
    private final String value;

    private AuthMaterialType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthMaterialType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthMaterialType> knownValues() {
        EnumSet<AuthMaterialType> knownValues = EnumSet.allOf(AuthMaterialType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthMaterialType.class, AuthMaterialType::toString);
    }
}

