/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventLogConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventLogConfigurationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(EventLogConfigurationSummary.getter(EventLogConfigurationSummary::id)).setter(EventLogConfigurationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(EventLogConfigurationSummary.getter(EventLogConfigurationSummary::resourceType)).setter(EventLogConfigurationSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(EventLogConfigurationSummary.getter(EventLogConfigurationSummary::resourceId)).setter(EventLogConfigurationSummary.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> EVENT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventLogLevel").getter(EventLogConfigurationSummary.getter(EventLogConfigurationSummary::eventLogLevelAsString)).setter(EventLogConfigurationSummary.setter(Builder::eventLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLogLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, EVENT_LOG_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventLogConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resourceType;
    private final String resourceId;
    private final String eventLogLevel;

    private EventLogConfigurationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.eventLogLevel = builder.eventLogLevel;
    }

    public final String id() {
        return this.id;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final LogLevel eventLogLevel() {
        return LogLevel.fromValue(this.eventLogLevel);
    }

    public final String eventLogLevelAsString() {
        return this.eventLogLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventLogLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventLogConfigurationSummary)) {
            return false;
        }
        EventLogConfigurationSummary other = (EventLogConfigurationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.eventLogLevelAsString(), other.eventLogLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EventLogConfigurationSummary").add("Id", (Object)this.id()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("EventLogLevel", (Object)this.eventLogLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "EventLogLevel": {
                return Optional.ofNullable(clazz.cast(this.eventLogLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("EventLogLevel", EVENT_LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventLogConfigurationSummary, T> g) {
        return obj -> g.apply((EventLogConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceType;
        private String resourceId;
        private String eventLogLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EventLogConfigurationSummary model) {
            this.id(model.id);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.eventLogLevel(model.eventLogLevel);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getEventLogLevel() {
            return this.eventLogLevel;
        }

        public final void setEventLogLevel(String eventLogLevel) {
            this.eventLogLevel = eventLogLevel;
        }

        @Override
        public final Builder eventLogLevel(String eventLogLevel) {
            this.eventLogLevel = eventLogLevel;
            return this;
        }

        @Override
        public final Builder eventLogLevel(LogLevel eventLogLevel) {
            this.eventLogLevel(eventLogLevel == null ? null : eventLogLevel.toString());
            return this;
        }

        public EventLogConfigurationSummary build() {
            return new EventLogConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventLogConfigurationSummary> {
        public Builder id(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder eventLogLevel(String var1);

        public Builder eventLogLevel(LogLevel var1);
    }
}

