/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.NotificationConfigurationListDefinitionCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.NotificationConfigurationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationConfigurationsResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, ListNotificationConfigurationsResponse> {
    private static final SdkField<List<NotificationConfigurationSummary>> NOTIFICATION_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationConfigurationList").getter(ListNotificationConfigurationsResponse.getter(ListNotificationConfigurationsResponse::notificationConfigurationList)).setter(ListNotificationConfigurationsResponse.setter(Builder::notificationConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNotificationConfigurationsResponse.getter(ListNotificationConfigurationsResponse::nextToken)).setter(ListNotificationConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_CONFIGURATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotificationConfigurationsResponse.memberNameToFieldInitializer();
    private final List<NotificationConfigurationSummary> notificationConfigurationList;
    private final String nextToken;

    private ListNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationConfigurationList = builder.notificationConfigurationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotificationConfigurationList() {
        return this.notificationConfigurationList != null && !(this.notificationConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<NotificationConfigurationSummary> notificationConfigurationList() {
        return this.notificationConfigurationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationConfigurationList() ? this.notificationConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationConfigurationsResponse)) {
            return false;
        }
        ListNotificationConfigurationsResponse other = (ListNotificationConfigurationsResponse)((Object)obj);
        return this.hasNotificationConfigurationList() == other.hasNotificationConfigurationList() && Objects.equals(this.notificationConfigurationList(), other.notificationConfigurationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationConfigurationsResponse").add("NotificationConfigurationList", this.hasNotificationConfigurationList() ? this.notificationConfigurationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotificationConfigurationList", NOTIFICATION_CONFIGURATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationConfigurationsResponse, T> g) {
        return obj -> g.apply((ListNotificationConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<NotificationConfigurationSummary> notificationConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationConfigurationsResponse model) {
            super(model);
            this.notificationConfigurationList(model.notificationConfigurationList);
            this.nextToken(model.nextToken);
        }

        public final List<NotificationConfigurationSummary.Builder> getNotificationConfigurationList() {
            List<NotificationConfigurationSummary.Builder> result = NotificationConfigurationListDefinitionCopier.copyToBuilder(this.notificationConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationConfigurationList(Collection<NotificationConfigurationSummary.BuilderImpl> notificationConfigurationList) {
            this.notificationConfigurationList = NotificationConfigurationListDefinitionCopier.copyFromBuilder(notificationConfigurationList);
        }

        @Override
        public final Builder notificationConfigurationList(Collection<NotificationConfigurationSummary> notificationConfigurationList) {
            this.notificationConfigurationList = NotificationConfigurationListDefinitionCopier.copy(notificationConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurationList(NotificationConfigurationSummary ... notificationConfigurationList) {
            this.notificationConfigurationList(Arrays.asList(notificationConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurationList(Consumer<NotificationConfigurationSummary.Builder> ... notificationConfigurationList) {
            this.notificationConfigurationList(Stream.of(notificationConfigurationList).map(c -> (NotificationConfigurationSummary)((NotificationConfigurationSummary.Builder)NotificationConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotificationConfigurationsResponse build() {
            return new ListNotificationConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationConfigurationsResponse> {
        public Builder notificationConfigurationList(Collection<NotificationConfigurationSummary> var1);

        public Builder notificationConfigurationList(NotificationConfigurationSummary ... var1);

        public Builder notificationConfigurationList(Consumer<NotificationConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

