/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskAbortConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionRolloutConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskTimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushConfig> {
    private static final SdkField<OtaTaskAbortConfig> ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbortConfig").getter(PushConfig.getter(PushConfig::abortConfig)).setter(PushConfig.setter(Builder::abortConfig)).constructor(OtaTaskAbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortConfig").build()}).build();
    private static final SdkField<OtaTaskExecutionRolloutConfig> ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RolloutConfig").getter(PushConfig.getter(PushConfig::rolloutConfig)).setter(PushConfig.setter(Builder::rolloutConfig)).constructor(OtaTaskExecutionRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolloutConfig").build()}).build();
    private static final SdkField<OtaTaskTimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeoutConfig").getter(PushConfig.getter(PushConfig::timeoutConfig)).setter(PushConfig.setter(Builder::timeoutConfig)).constructor(OtaTaskTimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABORT_CONFIG_FIELD, ROLLOUT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PushConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OtaTaskAbortConfig abortConfig;
    private final OtaTaskExecutionRolloutConfig rolloutConfig;
    private final OtaTaskTimeoutConfig timeoutConfig;

    private PushConfig(BuilderImpl builder) {
        this.abortConfig = builder.abortConfig;
        this.rolloutConfig = builder.rolloutConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    public final OtaTaskAbortConfig abortConfig() {
        return this.abortConfig;
    }

    public final OtaTaskExecutionRolloutConfig rolloutConfig() {
        return this.rolloutConfig;
    }

    public final OtaTaskTimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushConfig)) {
            return false;
        }
        PushConfig other = (PushConfig)obj;
        return Objects.equals(this.abortConfig(), other.abortConfig()) && Objects.equals(this.rolloutConfig(), other.rolloutConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PushConfig").add("AbortConfig", (Object)this.abortConfig()).add("RolloutConfig", (Object)this.rolloutConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AbortConfig": {
                return Optional.ofNullable(clazz.cast(this.abortConfig()));
            }
            case "RolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.rolloutConfig()));
            }
            case "TimeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AbortConfig", ABORT_CONFIG_FIELD);
        map.put("RolloutConfig", ROLLOUT_CONFIG_FIELD);
        map.put("TimeoutConfig", TIMEOUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushConfig, T> g) {
        return obj -> g.apply((PushConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OtaTaskAbortConfig abortConfig;
        private OtaTaskExecutionRolloutConfig rolloutConfig;
        private OtaTaskTimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PushConfig model) {
            this.abortConfig(model.abortConfig);
            this.rolloutConfig(model.rolloutConfig);
            this.timeoutConfig(model.timeoutConfig);
        }

        public final OtaTaskAbortConfig.Builder getAbortConfig() {
            return this.abortConfig != null ? this.abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(OtaTaskAbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(OtaTaskAbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final OtaTaskExecutionRolloutConfig.Builder getRolloutConfig() {
            return this.rolloutConfig != null ? this.rolloutConfig.toBuilder() : null;
        }

        public final void setRolloutConfig(OtaTaskExecutionRolloutConfig.BuilderImpl rolloutConfig) {
            this.rolloutConfig = rolloutConfig != null ? rolloutConfig.build() : null;
        }

        @Override
        public final Builder rolloutConfig(OtaTaskExecutionRolloutConfig rolloutConfig) {
            this.rolloutConfig = rolloutConfig;
            return this;
        }

        public final OtaTaskTimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(OtaTaskTimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(OtaTaskTimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public PushConfig build() {
            return new PushConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushConfig> {
        public Builder abortConfig(OtaTaskAbortConfig var1);

        default public Builder abortConfig(Consumer<OtaTaskAbortConfig.Builder> abortConfig) {
            return this.abortConfig((OtaTaskAbortConfig)((OtaTaskAbortConfig.Builder)OtaTaskAbortConfig.builder().applyMutation(abortConfig)).build());
        }

        public Builder rolloutConfig(OtaTaskExecutionRolloutConfig var1);

        default public Builder rolloutConfig(Consumer<OtaTaskExecutionRolloutConfig.Builder> rolloutConfig) {
            return this.rolloutConfig((OtaTaskExecutionRolloutConfig)((OtaTaskExecutionRolloutConfig.Builder)OtaTaskExecutionRolloutConfig.builder().applyMutation(rolloutConfig)).build());
        }

        public Builder timeoutConfig(OtaTaskTimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<OtaTaskTimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((OtaTaskTimeoutConfig)((OtaTaskTimeoutConfig.Builder)OtaTaskTimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }
    }
}

