/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeliveryDestinationType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDestinationRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, UpdateDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::name)).setter(UpdateDestinationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryDestinationArn").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::deliveryDestinationArn)).setter(UpdateDestinationRequest.setter(Builder::deliveryDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationArn").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryDestinationType").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::deliveryDestinationTypeAsString)).setter(UpdateDestinationRequest.setter(Builder::deliveryDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::roleArn)).setter(UpdateDestinationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::description)).setter(UpdateDestinationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DELIVERY_DESTINATION_ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDestinationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String deliveryDestinationArn;
    private final String deliveryDestinationType;
    private final String roleArn;
    private final String description;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
    }

    public final String name() {
        return this.name;
    }

    public final String deliveryDestinationArn() {
        return this.deliveryDestinationArn;
    }

    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(this.deliveryDestinationType);
    }

    public final String deliveryDestinationTypeAsString() {
        return this.deliveryDestinationType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.deliveryDestinationArn(), other.deliveryDestinationArn()) && Objects.equals(this.deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDestinationRequest").add("Name", (Object)this.name()).add("DeliveryDestinationArn", (Object)this.deliveryDestinationArn()).add("DeliveryDestinationType", (Object)this.deliveryDestinationTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DeliveryDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationArn()));
            }
            case "DeliveryDestinationType": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("DeliveryDestinationArn", DELIVERY_DESTINATION_ARN_FIELD);
        map.put("DeliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String deliveryDestinationArn;
        private String deliveryDestinationType;
        private String roleArn;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            this.name(model.name);
            this.deliveryDestinationArn(model.deliveryDestinationArn);
            this.deliveryDestinationType(model.deliveryDestinationType);
            this.roleArn(model.roleArn);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDeliveryDestinationArn() {
            return this.deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return this.deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDestinationRequest> {
        public Builder name(String var1);

        public Builder deliveryDestinationArn(String var1);

        public Builder deliveryDestinationType(String var1);

        public Builder deliveryDestinationType(DeliveryDestinationType var1);

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

