/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedThingsRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, ListManagedThingsRequest> {
    private static final SdkField<String> OWNER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::ownerFilter)).setter(ListManagedThingsRequest.setter(Builder::ownerFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OwnerFilter").build()}).build();
    private static final SdkField<String> CREDENTIAL_LOCKER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialLockerFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::credentialLockerFilter)).setter(ListManagedThingsRequest.setter(Builder::credentialLockerFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CredentialLockerFilter").build()}).build();
    private static final SdkField<String> ROLE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::roleFilterAsString)).setter(ListManagedThingsRequest.setter(Builder::roleFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RoleFilter").build()}).build();
    private static final SdkField<String> PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentControllerIdentifierFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::parentControllerIdentifierFilter)).setter(ListManagedThingsRequest.setter(Builder::parentControllerIdentifierFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ParentControllerIdentifierFilter").build()}).build();
    private static final SdkField<String> CONNECTOR_POLICY_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorPolicyIdFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::connectorPolicyIdFilter)).setter(ListManagedThingsRequest.setter(Builder::connectorPolicyIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectorPolicyIdFilter").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumberFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::serialNumberFilter)).setter(ListManagedThingsRequest.setter(Builder::serialNumberFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SerialNumberFilter").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatusFilter").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::provisioningStatusFilterAsString)).setter(ListManagedThingsRequest.setter(Builder::provisioningStatusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProvisioningStatusFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::nextToken)).setter(ListManagedThingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListManagedThingsRequest.getter(ListManagedThingsRequest::maxResults)).setter(ListManagedThingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FILTER_FIELD, CREDENTIAL_LOCKER_FILTER_FIELD, ROLE_FILTER_FIELD, PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD, CONNECTOR_POLICY_ID_FILTER_FIELD, SERIAL_NUMBER_FILTER_FIELD, PROVISIONING_STATUS_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedThingsRequest.memberNameToFieldInitializer();
    private final String ownerFilter;
    private final String credentialLockerFilter;
    private final String roleFilter;
    private final String parentControllerIdentifierFilter;
    private final String connectorPolicyIdFilter;
    private final String serialNumberFilter;
    private final String provisioningStatusFilter;
    private final String nextToken;
    private final Integer maxResults;

    private ListManagedThingsRequest(BuilderImpl builder) {
        super(builder);
        this.ownerFilter = builder.ownerFilter;
        this.credentialLockerFilter = builder.credentialLockerFilter;
        this.roleFilter = builder.roleFilter;
        this.parentControllerIdentifierFilter = builder.parentControllerIdentifierFilter;
        this.connectorPolicyIdFilter = builder.connectorPolicyIdFilter;
        this.serialNumberFilter = builder.serialNumberFilter;
        this.provisioningStatusFilter = builder.provisioningStatusFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String ownerFilter() {
        return this.ownerFilter;
    }

    public final String credentialLockerFilter() {
        return this.credentialLockerFilter;
    }

    public final Role roleFilter() {
        return Role.fromValue(this.roleFilter);
    }

    public final String roleFilterAsString() {
        return this.roleFilter;
    }

    public final String parentControllerIdentifierFilter() {
        return this.parentControllerIdentifierFilter;
    }

    public final String connectorPolicyIdFilter() {
        return this.connectorPolicyIdFilter;
    }

    public final String serialNumberFilter() {
        return this.serialNumberFilter;
    }

    public final ProvisioningStatus provisioningStatusFilter() {
        return ProvisioningStatus.fromValue(this.provisioningStatusFilter);
    }

    public final String provisioningStatusFilterAsString() {
        return this.provisioningStatusFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialLockerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentControllerIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorPolicyIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumberFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedThingsRequest)) {
            return false;
        }
        ListManagedThingsRequest other = (ListManagedThingsRequest)((Object)obj);
        return Objects.equals(this.ownerFilter(), other.ownerFilter()) && Objects.equals(this.credentialLockerFilter(), other.credentialLockerFilter()) && Objects.equals(this.roleFilterAsString(), other.roleFilterAsString()) && Objects.equals(this.parentControllerIdentifierFilter(), other.parentControllerIdentifierFilter()) && Objects.equals(this.connectorPolicyIdFilter(), other.connectorPolicyIdFilter()) && Objects.equals(this.serialNumberFilter(), other.serialNumberFilter()) && Objects.equals(this.provisioningStatusFilterAsString(), other.provisioningStatusFilterAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedThingsRequest").add("OwnerFilter", (Object)(this.ownerFilter() == null ? null : "*** Sensitive Data Redacted ***")).add("CredentialLockerFilter", (Object)this.credentialLockerFilter()).add("RoleFilter", (Object)this.roleFilterAsString()).add("ParentControllerIdentifierFilter", (Object)this.parentControllerIdentifierFilter()).add("ConnectorPolicyIdFilter", (Object)this.connectorPolicyIdFilter()).add("SerialNumberFilter", (Object)(this.serialNumberFilter() == null ? null : "*** Sensitive Data Redacted ***")).add("ProvisioningStatusFilter", (Object)this.provisioningStatusFilterAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerFilter": {
                return Optional.ofNullable(clazz.cast(this.ownerFilter()));
            }
            case "CredentialLockerFilter": {
                return Optional.ofNullable(clazz.cast(this.credentialLockerFilter()));
            }
            case "RoleFilter": {
                return Optional.ofNullable(clazz.cast(this.roleFilterAsString()));
            }
            case "ParentControllerIdentifierFilter": {
                return Optional.ofNullable(clazz.cast(this.parentControllerIdentifierFilter()));
            }
            case "ConnectorPolicyIdFilter": {
                return Optional.ofNullable(clazz.cast(this.connectorPolicyIdFilter()));
            }
            case "SerialNumberFilter": {
                return Optional.ofNullable(clazz.cast(this.serialNumberFilter()));
            }
            case "ProvisioningStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusFilterAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerFilter", OWNER_FILTER_FIELD);
        map.put("CredentialLockerFilter", CREDENTIAL_LOCKER_FILTER_FIELD);
        map.put("RoleFilter", ROLE_FILTER_FIELD);
        map.put("ParentControllerIdentifierFilter", PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD);
        map.put("ConnectorPolicyIdFilter", CONNECTOR_POLICY_ID_FILTER_FIELD);
        map.put("SerialNumberFilter", SERIAL_NUMBER_FILTER_FIELD);
        map.put("ProvisioningStatusFilter", PROVISIONING_STATUS_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedThingsRequest, T> g) {
        return obj -> g.apply((ListManagedThingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String ownerFilter;
        private String credentialLockerFilter;
        private String roleFilter;
        private String parentControllerIdentifierFilter;
        private String connectorPolicyIdFilter;
        private String serialNumberFilter;
        private String provisioningStatusFilter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedThingsRequest model) {
            super(model);
            this.ownerFilter(model.ownerFilter);
            this.credentialLockerFilter(model.credentialLockerFilter);
            this.roleFilter(model.roleFilter);
            this.parentControllerIdentifierFilter(model.parentControllerIdentifierFilter);
            this.connectorPolicyIdFilter(model.connectorPolicyIdFilter);
            this.serialNumberFilter(model.serialNumberFilter);
            this.provisioningStatusFilter(model.provisioningStatusFilter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getOwnerFilter() {
            return this.ownerFilter;
        }

        public final void setOwnerFilter(String ownerFilter) {
            this.ownerFilter = ownerFilter;
        }

        @Override
        public final Builder ownerFilter(String ownerFilter) {
            this.ownerFilter = ownerFilter;
            return this;
        }

        public final String getCredentialLockerFilter() {
            return this.credentialLockerFilter;
        }

        public final void setCredentialLockerFilter(String credentialLockerFilter) {
            this.credentialLockerFilter = credentialLockerFilter;
        }

        @Override
        public final Builder credentialLockerFilter(String credentialLockerFilter) {
            this.credentialLockerFilter = credentialLockerFilter;
            return this;
        }

        public final String getRoleFilter() {
            return this.roleFilter;
        }

        public final void setRoleFilter(String roleFilter) {
            this.roleFilter = roleFilter;
        }

        @Override
        public final Builder roleFilter(String roleFilter) {
            this.roleFilter = roleFilter;
            return this;
        }

        @Override
        public final Builder roleFilter(Role roleFilter) {
            this.roleFilter(roleFilter == null ? null : roleFilter.toString());
            return this;
        }

        public final String getParentControllerIdentifierFilter() {
            return this.parentControllerIdentifierFilter;
        }

        public final void setParentControllerIdentifierFilter(String parentControllerIdentifierFilter) {
            this.parentControllerIdentifierFilter = parentControllerIdentifierFilter;
        }

        @Override
        public final Builder parentControllerIdentifierFilter(String parentControllerIdentifierFilter) {
            this.parentControllerIdentifierFilter = parentControllerIdentifierFilter;
            return this;
        }

        public final String getConnectorPolicyIdFilter() {
            return this.connectorPolicyIdFilter;
        }

        public final void setConnectorPolicyIdFilter(String connectorPolicyIdFilter) {
            this.connectorPolicyIdFilter = connectorPolicyIdFilter;
        }

        @Override
        public final Builder connectorPolicyIdFilter(String connectorPolicyIdFilter) {
            this.connectorPolicyIdFilter = connectorPolicyIdFilter;
            return this;
        }

        public final String getSerialNumberFilter() {
            return this.serialNumberFilter;
        }

        public final void setSerialNumberFilter(String serialNumberFilter) {
            this.serialNumberFilter = serialNumberFilter;
        }

        @Override
        public final Builder serialNumberFilter(String serialNumberFilter) {
            this.serialNumberFilter = serialNumberFilter;
            return this;
        }

        public final String getProvisioningStatusFilter() {
            return this.provisioningStatusFilter;
        }

        public final void setProvisioningStatusFilter(String provisioningStatusFilter) {
            this.provisioningStatusFilter = provisioningStatusFilter;
        }

        @Override
        public final Builder provisioningStatusFilter(String provisioningStatusFilter) {
            this.provisioningStatusFilter = provisioningStatusFilter;
            return this;
        }

        @Override
        public final Builder provisioningStatusFilter(ProvisioningStatus provisioningStatusFilter) {
            this.provisioningStatusFilter(provisioningStatusFilter == null ? null : provisioningStatusFilter.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedThingsRequest build() {
            return new ListManagedThingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedThingsRequest> {
        public Builder ownerFilter(String var1);

        public Builder credentialLockerFilter(String var1);

        public Builder roleFilter(String var1);

        public Builder roleFilter(Role var1);

        public Builder parentControllerIdentifierFilter(String var1);

        public Builder connectorPolicyIdFilter(String var1);

        public Builder serialNumberFilter(String var1);

        public Builder provisioningStatusFilter(String var1);

        public Builder provisioningStatusFilter(ProvisioningStatus var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

