/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TargetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskProcessingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskProcessingDetails> {
    private static final SdkField<Integer> NUMBER_OF_CANCELED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfCanceledThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfCanceledThings)).setter(TaskProcessingDetails.setter(Builder::numberOfCanceledThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCanceledThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_FAILED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfFailedThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfFailedThings)).setter(TaskProcessingDetails.setter(Builder::numberOfFailedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFailedThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_IN_PROGRESS_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfInProgressThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfInProgressThings)).setter(TaskProcessingDetails.setter(Builder::numberOfInProgressThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfInProgressThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_QUEUED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfQueuedThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfQueuedThings)).setter(TaskProcessingDetails.setter(Builder::numberOfQueuedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfQueuedThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_REJECTED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRejectedThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfRejectedThings)).setter(TaskProcessingDetails.setter(Builder::numberOfRejectedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRejectedThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_REMOVED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRemovedThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfRemovedThings)).setter(TaskProcessingDetails.setter(Builder::numberOfRemovedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRemovedThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SUCCEEDED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfSucceededThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfSucceededThings)).setter(TaskProcessingDetails.setter(Builder::numberOfSucceededThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSucceededThings").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_TIMED_OUT_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfTimedOutThings").getter(TaskProcessingDetails.getter(TaskProcessingDetails::numberOfTimedOutThings)).setter(TaskProcessingDetails.setter(Builder::numberOfTimedOutThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTimedOutThings").build()}).build();
    private static final SdkField<List<String>> PROCESSING_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("processingTargets").getter(TaskProcessingDetails.getter(TaskProcessingDetails::processingTargets)).setter(TaskProcessingDetails.setter(Builder::processingTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CANCELED_THINGS_FIELD, NUMBER_OF_FAILED_THINGS_FIELD, NUMBER_OF_IN_PROGRESS_THINGS_FIELD, NUMBER_OF_QUEUED_THINGS_FIELD, NUMBER_OF_REJECTED_THINGS_FIELD, NUMBER_OF_REMOVED_THINGS_FIELD, NUMBER_OF_SUCCEEDED_THINGS_FIELD, NUMBER_OF_TIMED_OUT_THINGS_FIELD, PROCESSING_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskProcessingDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer numberOfCanceledThings;
    private final Integer numberOfFailedThings;
    private final Integer numberOfInProgressThings;
    private final Integer numberOfQueuedThings;
    private final Integer numberOfRejectedThings;
    private final Integer numberOfRemovedThings;
    private final Integer numberOfSucceededThings;
    private final Integer numberOfTimedOutThings;
    private final List<String> processingTargets;

    private TaskProcessingDetails(BuilderImpl builder) {
        this.numberOfCanceledThings = builder.numberOfCanceledThings;
        this.numberOfFailedThings = builder.numberOfFailedThings;
        this.numberOfInProgressThings = builder.numberOfInProgressThings;
        this.numberOfQueuedThings = builder.numberOfQueuedThings;
        this.numberOfRejectedThings = builder.numberOfRejectedThings;
        this.numberOfRemovedThings = builder.numberOfRemovedThings;
        this.numberOfSucceededThings = builder.numberOfSucceededThings;
        this.numberOfTimedOutThings = builder.numberOfTimedOutThings;
        this.processingTargets = builder.processingTargets;
    }

    public final Integer numberOfCanceledThings() {
        return this.numberOfCanceledThings;
    }

    public final Integer numberOfFailedThings() {
        return this.numberOfFailedThings;
    }

    public final Integer numberOfInProgressThings() {
        return this.numberOfInProgressThings;
    }

    public final Integer numberOfQueuedThings() {
        return this.numberOfQueuedThings;
    }

    public final Integer numberOfRejectedThings() {
        return this.numberOfRejectedThings;
    }

    public final Integer numberOfRemovedThings() {
        return this.numberOfRemovedThings;
    }

    public final Integer numberOfSucceededThings() {
        return this.numberOfSucceededThings;
    }

    public final Integer numberOfTimedOutThings() {
        return this.numberOfTimedOutThings;
    }

    public final boolean hasProcessingTargets() {
        return this.processingTargets != null && !(this.processingTargets instanceof SdkAutoConstructList);
    }

    public final List<String> processingTargets() {
        return this.processingTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfCanceledThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFailedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfInProgressThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfQueuedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRejectedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRemovedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSucceededThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTimedOutThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessingTargets() ? this.processingTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskProcessingDetails)) {
            return false;
        }
        TaskProcessingDetails other = (TaskProcessingDetails)obj;
        return Objects.equals(this.numberOfCanceledThings(), other.numberOfCanceledThings()) && Objects.equals(this.numberOfFailedThings(), other.numberOfFailedThings()) && Objects.equals(this.numberOfInProgressThings(), other.numberOfInProgressThings()) && Objects.equals(this.numberOfQueuedThings(), other.numberOfQueuedThings()) && Objects.equals(this.numberOfRejectedThings(), other.numberOfRejectedThings()) && Objects.equals(this.numberOfRemovedThings(), other.numberOfRemovedThings()) && Objects.equals(this.numberOfSucceededThings(), other.numberOfSucceededThings()) && Objects.equals(this.numberOfTimedOutThings(), other.numberOfTimedOutThings()) && this.hasProcessingTargets() == other.hasProcessingTargets() && Objects.equals(this.processingTargets(), other.processingTargets());
    }

    public final String toString() {
        return ToString.builder((String)"TaskProcessingDetails").add("NumberOfCanceledThings", (Object)this.numberOfCanceledThings()).add("NumberOfFailedThings", (Object)this.numberOfFailedThings()).add("NumberOfInProgressThings", (Object)this.numberOfInProgressThings()).add("NumberOfQueuedThings", (Object)this.numberOfQueuedThings()).add("NumberOfRejectedThings", (Object)this.numberOfRejectedThings()).add("NumberOfRemovedThings", (Object)this.numberOfRemovedThings()).add("NumberOfSucceededThings", (Object)this.numberOfSucceededThings()).add("NumberOfTimedOutThings", (Object)this.numberOfTimedOutThings()).add("ProcessingTargets", this.hasProcessingTargets() ? this.processingTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfCanceledThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfCanceledThings()));
            }
            case "NumberOfFailedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfFailedThings()));
            }
            case "NumberOfInProgressThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfInProgressThings()));
            }
            case "numberOfQueuedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfQueuedThings()));
            }
            case "numberOfRejectedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfRejectedThings()));
            }
            case "numberOfRemovedThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfRemovedThings()));
            }
            case "numberOfSucceededThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfSucceededThings()));
            }
            case "numberOfTimedOutThings": {
                return Optional.ofNullable(clazz.cast(this.numberOfTimedOutThings()));
            }
            case "processingTargets": {
                return Optional.ofNullable(clazz.cast(this.processingTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NumberOfCanceledThings", NUMBER_OF_CANCELED_THINGS_FIELD);
        map.put("NumberOfFailedThings", NUMBER_OF_FAILED_THINGS_FIELD);
        map.put("NumberOfInProgressThings", NUMBER_OF_IN_PROGRESS_THINGS_FIELD);
        map.put("numberOfQueuedThings", NUMBER_OF_QUEUED_THINGS_FIELD);
        map.put("numberOfRejectedThings", NUMBER_OF_REJECTED_THINGS_FIELD);
        map.put("numberOfRemovedThings", NUMBER_OF_REMOVED_THINGS_FIELD);
        map.put("numberOfSucceededThings", NUMBER_OF_SUCCEEDED_THINGS_FIELD);
        map.put("numberOfTimedOutThings", NUMBER_OF_TIMED_OUT_THINGS_FIELD);
        map.put("processingTargets", PROCESSING_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskProcessingDetails, T> g) {
        return obj -> g.apply((TaskProcessingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfCanceledThings;
        private Integer numberOfFailedThings;
        private Integer numberOfInProgressThings;
        private Integer numberOfQueuedThings;
        private Integer numberOfRejectedThings;
        private Integer numberOfRemovedThings;
        private Integer numberOfSucceededThings;
        private Integer numberOfTimedOutThings;
        private List<String> processingTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskProcessingDetails model) {
            this.numberOfCanceledThings(model.numberOfCanceledThings);
            this.numberOfFailedThings(model.numberOfFailedThings);
            this.numberOfInProgressThings(model.numberOfInProgressThings);
            this.numberOfQueuedThings(model.numberOfQueuedThings);
            this.numberOfRejectedThings(model.numberOfRejectedThings);
            this.numberOfRemovedThings(model.numberOfRemovedThings);
            this.numberOfSucceededThings(model.numberOfSucceededThings);
            this.numberOfTimedOutThings(model.numberOfTimedOutThings);
            this.processingTargets(model.processingTargets);
        }

        public final Integer getNumberOfCanceledThings() {
            return this.numberOfCanceledThings;
        }

        public final void setNumberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
        }

        @Override
        public final Builder numberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
            return this;
        }

        public final Integer getNumberOfFailedThings() {
            return this.numberOfFailedThings;
        }

        public final void setNumberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
        }

        @Override
        public final Builder numberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
            return this;
        }

        public final Integer getNumberOfInProgressThings() {
            return this.numberOfInProgressThings;
        }

        public final void setNumberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
        }

        @Override
        public final Builder numberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
            return this;
        }

        public final Integer getNumberOfQueuedThings() {
            return this.numberOfQueuedThings;
        }

        public final void setNumberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
        }

        @Override
        public final Builder numberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
            return this;
        }

        public final Integer getNumberOfRejectedThings() {
            return this.numberOfRejectedThings;
        }

        public final void setNumberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
        }

        @Override
        public final Builder numberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
            return this;
        }

        public final Integer getNumberOfRemovedThings() {
            return this.numberOfRemovedThings;
        }

        public final void setNumberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
        }

        @Override
        public final Builder numberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
            return this;
        }

        public final Integer getNumberOfSucceededThings() {
            return this.numberOfSucceededThings;
        }

        public final void setNumberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
        }

        @Override
        public final Builder numberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
            return this;
        }

        public final Integer getNumberOfTimedOutThings() {
            return this.numberOfTimedOutThings;
        }

        public final void setNumberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
        }

        @Override
        public final Builder numberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
            return this;
        }

        public final Collection<String> getProcessingTargets() {
            if (this.processingTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processingTargets;
        }

        public final void setProcessingTargets(Collection<String> processingTargets) {
            this.processingTargets = TargetCopier.copy(processingTargets);
        }

        @Override
        public final Builder processingTargets(Collection<String> processingTargets) {
            this.processingTargets = TargetCopier.copy(processingTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingTargets(String ... processingTargets) {
            this.processingTargets(Arrays.asList(processingTargets));
            return this;
        }

        public TaskProcessingDetails build() {
            return new TaskProcessingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskProcessingDetails> {
        public Builder numberOfCanceledThings(Integer var1);

        public Builder numberOfFailedThings(Integer var1);

        public Builder numberOfInProgressThings(Integer var1);

        public Builder numberOfQueuedThings(Integer var1);

        public Builder numberOfRejectedThings(Integer var1);

        public Builder numberOfRemovedThings(Integer var1);

        public Builder numberOfSucceededThings(Integer var1);

        public Builder numberOfTimedOutThings(Integer var1);

        public Builder processingTargets(Collection<String> var1);

        public Builder processingTargets(String ... var1);
    }
}

