/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindow;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindowListCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchedulingConfigEndBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OtaTaskSchedulingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OtaTaskSchedulingConfig> {
    private static final SdkField<String> END_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndBehavior").getter(OtaTaskSchedulingConfig.getter(OtaTaskSchedulingConfig::endBehaviorAsString)).setter(OtaTaskSchedulingConfig.setter(Builder::endBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndBehavior").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(OtaTaskSchedulingConfig.getter(OtaTaskSchedulingConfig::endTime)).setter(OtaTaskSchedulingConfig.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<ScheduleMaintenanceWindow>> MAINTENANCE_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MaintenanceWindows").getter(OtaTaskSchedulingConfig.getter(OtaTaskSchedulingConfig::maintenanceWindows)).setter(OtaTaskSchedulingConfig.setter(Builder::maintenanceWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduleMaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(OtaTaskSchedulingConfig.getter(OtaTaskSchedulingConfig::startTime)).setter(OtaTaskSchedulingConfig.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_BEHAVIOR_FIELD, END_TIME_FIELD, MAINTENANCE_WINDOWS_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OtaTaskSchedulingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endBehavior;
    private final String endTime;
    private final List<ScheduleMaintenanceWindow> maintenanceWindows;
    private final String startTime;

    private OtaTaskSchedulingConfig(BuilderImpl builder) {
        this.endBehavior = builder.endBehavior;
        this.endTime = builder.endTime;
        this.maintenanceWindows = builder.maintenanceWindows;
        this.startTime = builder.startTime;
    }

    public final SchedulingConfigEndBehavior endBehavior() {
        return SchedulingConfigEndBehavior.fromValue(this.endBehavior);
    }

    public final String endBehaviorAsString() {
        return this.endBehavior;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final boolean hasMaintenanceWindows() {
        return this.maintenanceWindows != null && !(this.maintenanceWindows instanceof SdkAutoConstructList);
    }

    public final List<ScheduleMaintenanceWindow> maintenanceWindows() {
        return this.maintenanceWindows;
    }

    public final String startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaintenanceWindows() ? this.maintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskSchedulingConfig)) {
            return false;
        }
        OtaTaskSchedulingConfig other = (OtaTaskSchedulingConfig)obj;
        return Objects.equals(this.endBehaviorAsString(), other.endBehaviorAsString()) && Objects.equals(this.endTime(), other.endTime()) && this.hasMaintenanceWindows() == other.hasMaintenanceWindows() && Objects.equals(this.maintenanceWindows(), other.maintenanceWindows()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"OtaTaskSchedulingConfig").add("EndBehavior", (Object)this.endBehaviorAsString()).add("EndTime", (Object)this.endTime()).add("MaintenanceWindows", this.hasMaintenanceWindows() ? this.maintenanceWindows() : null).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndBehavior": {
                return Optional.ofNullable(clazz.cast(this.endBehaviorAsString()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "MaintenanceWindows": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindows()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndBehavior", END_BEHAVIOR_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MaintenanceWindows", MAINTENANCE_WINDOWS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskSchedulingConfig, T> g) {
        return obj -> g.apply((OtaTaskSchedulingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endBehavior;
        private String endTime;
        private List<ScheduleMaintenanceWindow> maintenanceWindows = DefaultSdkAutoConstructList.getInstance();
        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskSchedulingConfig model) {
            this.endBehavior(model.endBehavior);
            this.endTime(model.endTime);
            this.maintenanceWindows(model.maintenanceWindows);
            this.startTime(model.startTime);
        }

        public final String getEndBehavior() {
            return this.endBehavior;
        }

        public final void setEndBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
        }

        @Override
        public final Builder endBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
            return this;
        }

        @Override
        public final Builder endBehavior(SchedulingConfigEndBehavior endBehavior) {
            this.endBehavior(endBehavior == null ? null : endBehavior.toString());
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ScheduleMaintenanceWindow.Builder> getMaintenanceWindows() {
            List<ScheduleMaintenanceWindow.Builder> result = ScheduleMaintenanceWindowListCopier.copyToBuilder(this.maintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceWindows(Collection<ScheduleMaintenanceWindow.BuilderImpl> maintenanceWindows) {
            this.maintenanceWindows = ScheduleMaintenanceWindowListCopier.copyFromBuilder(maintenanceWindows);
        }

        @Override
        public final Builder maintenanceWindows(Collection<ScheduleMaintenanceWindow> maintenanceWindows) {
            this.maintenanceWindows = ScheduleMaintenanceWindowListCopier.copy(maintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(ScheduleMaintenanceWindow ... maintenanceWindows) {
            this.maintenanceWindows(Arrays.asList(maintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(Consumer<ScheduleMaintenanceWindow.Builder> ... maintenanceWindows) {
            this.maintenanceWindows(Stream.of(maintenanceWindows).map(c -> (ScheduleMaintenanceWindow)((ScheduleMaintenanceWindow.Builder)ScheduleMaintenanceWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public OtaTaskSchedulingConfig build() {
            return new OtaTaskSchedulingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OtaTaskSchedulingConfig> {
        public Builder endBehavior(String var1);

        public Builder endBehavior(SchedulingConfigEndBehavior var1);

        public Builder endTime(String var1);

        public Builder maintenanceWindows(Collection<ScheduleMaintenanceWindow> var1);

        public Builder maintenanceWindows(ScheduleMaintenanceWindow ... var1);

        public Builder maintenanceWindows(Consumer<ScheduleMaintenanceWindow.Builder> ... var1);

        public Builder startTime(String var1);
    }
}

