/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryModification {
    DISCOVERED("DISCOVERED"),
    UPDATED("UPDATED"),
    NO_CHANGE("NO_CHANGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryModification> VALUE_MAP;
    private final String value;

    private DiscoveryModification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryModification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryModification> knownValues() {
        EnumSet<DiscoveryModification> knownValues = EnumSet.allOf(DiscoveryModification.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryModification.class, DiscoveryModification::toString);
    }
}

