/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaVersionFormat {
    AWS("AWS"),
    ZCL("ZCL"),
    CONNECTOR("CONNECTOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaVersionFormat> VALUE_MAP;
    private final String value;

    private SchemaVersionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaVersionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaVersionFormat> knownValues() {
        EnumSet<SchemaVersionFormat> knownValues = EnumSet.allOf(SchemaVersionFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaVersionFormat.class, SchemaVersionFormat::toString);
    }
}

