/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EndpointConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EndpointType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudConnectorRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateCloudConnectorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCloudConnectorRequest.getter(CreateCloudConnectorRequest::name)).setter(CreateCloudConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfig").getter(CreateCloudConnectorRequest.getter(CreateCloudConnectorRequest::endpointConfig)).setter(CreateCloudConnectorRequest.setter(Builder::endpointConfig)).constructor(EndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCloudConnectorRequest.getter(CreateCloudConnectorRequest::description)).setter(CreateCloudConnectorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(CreateCloudConnectorRequest.getter(CreateCloudConnectorRequest::endpointTypeAsString)).setter(CreateCloudConnectorRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCloudConnectorRequest.getter(CreateCloudConnectorRequest::clientToken)).setter(CreateCloudConnectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENDPOINT_CONFIG_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudConnectorRequest.memberNameToFieldInitializer();
    private final String name;
    private final EndpointConfig endpointConfig;
    private final String description;
    private final String endpointType;
    private final String clientToken;

    private CreateCloudConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.endpointConfig = builder.endpointConfig;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final EndpointConfig endpointConfig() {
        return this.endpointConfig;
    }

    public final String description() {
        return this.description;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudConnectorRequest)) {
            return false;
        }
        CreateCloudConnectorRequest other = (CreateCloudConnectorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.endpointConfig(), other.endpointConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudConnectorRequest").add("Name", (Object)this.name()).add("EndpointConfig", (Object)this.endpointConfig()).add("Description", (Object)this.description()).add("EndpointType", (Object)this.endpointTypeAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.endpointConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("EndpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudConnectorRequest, T> g) {
        return obj -> g.apply((CreateCloudConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private EndpointConfig endpointConfig;
        private String description;
        private String endpointType;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudConnectorRequest model) {
            super(model);
            this.name(model.name);
            this.endpointConfig(model.endpointConfig);
            this.description(model.description);
            this.endpointType(model.endpointType);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return this.endpointConfig != null ? this.endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudConnectorRequest build() {
            return new CreateCloudConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudConnectorRequest> {
        public Builder name(String var1);

        public Builder endpointConfig(EndpointConfig var1);

        default public Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return this.endpointConfig((EndpointConfig)((EndpointConfig.Builder)EndpointConfig.builder().applyMutation(endpointConfig)).build());
        }

        public Builder description(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

