/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.IotManagedIntegrationsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AccessDeniedException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConflictException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InternalFailureException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InternalServerException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InvalidRequestException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.LimitExceededException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ThrottlingException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UnauthorizedException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ValidationException;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateCloudConnectorRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateConnectorDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateCredentialLockerRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateEventLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateManagedThingRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateOtaTaskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateOtaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.CreateProvisioningProfileRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteCloudConnectorRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteConnectorDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteCredentialLockerRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteEventLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteManagedThingRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteOtaTaskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteOtaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeleteProvisioningProfileRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.DeregisterAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetCloudConnectorRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetConnectorDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetCredentialLockerRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetCustomEndpointRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetDeviceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetEventLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetHubConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetManagedThingCapabilitiesRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetManagedThingConnectivityDataRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetManagedThingMetaDataRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetManagedThingRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetManagedThingStateRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetOtaTaskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetOtaTaskRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetProvisioningProfileRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetRuntimeLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.GetSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListAccountAssociationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListCloudConnectorsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListConnectorDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListCredentialLockersRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListDeviceDiscoveriesRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListDiscoveredDevicesRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListEventLogConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListManagedThingAccountAssociationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListManagedThingSchemasRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListManagedThingsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListOtaTaskConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListOtaTaskExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListOtaTasksRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListProvisioningProfilesRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListSchemaVersionsRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.PutDefaultEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.PutHubConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.PutRuntimeLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.RegisterAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.RegisterCustomEndpointRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.ResetRuntimeLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.SendConnectorEventRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.SendManagedThingCommandRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.StartAccountAssociationRefreshRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.StartDeviceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateAccountAssociationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateCloudConnectorRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateConnectorDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateDestinationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateEventLogConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateManagedThingRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iotmanagedintegrations.transform.UpdateOtaTaskRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IotManagedIntegrationsClient}.
 *
 * @see IotManagedIntegrationsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotManagedIntegrationsClient implements IotManagedIntegrationsClient {
    private static final Logger log = Logger.loggerFor(DefaultIotManagedIntegrationsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotManagedIntegrationsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "IoT_Managed_Integrations" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a new account association via the destination id.
     * </p>
     *
     * @param createAccountAssociationRequest
     * @return Result of the CreateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountAssociationResponse createAccountAssociation(
            CreateAccountAssociationRequest createAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ServiceUnavailableException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountAssociationRequest, CreateAccountAssociationResponse>()
                            .withOperationName("CreateAccountAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAccountAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a C2C (cloud-to-cloud) connector.
     * </p>
     *
     * @param createCloudConnectorRequest
     * @return Result of the CreateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudConnectorResponse createCloudConnector(CreateCloudConnectorRequest createCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCloudConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudConnector");

            return clientHandler.execute(new ClientExecutionParams<CreateCloudConnectorRequest, CreateCloudConnectorResponse>()
                    .withOperationName("CreateCloudConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCloudConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCloudConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     *
     * @param createConnectorDestinationRequest
     * @return Result of the CreateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectorDestinationResponse createConnectorDestination(
            CreateConnectorDestinationRequest createConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectorDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectorDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectorDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectorDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectorDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConnectorDestinationRequest, CreateConnectorDestinationResponse>()
                            .withOperationName("CreateConnectorDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createConnectorDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConnectorDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a product credential locker. This operation will trigger the creation of all the manufacturing resources
     * including the Wi-Fi setup key pair and device certificate.
     * </p>
     *
     * @param createCredentialLockerRequest
     * @return Result of the CreateCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCredentialLockerResponse createCredentialLocker(CreateCredentialLockerRequest createCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCredentialLockerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCredentialLockerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCredentialLockerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCredentialLockerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCredentialLocker");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCredentialLockerRequest, CreateCredentialLockerResponse>()
                            .withOperationName("CreateCredentialLocker").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCredentialLockerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCredentialLockerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a destination. IoT managed integrations uses the destination to determine where to deliver notifications
     * for a device.
     * </p>
     *
     * @param createDestinationRequest
     * @return Result of the CreateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDestinationResponse createDestination(CreateDestinationRequest createDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDestination");

            return clientHandler.execute(new ClientExecutionParams<CreateDestinationRequest, CreateDestinationResponse>()
                    .withOperationName("CreateDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Set the event log configuration for the account, resource type, or specific resource.
     * </p>
     *
     * @param createEventLogConfigurationRequest
     * @return Result of the CreateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventLogConfigurationResponse createEventLogConfiguration(
            CreateEventLogConfigurationRequest createEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventLogConfigurationRequest, CreateEventLogConfigurationResponse>()
                            .withOperationName("CreateEventLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEventLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a managed thing. A managed thing contains the device identifier, protocol supported, and capabilities of
     * the device in a protocol-specific format.
     * </p>
     *
     * @param createManagedThingRequest
     * @return Result of the CreateManagedThing operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateManagedThingResponse createManagedThing(CreateManagedThingRequest createManagedThingRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateManagedThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateManagedThingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createManagedThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createManagedThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateManagedThing");

            return clientHandler.execute(new ClientExecutionParams<CreateManagedThingRequest, CreateManagedThingResponse>()
                    .withOperationName("CreateManagedThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createManagedThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateManagedThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a notification configuration. A configuration is a connection between an event type and a destination
     * that you have already created.
     * </p>
     *
     * @param createNotificationConfigurationRequest
     * @return Result of the CreateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNotificationConfigurationResponse createNotificationConfiguration(
            CreateNotificationConfigurationRequest createNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNotificationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNotificationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNotificationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotificationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNotificationConfigurationRequest, CreateNotificationConfigurationResponse>()
                            .withOperationName("CreateNotificationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNotificationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNotificationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an over-the-air (OTA) task to update a device.
     * </p>
     *
     * @param createOtaTaskRequest
     * @return Result of the CreateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOtaTaskResponse createOtaTask(CreateOtaTaskRequest createOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOtaTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOtaTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOtaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOtaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOtaTask");

            return clientHandler.execute(new ClientExecutionParams<CreateOtaTaskRequest, CreateOtaTaskResponse>()
                    .withOperationName("CreateOtaTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOtaTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOtaTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param createOtaTaskConfigurationRequest
     * @return Result of the CreateOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOtaTaskConfigurationResponse createOtaTaskConfiguration(
            CreateOtaTaskConfigurationRequest createOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOtaTaskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateOtaTaskConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOtaTaskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOtaTaskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOtaTaskConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOtaTaskConfigurationRequest, CreateOtaTaskConfigurationResponse>()
                            .withOperationName("CreateOtaTaskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createOtaTaskConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateOtaTaskConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a provisioning profile for a device to execute the provisioning flows using a provisioning template. The
     * provisioning template is a document that defines the set of resources and policies applied to a device during the
     * provisioning process.
     * </p>
     *
     * @param createProvisioningProfileRequest
     * @return Result of the CreateProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateProvisioningProfileResponse createProvisioningProfile(
            CreateProvisioningProfileRequest createProvisioningProfileRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ConflictException, ServiceUnavailableException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningProfileRequest, CreateProvisioningProfileResponse>()
                            .withOperationName("CreateProvisioningProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a third party account and related devices from an end user.
     * </p>
     *
     * @param deleteAccountAssociationRequest
     * @return Result of the DeleteAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountAssociationResponse deleteAccountAssociation(
            DeleteAccountAssociationRequest deleteAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ServiceUnavailableException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAssociationRequest, DeleteAccountAssociationResponse>()
                            .withOperationName("DeleteAccountAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a cloud connector.
     * </p>
     *
     * @param deleteCloudConnectorRequest
     * @return Result of the DeleteCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudConnectorResponse deleteCloudConnector(DeleteCloudConnectorRequest deleteCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCloudConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudConnector");

            return clientHandler.execute(new ClientExecutionParams<DeleteCloudConnectorRequest, DeleteCloudConnectorResponse>()
                    .withOperationName("DeleteCloudConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCloudConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCloudConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     *
     * @param deleteConnectorDestinationRequest
     * @return Result of the DeleteConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectorDestinationResponse deleteConnectorDestination(
            DeleteConnectorDestinationRequest deleteConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectorDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectorDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectorDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectorDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectorDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectorDestinationRequest, DeleteConnectorDestinationResponse>()
                            .withOperationName("DeleteConnectorDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConnectorDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConnectorDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation can't be undone and any existing device won't be able to use IoT managed integrations.
     * </p>
     * </note>
     *
     * @param deleteCredentialLockerRequest
     * @return Result of the DeleteCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCredentialLockerResponse deleteCredentialLocker(DeleteCredentialLockerRequest deleteCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCredentialLockerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCredentialLockerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCredentialLockerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCredentialLockerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCredentialLocker");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCredentialLockerRequest, DeleteCredentialLockerResponse>()
                            .withOperationName("DeleteCredentialLocker").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCredentialLockerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCredentialLockerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a customer-managed destination specified by id.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDestination");

            return clientHandler.execute(new ClientExecutionParams<DeleteDestinationRequest, DeleteDestinationResponse>()
                    .withOperationName("DeleteDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an event log configuration.
     * </p>
     *
     * @param deleteEventLogConfigurationRequest
     * @return Result of the DeleteEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventLogConfigurationResponse deleteEventLogConfiguration(
            DeleteEventLogConfigurationRequest deleteEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventLogConfigurationRequest, DeleteEventLogConfigurationResponse>()
                            .withOperationName("DeleteEventLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEventLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a managed thing. If a controller is deleted, all of the devices connected to it will have their status
     * changed to <code>PENDING</code>. It is not possible to remove a cloud device.
     * </p>
     *
     * @param deleteManagedThingRequest
     * @return Result of the DeleteManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteManagedThingResponse deleteManagedThing(DeleteManagedThingRequest deleteManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteManagedThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteManagedThingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteManagedThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteManagedThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteManagedThing");

            return clientHandler.execute(new ClientExecutionParams<DeleteManagedThingRequest, DeleteManagedThingResponse>()
                    .withOperationName("DeleteManagedThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteManagedThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteManagedThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a notification configuration.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNotificationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteNotificationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNotificationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotificationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNotificationConfigurationRequest, DeleteNotificationConfigurationResponse>()
                            .withOperationName("DeleteNotificationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNotificationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNotificationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task.
     * </p>
     *
     * @param deleteOtaTaskRequest
     * @return Result of the DeleteOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws LimitExceededException
     *         The request exceeds a service limit or quota. Adjust your request parameters and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOtaTaskResponse deleteOtaTask(DeleteOtaTaskRequest deleteOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOtaTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOtaTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOtaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOtaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOtaTask");

            return clientHandler.execute(new ClientExecutionParams<DeleteOtaTaskRequest, DeleteOtaTaskResponse>()
                    .withOperationName("DeleteOtaTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOtaTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOtaTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task configuration.
     * </p>
     *
     * @param deleteOtaTaskConfigurationRequest
     * @return Result of the DeleteOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOtaTaskConfigurationResponse deleteOtaTaskConfiguration(
            DeleteOtaTaskConfigurationRequest deleteOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOtaTaskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOtaTaskConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOtaTaskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOtaTaskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOtaTaskConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOtaTaskConfigurationRequest, DeleteOtaTaskConfigurationResponse>()
                            .withOperationName("DeleteOtaTaskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOtaTaskConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOtaTaskConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a provisioning profile.
     * </p>
     *
     * @param deleteProvisioningProfileRequest
     * @return Result of the DeleteProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProvisioningProfileResponse deleteProvisioningProfile(
            DeleteProvisioningProfileRequest deleteProvisioningProfileRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisioningProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisioningProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProvisioningProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisioningProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisioningProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningProfileRequest, DeleteProvisioningProfileResponse>()
                            .withOperationName("DeleteProvisioningProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteProvisioningProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisioningProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters an account association, removing the connection between a managed thing and a third-party account.
     * </p>
     *
     * @param deregisterAccountAssociationRequest
     *        Request for deregister a managed thing from account association
     * @return Result of the DeregisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeregisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeregisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterAccountAssociationResponse deregisterAccountAssociation(
            DeregisterAccountAssociationRequest deregisterAccountAssociationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterAccountAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterAccountAssociationRequest, DeregisterAccountAssociationResponse>()
                            .withOperationName("DeregisterAccountAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterAccountAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get an account association for an Amazon Web Services account linked to a customer-managed destination.
     * </p>
     *
     * @param getAccountAssociationRequest
     * @return Result of the GetAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetAccountAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccountAssociationResponse getAccountAssociation(GetAccountAssociationRequest getAccountAssociationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountAssociation");

            return clientHandler.execute(new ClientExecutionParams<GetAccountAssociationRequest, GetAccountAssociationResponse>()
                    .withOperationName("GetAccountAssociation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccountAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all the information about a connector for a connector developer.
     * </p>
     *
     * @param getCloudConnectorRequest
     * @return Result of the GetCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudConnectorResponse getCloudConnector(GetCloudConnectorRequest getCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudConnectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCloudConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudConnector");

            return clientHandler.execute(new ClientExecutionParams<GetCloudConnectorRequest, GetCloudConnectorResponse>()
                    .withOperationName("GetCloudConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCloudConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCloudConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a connector destination of a cloud-to-cloud (C2C) connector connecting to a customer's Amazon Web Services
     * account.
     * </p>
     *
     * @param getConnectorDestinationRequest
     * @return Result of the GetConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConnectorDestinationResponse getConnectorDestination(GetConnectorDestinationRequest getConnectorDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectorDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectorDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConnectorDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectorDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectorDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConnectorDestinationRequest, GetConnectorDestinationResponse>()
                            .withOperationName("GetConnectorDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getConnectorDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConnectorDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information on an existing credential locker
     * </p>
     *
     * @param getCredentialLockerRequest
     * @return Result of the GetCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCredentialLockerResponse getCredentialLocker(GetCredentialLockerRequest getCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCredentialLockerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCredentialLockerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCredentialLockerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCredentialLockerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCredentialLocker");

            return clientHandler.execute(new ClientExecutionParams<GetCredentialLockerRequest, GetCredentialLockerResponse>()
                    .withOperationName("GetCredentialLocker").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCredentialLockerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCredentialLockerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the IoT managed integrations custom endpoint.
     * </p>
     *
     * @param getCustomEndpointRequest
     * @return Result of the GetCustomEndpoint operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCustomEndpointResponse getCustomEndpoint(GetCustomEndpointRequest getCustomEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCustomEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCustomEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCustomEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCustomEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomEndpoint");

            return clientHandler.execute(new ClientExecutionParams<GetCustomEndpointRequest, GetCustomEndpointResponse>()
                    .withOperationName("GetCustomEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCustomEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCustomEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param getDefaultEncryptionConfigurationRequest
     * @return Result of the GetDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDefaultEncryptionConfigurationResponse getDefaultEncryptionConfiguration(
            GetDefaultEncryptionConfigurationRequest getDefaultEncryptionConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalFailureException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDefaultEncryptionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDefaultEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultEncryptionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDefaultEncryptionConfigurationRequest, GetDefaultEncryptionConfigurationResponse>()
                            .withOperationName("GetDefaultEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDefaultEncryptionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDefaultEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a destination by ID.
     * </p>
     *
     * @param getDestinationRequest
     * @return Result of the GetDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDestinationResponse getDestination(GetDestinationRequest getDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDestination");

            return clientHandler.execute(new ClientExecutionParams<GetDestinationRequest, GetDestinationResponse>()
                    .withOperationName("GetDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the current state of a device discovery.
     * </p>
     *
     * @param getDeviceDiscoveryRequest
     * @return Result of the GetDeviceDiscovery operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeviceDiscoveryResponse getDeviceDiscovery(GetDeviceDiscoveryRequest getDeviceDiscoveryRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceDiscoveryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeviceDiscoveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeviceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceDiscovery");

            return clientHandler.execute(new ClientExecutionParams<GetDeviceDiscoveryRequest, GetDeviceDiscoveryResponse>()
                    .withOperationName("GetDeviceDiscovery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeviceDiscoveryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeviceDiscoveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get an event log configuration.
     * </p>
     *
     * @param getEventLogConfigurationRequest
     * @return Result of the GetEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventLogConfigurationResponse getEventLogConfiguration(
            GetEventLogConfigurationRequest getEventLogConfigurationRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEventLogConfigurationRequest, GetEventLogConfigurationResponse>()
                            .withOperationName("GetEventLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEventLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEventLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a hub configuration.
     * </p>
     *
     * @param getHubConfigurationRequest
     * @return Result of the GetHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetHubConfigurationResponse getHubConfiguration(GetHubConfigurationRequest getHubConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetHubConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetHubConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHubConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHubConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHubConfiguration");

            return clientHandler.execute(new ClientExecutionParams<GetHubConfigurationRequest, GetHubConfigurationResponse>()
                    .withOperationName("GetHubConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getHubConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetHubConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the attributes and capabilities associated with a managed thing.
     * </p>
     *
     * @param getManagedThingRequest
     * @return Result of the GetManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedThingResponse getManagedThing(GetManagedThingRequest getManagedThingRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetManagedThingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedThing");

            return clientHandler.execute(new ClientExecutionParams<GetManagedThingRequest, GetManagedThingResponse>()
                    .withOperationName("GetManagedThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getManagedThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetManagedThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the capabilities for a managed thing using the device ID.
     * </p>
     *
     * @param getManagedThingCapabilitiesRequest
     * @return Result of the GetManagedThingCapabilities operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingCapabilities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCapabilities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedThingCapabilitiesResponse getManagedThingCapabilities(
            GetManagedThingCapabilitiesRequest getManagedThingCapabilitiesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedThingCapabilitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetManagedThingCapabilitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedThingCapabilitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedThingCapabilitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedThingCapabilities");

            return clientHandler
                    .execute(new ClientExecutionParams<GetManagedThingCapabilitiesRequest, GetManagedThingCapabilitiesResponse>()
                            .withOperationName("GetManagedThingCapabilities").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getManagedThingCapabilitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetManagedThingCapabilitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the connectivity status of a managed thing.
     * </p>
     *
     * @param getManagedThingConnectivityDataRequest
     * @return Result of the GetManagedThingConnectivityData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingConnectivityData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingConnectivityData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedThingConnectivityDataResponse getManagedThingConnectivityData(
            GetManagedThingConnectivityDataRequest getManagedThingConnectivityDataRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedThingConnectivityDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetManagedThingConnectivityDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedThingConnectivityDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getManagedThingConnectivityDataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedThingConnectivityData");

            return clientHandler
                    .execute(new ClientExecutionParams<GetManagedThingConnectivityDataRequest, GetManagedThingConnectivityDataResponse>()
                            .withOperationName("GetManagedThingConnectivityData").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getManagedThingConnectivityDataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetManagedThingConnectivityDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the metadata information for a managed thing.
     * </p>
     * <note>
     * <p>
     * The <code>managedThing</code> <code>metadata</code> parameter is used for associating attributes with a
     * <code>managedThing</code> that can be used for grouping over-the-air (OTA) tasks. Name value pairs in
     * <code>metadata</code> can be used in the <code>OtaTargetQueryString</code> parameter for the
     * <code>CreateOtaTask</code> API operation.
     * </p>
     * </note>
     *
     * @param getManagedThingMetaDataRequest
     * @return Result of the GetManagedThingMetaData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingMetaData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingMetaData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedThingMetaDataResponse getManagedThingMetaData(GetManagedThingMetaDataRequest getManagedThingMetaDataRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedThingMetaDataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetManagedThingMetaDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedThingMetaDataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedThingMetaDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedThingMetaData");

            return clientHandler
                    .execute(new ClientExecutionParams<GetManagedThingMetaDataRequest, GetManagedThingMetaDataResponse>()
                            .withOperationName("GetManagedThingMetaData").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getManagedThingMetaDataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetManagedThingMetaDataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the managed thing state for the given device Id.
     * </p>
     *
     * @param getManagedThingStateRequest
     * @return Result of the GetManagedThingState operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedThingStateResponse getManagedThingState(GetManagedThingStateRequest getManagedThingStateRequest)
            throws ValidationException, AccessDeniedException, InternalFailureException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedThingStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetManagedThingStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedThingStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedThingStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedThingState");

            return clientHandler.execute(new ClientExecutionParams<GetManagedThingStateRequest, GetManagedThingStateResponse>()
                    .withOperationName("GetManagedThingState").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getManagedThingStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetManagedThingStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a notification configuration.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetNotificationConfigurationResponse getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNotificationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetNotificationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNotificationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNotificationConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNotificationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetNotificationConfigurationRequest, GetNotificationConfigurationResponse>()
                            .withOperationName("GetNotificationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getNotificationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetNotificationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the over-the-air (OTA) task.
     * </p>
     *
     * @param getOtaTaskRequest
     * @return Result of the GetOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOtaTaskResponse getOtaTask(GetOtaTaskRequest getOtaTaskRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOtaTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOtaTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOtaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOtaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOtaTask");

            return clientHandler.execute(new ClientExecutionParams<GetOtaTaskRequest, GetOtaTaskResponse>()
                    .withOperationName("GetOtaTask").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getOtaTaskRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOtaTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param getOtaTaskConfigurationRequest
     * @return Result of the GetOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOtaTaskConfigurationResponse getOtaTaskConfiguration(GetOtaTaskConfigurationRequest getOtaTaskConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOtaTaskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOtaTaskConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOtaTaskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOtaTaskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOtaTaskConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOtaTaskConfigurationRequest, GetOtaTaskConfigurationResponse>()
                            .withOperationName("GetOtaTaskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getOtaTaskConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOtaTaskConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a provisioning profile by template name.
     * </p>
     *
     * @param getProvisioningProfileRequest
     * @return Result of the GetProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetProvisioningProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProvisioningProfileResponse getProvisioningProfile(GetProvisioningProfileRequest getProvisioningProfileRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProvisioningProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetProvisioningProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getProvisioningProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProvisioningProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProvisioningProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<GetProvisioningProfileRequest, GetProvisioningProfileResponse>()
                            .withOperationName("GetProvisioningProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getProvisioningProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetProvisioningProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param getRuntimeLogConfigurationRequest
     * @return Result of the GetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRuntimeLogConfigurationResponse getRuntimeLogConfiguration(
            GetRuntimeLogConfigurationRequest getRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRuntimeLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRuntimeLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRuntimeLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRuntimeLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRuntimeLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRuntimeLogConfigurationRequest, GetRuntimeLogConfigurationResponse>()
                            .withOperationName("GetRuntimeLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRuntimeLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRuntimeLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a schema version with the provided information.
     * </p>
     *
     * @param getSchemaVersionRequest
     * @return Result of the GetSchemaVersion operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSchemaVersionResponse getSchemaVersion(GetSchemaVersionRequest getSchemaVersionRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSchemaVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSchemaVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaVersion");

            return clientHandler.execute(new ClientExecutionParams<GetSchemaVersionRequest, GetSchemaVersionResponse>()
                    .withOperationName("GetSchemaVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSchemaVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSchemaVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all account associations, with optional filtering by connector destination ID.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssociationsResponse listAccountAssociations(ListAccountAssociationsRequest listAccountAssociationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccountAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccountAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssociationsRequest, ListAccountAssociationsResponse>()
                            .withOperationName("ListAccountAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAccountAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of connectors based on permissions.
     * </p>
     *
     * @param listCloudConnectorsRequest
     * @return Result of the ListCloudConnectors operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudConnectorsResponse listCloudConnectors(ListCloudConnectorsRequest listCloudConnectorsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudConnectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudConnectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudConnectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCloudConnectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudConnectors");

            return clientHandler.execute(new ClientExecutionParams<ListCloudConnectorsRequest, ListCloudConnectorsResponse>()
                    .withOperationName("ListCloudConnectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCloudConnectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCloudConnectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all connector destinations, with optional filtering by cloud connector ID.
     * </p>
     *
     * @param listConnectorDestinationsRequest
     * @return Result of the ListConnectorDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConnectorDestinationsResponse listConnectorDestinations(
            ListConnectorDestinationsRequest listConnectorDestinationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConnectorDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConnectorDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConnectorDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConnectorDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConnectorDestinations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConnectorDestinationsRequest, ListConnectorDestinationsResponse>()
                            .withOperationName("ListConnectorDestinations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listConnectorDestinationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListConnectorDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List information on an existing credential locker.
     * </p>
     *
     * @param listCredentialLockersRequest
     * @return Result of the ListCredentialLockers operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCredentialLockersResponse listCredentialLockers(ListCredentialLockersRequest listCredentialLockersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCredentialLockersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCredentialLockersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCredentialLockersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCredentialLockersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCredentialLockers");

            return clientHandler.execute(new ClientExecutionParams<ListCredentialLockersRequest, ListCredentialLockersResponse>()
                    .withOperationName("ListCredentialLockers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCredentialLockersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCredentialLockersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all destination names under one Amazon Web Services account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return Result of the ListDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDestinationsResponse listDestinations(ListDestinationsRequest listDestinationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDestinations");

            return clientHandler.execute(new ClientExecutionParams<ListDestinationsRequest, ListDestinationsResponse>()
                    .withOperationName("ListDestinations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDestinationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all device discovery tasks, with optional filtering by type and status.
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     * @return Result of the ListDeviceDiscoveries operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceDiscoveriesResponse listDeviceDiscoveries(ListDeviceDiscoveriesRequest listDeviceDiscoveriesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceDiscoveriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeviceDiscoveriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeviceDiscoveriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceDiscoveriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceDiscoveries");

            return clientHandler.execute(new ClientExecutionParams<ListDeviceDiscoveriesRequest, ListDeviceDiscoveriesResponse>()
                    .withOperationName("ListDeviceDiscoveries").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDeviceDiscoveriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDeviceDiscoveriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all devices discovered during a specific device discovery task.
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     * @return Result of the ListDiscoveredDevices operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDiscoveredDevicesResponse listDiscoveredDevices(ListDiscoveredDevicesRequest listDiscoveredDevicesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDiscoveredDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDiscoveredDevicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDiscoveredDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDiscoveredDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDiscoveredDevices");

            return clientHandler.execute(new ClientExecutionParams<ListDiscoveredDevicesRequest, ListDiscoveredDevicesResponse>()
                    .withOperationName("ListDiscoveredDevices").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDiscoveredDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDiscoveredDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all event log configurations for an account.
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     * @return Result of the ListEventLogConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventLogConfigurationsResponse listEventLogConfigurations(
            ListEventLogConfigurationsRequest listEventLogConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventLogConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventLogConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventLogConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventLogConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventLogConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEventLogConfigurationsRequest, ListEventLogConfigurationsResponse>()
                            .withOperationName("ListEventLogConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEventLogConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEventLogConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all account associations for a specific managed thing.
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     * @return Result of the ListManagedThingAccountAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedThingAccountAssociationsResponse listManagedThingAccountAssociations(
            ListManagedThingAccountAssociationsRequest listManagedThingAccountAssociationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedThingAccountAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedThingAccountAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedThingAccountAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listManagedThingAccountAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedThingAccountAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListManagedThingAccountAssociationsRequest, ListManagedThingAccountAssociationsResponse>()
                            .withOperationName("ListManagedThingAccountAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listManagedThingAccountAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListManagedThingAccountAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List schemas associated with a managed thing.
     * </p>
     *
     * @param listManagedThingSchemasRequest
     * @return Result of the ListManagedThingSchemas operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedThingSchemasResponse listManagedThingSchemas(ListManagedThingSchemasRequest listManagedThingSchemasRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedThingSchemasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedThingSchemasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedThingSchemasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedThingSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedThingSchemas");

            return clientHandler
                    .execute(new ClientExecutionParams<ListManagedThingSchemasRequest, ListManagedThingSchemasResponse>()
                            .withOperationName("ListManagedThingSchemas").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listManagedThingSchemasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListManagedThingSchemasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Listing all managed things with provision for filters.
     * </p>
     *
     * @param listManagedThingsRequest
     * @return Result of the ListManagedThings operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedThingsResponse listManagedThings(ListManagedThingsRequest listManagedThingsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedThingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListManagedThingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedThingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedThingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedThings");

            return clientHandler.execute(new ClientExecutionParams<ListManagedThingsRequest, ListManagedThingsResponse>()
                    .withOperationName("ListManagedThings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listManagedThingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListManagedThingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all notification configurations.
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return Result of the ListNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNotificationConfigurationsResponse listNotificationConfigurations(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNotificationConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNotificationConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotificationConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listNotificationConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotificationConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListNotificationConfigurationsRequest, ListNotificationConfigurationsResponse>()
                            .withOperationName("ListNotificationConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listNotificationConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListNotificationConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task configurations.
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     * @return Result of the ListOtaTaskConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOtaTaskConfigurationsResponse listOtaTaskConfigurations(
            ListOtaTaskConfigurationsRequest listOtaTaskConfigurationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOtaTaskConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOtaTaskConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOtaTaskConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOtaTaskConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOtaTaskConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOtaTaskConfigurationsRequest, ListOtaTaskConfigurationsResponse>()
                            .withOperationName("ListOtaTaskConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listOtaTaskConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOtaTaskConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task executions.
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     * @return Result of the ListOtaTaskExecutions operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOtaTaskExecutionsResponse listOtaTaskExecutions(ListOtaTaskExecutionsRequest listOtaTaskExecutionsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOtaTaskExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOtaTaskExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOtaTaskExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOtaTaskExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOtaTaskExecutions");

            return clientHandler.execute(new ClientExecutionParams<ListOtaTaskExecutionsRequest, ListOtaTaskExecutionsResponse>()
                    .withOperationName("ListOtaTaskExecutions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOtaTaskExecutionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOtaTaskExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) tasks.
     * </p>
     *
     * @param listOtaTasksRequest
     * @return Result of the ListOtaTasks operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOtaTasksResponse listOtaTasks(ListOtaTasksRequest listOtaTasksRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOtaTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOtaTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOtaTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOtaTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOtaTasks");

            return clientHandler.execute(new ClientExecutionParams<ListOtaTasksRequest, ListOtaTasksResponse>()
                    .withOperationName("ListOtaTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOtaTasksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOtaTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the provisioning profiles within the Amazon Web Services account.
     * </p>
     *
     * @param listProvisioningProfilesRequest
     * @return Result of the ListProvisioningProfiles operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisioningProfilesResponse listProvisioningProfiles(
            ListProvisioningProfilesRequest listProvisioningProfilesRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisioningProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisioningProfilesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProvisioningProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisioningProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningProfiles");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningProfilesRequest, ListProvisioningProfilesResponse>()
                            .withOperationName("ListProvisioningProfiles").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listProvisioningProfilesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisioningProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists schema versions with the provided information.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSchemaVersionsResponse listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSchemaVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSchemaVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaVersions");

            return clientHandler.execute(new ClientExecutionParams<ListSchemaVersionsRequest, ListSchemaVersionsResponse>()
                    .withOperationName("ListSchemaVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSchemaVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSchemaVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws UnauthorizedException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * AWS IoT SiteWise User Guide.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalFailureException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDefaultEncryptionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDefaultEncryptionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDefaultEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putDefaultEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDefaultEncryptionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDefaultEncryptionConfigurationRequest, PutDefaultEncryptionConfigurationResponse>()
                            .withOperationName("PutDefaultEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putDefaultEncryptionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDefaultEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a hub configuration.
     * </p>
     *
     * @param putHubConfigurationRequest
     * @return Result of the PutHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutHubConfigurationResponse putHubConfiguration(PutHubConfigurationRequest putHubConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutHubConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutHubConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putHubConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putHubConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutHubConfiguration");

            return clientHandler.execute(new ClientExecutionParams<PutHubConfigurationRequest, PutHubConfigurationResponse>()
                    .withOperationName("PutHubConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putHubConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutHubConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Set the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param putRuntimeLogConfigurationRequest
     * @return Result of the PutRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRuntimeLogConfigurationResponse putRuntimeLogConfiguration(
            PutRuntimeLogConfigurationRequest putRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRuntimeLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRuntimeLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRuntimeLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRuntimeLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRuntimeLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRuntimeLogConfigurationRequest, PutRuntimeLogConfigurationResponse>()
                            .withOperationName("PutRuntimeLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putRuntimeLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRuntimeLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers an account association with a managed thing, establishing a connection between a device and a
     * third-party account.
     * </p>
     *
     * @param registerAccountAssociationRequest
     * @return Result of the RegisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterAccountAssociationResponse registerAccountAssociation(
            RegisterAccountAssociationRequest registerAccountAssociationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterAccountAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterAccountAssociationRequest, RegisterAccountAssociationResponse>()
                            .withOperationName("RegisterAccountAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerAccountAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Customers can request IoT managed integrations to manage the server trust for them or bring their own external
     * server trusts for the custom domain. Returns an IoT managed integrations endpoint.
     * </p>
     *
     * @param registerCustomEndpointRequest
     * @return Result of the RegisterCustomEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterCustomEndpointResponse registerCustomEndpoint(RegisterCustomEndpointRequest registerCustomEndpointRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterCustomEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterCustomEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCustomEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCustomEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCustomEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterCustomEndpointRequest, RegisterCustomEndpointResponse>()
                            .withOperationName("RegisterCustomEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerCustomEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterCustomEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reset a runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param resetRuntimeLogConfigurationRequest
     * @return Result of the ResetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ResetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ResetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResetRuntimeLogConfigurationResponse resetRuntimeLogConfiguration(
            ResetRuntimeLogConfigurationRequest resetRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetRuntimeLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResetRuntimeLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetRuntimeLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetRuntimeLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetRuntimeLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<ResetRuntimeLogConfigurationRequest, ResetRuntimeLogConfigurationResponse>()
                            .withOperationName("ResetRuntimeLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(resetRuntimeLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResetRuntimeLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Relays third-party device events for a connector such as a new device or a device state change event.
     * </p>
     *
     * @param sendConnectorEventRequest
     * @return Result of the SendConnectorEvent operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendConnectorEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendConnectorEvent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendConnectorEventResponse sendConnectorEvent(SendConnectorEventRequest sendConnectorEventRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendConnectorEventResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SendConnectorEventResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendConnectorEventRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendConnectorEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendConnectorEvent");

            return clientHandler.execute(new ClientExecutionParams<SendConnectorEventRequest, SendConnectorEventResponse>()
                    .withOperationName("SendConnectorEvent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(sendConnectorEventRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendConnectorEventRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Send the command to the device represented by the managed thing.
     * </p>
     *
     * @param sendManagedThingCommandRequest
     * @return Result of the SendManagedThingCommand operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendManagedThingCommand
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendManagedThingCommand"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendManagedThingCommandResponse sendManagedThingCommand(SendManagedThingCommandRequest sendManagedThingCommandRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendManagedThingCommandResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SendManagedThingCommandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendManagedThingCommandRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendManagedThingCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendManagedThingCommand");

            return clientHandler
                    .execute(new ClientExecutionParams<SendManagedThingCommandRequest, SendManagedThingCommandResponse>()
                            .withOperationName("SendManagedThingCommand").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(sendManagedThingCommandRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SendManagedThingCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a refresh of an existing account association to update its authorization and connection status.
     * </p>
     *
     * @param startAccountAssociationRefreshRequest
     * @return Result of the StartAccountAssociationRefresh operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartAccountAssociationRefresh
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartAccountAssociationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAccountAssociationRefreshResponse startAccountAssociationRefresh(
            StartAccountAssociationRefreshRequest startAccountAssociationRefreshRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAccountAssociationRefreshResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAccountAssociationRefreshResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAccountAssociationRefreshRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startAccountAssociationRefreshRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAccountAssociationRefresh");

            return clientHandler
                    .execute(new ClientExecutionParams<StartAccountAssociationRefreshRequest, StartAccountAssociationRefreshResponse>()
                            .withOperationName("StartAccountAssociationRefresh").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startAccountAssociationRefreshRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAccountAssociationRefreshRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is used to start device discovery for hub-connected and third-party-connected devices. The
     * authentication material (install code) is passed as a message to the controller telling it to start the
     * discovery.
     * </p>
     *
     * @param startDeviceDiscoveryRequest
     * @return Result of the StartDeviceDiscovery operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDeviceDiscoveryResponse startDeviceDiscovery(StartDeviceDiscoveryRequest startDeviceDiscoveryRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDeviceDiscoveryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDeviceDiscoveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDeviceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDeviceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDeviceDiscovery");

            return clientHandler.execute(new ClientExecutionParams<StartDeviceDiscoveryRequest, StartDeviceDiscoveryResponse>()
                    .withOperationName("StartDeviceDiscovery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startDeviceDiscoveryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartDeviceDiscoveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws UnauthorizedException,
            ConflictException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove tags for the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnauthorizedException,
            ConflictException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the properties of an existing account association.
     * </p>
     *
     * @param updateAccountAssociationRequest
     * @return Result of the UpdateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountAssociationResponse updateAccountAssociation(
            UpdateAccountAssociationRequest updateAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountAssociationRequest, UpdateAccountAssociationResponse>()
                            .withOperationName("UpdateAccountAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAccountAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an existing cloud connector.
     * </p>
     *
     * @param updateCloudConnectorRequest
     * @return Result of the UpdateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudConnectorResponse updateCloudConnector(UpdateCloudConnectorRequest updateCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCloudConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCloudConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCloudConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudConnector");

            return clientHandler.execute(new ClientExecutionParams<UpdateCloudConnectorRequest, UpdateCloudConnectorResponse>()
                    .withOperationName("UpdateCloudConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCloudConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCloudConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the properties of an existing connector destination.
     * </p>
     *
     * @param updateConnectorDestinationRequest
     * @return Result of the UpdateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectorDestinationResponse updateConnectorDestination(
            UpdateConnectorDestinationRequest updateConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectorDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectorDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConnectorDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectorDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectorDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectorDestinationRequest, UpdateConnectorDestinationResponse>()
                            .withOperationName("UpdateConnectorDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateConnectorDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConnectorDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a destination specified by id.
     * </p>
     *
     * @param updateDestinationRequest
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDestination");

            return clientHandler.execute(new ClientExecutionParams<UpdateDestinationRequest, UpdateDestinationResponse>()
                    .withOperationName("UpdateDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an event log configuration by log configuration ID.
     * </p>
     *
     * @param updateEventLogConfigurationRequest
     * @return Result of the UpdateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventLogConfigurationResponse updateEventLogConfiguration(
            UpdateEventLogConfigurationRequest updateEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventLogConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventLogConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventLogConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventLogConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventLogConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventLogConfigurationRequest, UpdateEventLogConfigurationResponse>()
                            .withOperationName("UpdateEventLogConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateEventLogConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventLogConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the attributes and capabilities associated with a managed thing.
     * </p>
     *
     * @param updateManagedThingRequest
     * @return Result of the UpdateManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateManagedThingResponse updateManagedThing(UpdateManagedThingRequest updateManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateManagedThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateManagedThingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateManagedThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateManagedThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateManagedThing");

            return clientHandler.execute(new ClientExecutionParams<UpdateManagedThingRequest, UpdateManagedThingResponse>()
                    .withOperationName("UpdateManagedThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateManagedThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateManagedThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a notification configuration.
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     * @return Result of the UpdateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateNotificationConfigurationResponse updateNotificationConfiguration(
            UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNotificationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateNotificationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNotificationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotificationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateNotificationConfigurationRequest, UpdateNotificationConfigurationResponse>()
                            .withOperationName("UpdateNotificationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateNotificationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateNotificationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an over-the-air (OTA) task.
     * </p>
     *
     * @param updateOtaTaskRequest
     * @return Result of the UpdateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOtaTaskResponse updateOtaTask(UpdateOtaTaskRequest updateOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOtaTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateOtaTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOtaTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOtaTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT Managed Integrations");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOtaTask");

            return clientHandler.execute(new ClientExecutionParams<UpdateOtaTaskRequest, UpdateOtaTaskResponse>()
                    .withOperationName("UpdateOtaTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateOtaTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateOtaTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        IotManagedIntegrationsServiceClientConfigurationBuilder serviceConfigBuilder = new IotManagedIntegrationsServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IotManagedIntegrationsException::builder).protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1");
    }

    @Override
    public final IotManagedIntegrationsServiceClientConfiguration serviceClientConfiguration() {
        return new IotManagedIntegrationsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
