/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesPublisher;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsPublisher;

/**
 * Service client for accessing Managed integrations for AWS IoT Device Management asynchronously. This can be created
 * using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Managed integrations is a feature of AWS IoT Device Management that enables developers to quickly build innovative
 * IoT solutions. Customers can use managed integrations to automate device setup workflows and support interoperability
 * across many devices, regardless of device vendor or connectivity protocol. This allows developers to use a single
 * user-interface to control, manage, and operate a range of devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotManagedIntegrationsAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotmanagedintegrations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotmanagedintegrations";

    /**
     * <p>
     * Creates a new account association via the destination id.
     * </p>
     *
     * @param createAccountAssociationRequest
     * @return A Java Future containing the result of the CreateAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssociationResponse> createAccountAssociation(
            CreateAccountAssociationRequest createAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new account association via the destination id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountAssociationRequest#builder()}
     * </p>
     *
     * @param createAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccountAssociationResponse> createAccountAssociation(
            Consumer<CreateAccountAssociationRequest.Builder> createAccountAssociationRequest) {
        return createAccountAssociation(CreateAccountAssociationRequest.builder().applyMutation(createAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a C2C (cloud-to-cloud) connector.
     * </p>
     *
     * @param createCloudConnectorRequest
     * @return A Java Future containing the result of the CreateCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudConnectorResponse> createCloudConnector(
            CreateCloudConnectorRequest createCloudConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a C2C (cloud-to-cloud) connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCloudConnectorRequest#builder()}
     * </p>
     *
     * @param createCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudConnectorResponse> createCloudConnector(
            Consumer<CreateCloudConnectorRequest.Builder> createCloudConnectorRequest) {
        return createCloudConnector(CreateCloudConnectorRequest.builder().applyMutation(createCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Create a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     *
     * @param createConnectorDestinationRequest
     * @return A Java Future containing the result of the CreateConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDestinationResponse> createConnectorDestination(
            CreateConnectorDestinationRequest createConnectorDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param createConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConnectorDestinationResponse> createConnectorDestination(
            Consumer<CreateConnectorDestinationRequest.Builder> createConnectorDestinationRequest) {
        return createConnectorDestination(CreateConnectorDestinationRequest.builder()
                .applyMutation(createConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Create a product credential locker. This operation will trigger the creation of all the manufacturing resources
     * including the Wi-Fi setup key pair and device certificate.
     * </p>
     *
     * @param createCredentialLockerRequest
     * @return A Java Future containing the result of the CreateCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this request.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCredentialLockerResponse> createCredentialLocker(
            CreateCredentialLockerRequest createCredentialLockerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a product credential locker. This operation will trigger the creation of all the manufacturing resources
     * including the Wi-Fi setup key pair and device certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCredentialLockerRequest#builder()}
     * </p>
     *
     * @param createCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this request.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCredentialLockerResponse> createCredentialLocker(
            Consumer<CreateCredentialLockerRequest.Builder> createCredentialLockerRequest) {
        return createCredentialLocker(CreateCredentialLockerRequest.builder().applyMutation(createCredentialLockerRequest)
                .build());
    }

    /**
     * <p>
     * Create a destination. IoT managed integrations uses the destination to determine where to deliver notifications
     * for a device.
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a destination. IoT managed integrations uses the destination to determine where to deliver notifications
     * for a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(
            Consumer<CreateDestinationRequest.Builder> createDestinationRequest) {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Set the event log configuration for the account, resource type, or specific resource.
     * </p>
     *
     * @param createEventLogConfigurationRequest
     * @return A Java Future containing the result of the CreateEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this request.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventLogConfigurationResponse> createEventLogConfiguration(
            CreateEventLogConfigurationRequest createEventLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the event log configuration for the account, resource type, or specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param createEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this request.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventLogConfigurationResponse> createEventLogConfiguration(
            Consumer<CreateEventLogConfigurationRequest.Builder> createEventLogConfigurationRequest) {
        return createEventLogConfiguration(CreateEventLogConfigurationRequest.builder()
                .applyMutation(createEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a managed thing. A managed thing contains the device identifier, protocol supported, and capabilities of
     * the device in a protocol-specific format.
     * </p>
     *
     * @param createManagedThingRequest
     * @return A Java Future containing the result of the CreateManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateManagedThingResponse> createManagedThing(CreateManagedThingRequest createManagedThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed thing. A managed thing contains the device identifier, protocol supported, and capabilities of
     * the device in a protocol-specific format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateManagedThingRequest#builder()}
     * </p>
     *
     * @param createManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateManagedThingResponse> createManagedThing(
            Consumer<CreateManagedThingRequest.Builder> createManagedThingRequest) {
        return createManagedThing(CreateManagedThingRequest.builder().applyMutation(createManagedThingRequest).build());
    }

    /**
     * <p>
     * Creates a notification configuration. A configuration is a connection between an event type and a destination
     * that you have already created.
     * </p>
     *
     * @param createNotificationConfigurationRequest
     * @return A Java Future containing the result of the CreateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationConfigurationResponse> createNotificationConfiguration(
            CreateNotificationConfigurationRequest createNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a notification configuration. A configuration is a connection between an event type and a destination
     * that you have already created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationConfigurationResponse> createNotificationConfiguration(
            Consumer<CreateNotificationConfigurationRequest.Builder> createNotificationConfigurationRequest) {
        return createNotificationConfiguration(CreateNotificationConfigurationRequest.builder()
                .applyMutation(createNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Create an over-the-air (OTA) task to update a device.
     * </p>
     *
     * @param createOtaTaskRequest
     * @return A Java Future containing the result of the CreateOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOtaTaskResponse> createOtaTask(CreateOtaTaskRequest createOtaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an over-the-air (OTA) task to update a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOtaTaskRequest#builder()}
     * </p>
     *
     * @param createOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOtaTaskResponse> createOtaTask(Consumer<CreateOtaTaskRequest.Builder> createOtaTaskRequest) {
        return createOtaTask(CreateOtaTaskRequest.builder().applyMutation(createOtaTaskRequest).build());
    }

    /**
     * <p>
     * Create a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param createOtaTaskConfigurationRequest
     * @return A Java Future containing the result of the CreateOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOtaTaskConfigurationResponse> createOtaTaskConfiguration(
            CreateOtaTaskConfigurationRequest createOtaTaskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a configuraiton for the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param createOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOtaTaskConfigurationResponse> createOtaTaskConfiguration(
            Consumer<CreateOtaTaskConfigurationRequest.Builder> createOtaTaskConfigurationRequest) {
        return createOtaTaskConfiguration(CreateOtaTaskConfigurationRequest.builder()
                .applyMutation(createOtaTaskConfigurationRequest).build());
    }

    /**
     * <p>
     * Create a provisioning profile for a device to execute the provisioning flows using a provisioning template. The
     * provisioning template is a document that defines the set of resources and policies applied to a device during the
     * provisioning process.
     * </p>
     *
     * @param createProvisioningProfileRequest
     * @return A Java Future containing the result of the CreateProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisioningProfileResponse> createProvisioningProfile(
            CreateProvisioningProfileRequest createProvisioningProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a provisioning profile for a device to execute the provisioning flows using a provisioning template. The
     * provisioning template is a document that defines the set of resources and policies applied to a device during the
     * provisioning process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param createProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.CreateProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProvisioningProfileResponse> createProvisioningProfile(
            Consumer<CreateProvisioningProfileRequest.Builder> createProvisioningProfileRequest) {
        return createProvisioningProfile(CreateProvisioningProfileRequest.builder()
                .applyMutation(createProvisioningProfileRequest).build());
    }

    /**
     * <p>
     * Remove a third party account and related devices from an end user.
     * </p>
     *
     * @param deleteAccountAssociationRequest
     * @return A Java Future containing the result of the DeleteAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssociationResponse> deleteAccountAssociation(
            DeleteAccountAssociationRequest deleteAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a third party account and related devices from an end user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccountAssociationResponse> deleteAccountAssociation(
            Consumer<DeleteAccountAssociationRequest.Builder> deleteAccountAssociationRequest) {
        return deleteAccountAssociation(DeleteAccountAssociationRequest.builder().applyMutation(deleteAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Delete a cloud connector.
     * </p>
     *
     * @param deleteCloudConnectorRequest
     * @return A Java Future containing the result of the DeleteCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudConnectorResponse> deleteCloudConnector(
            DeleteCloudConnectorRequest deleteCloudConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a cloud connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCloudConnectorRequest#builder()}
     * </p>
     *
     * @param deleteCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudConnectorResponse> deleteCloudConnector(
            Consumer<DeleteCloudConnectorRequest.Builder> deleteCloudConnectorRequest) {
        return deleteCloudConnector(DeleteCloudConnectorRequest.builder().applyMutation(deleteCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Delete a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     *
     * @param deleteConnectorDestinationRequest
     * @return A Java Future containing the result of the DeleteConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorDestinationResponse> deleteConnectorDestination(
            DeleteConnectorDestinationRequest deleteConnectorDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorDestinationResponse> deleteConnectorDestination(
            Consumer<DeleteConnectorDestinationRequest.Builder> deleteConnectorDestinationRequest) {
        return deleteConnectorDestination(DeleteConnectorDestinationRequest.builder()
                .applyMutation(deleteConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Delete a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation can't be undone and any existing device won't be able to use IoT managed integrations.
     * </p>
     * </note>
     *
     * @param deleteCredentialLockerRequest
     * @return A Java Future containing the result of the DeleteCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCredentialLockerResponse> deleteCredentialLocker(
            DeleteCredentialLockerRequest deleteCredentialLockerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation can't be undone and any existing device won't be able to use IoT managed integrations.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCredentialLockerRequest#builder()}
     * </p>
     *
     * @param deleteCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCredentialLockerResponse> deleteCredentialLocker(
            Consumer<DeleteCredentialLockerRequest.Builder> deleteCredentialLockerRequest) {
        return deleteCredentialLocker(DeleteCredentialLockerRequest.builder().applyMutation(deleteCredentialLockerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a customer-managed destination specified by id.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a customer-managed destination specified by id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(
            Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest) {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Delete an event log configuration.
     * </p>
     *
     * @param deleteEventLogConfigurationRequest
     * @return A Java Future containing the result of the DeleteEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventLogConfigurationResponse> deleteEventLogConfiguration(
            DeleteEventLogConfigurationRequest deleteEventLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an event log configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventLogConfigurationResponse> deleteEventLogConfiguration(
            Consumer<DeleteEventLogConfigurationRequest.Builder> deleteEventLogConfigurationRequest) {
        return deleteEventLogConfiguration(DeleteEventLogConfigurationRequest.builder()
                .applyMutation(deleteEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete a managed thing. If a controller is deleted, all of the devices connected to it will have their status
     * changed to <code>PENDING</code>. It is not possible to remove a cloud device.
     * </p>
     *
     * @param deleteManagedThingRequest
     * @return A Java Future containing the result of the DeleteManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteManagedThingResponse> deleteManagedThing(DeleteManagedThingRequest deleteManagedThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a managed thing. If a controller is deleted, all of the devices connected to it will have their status
     * changed to <code>PENDING</code>. It is not possible to remove a cloud device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteManagedThingRequest#builder()}
     * </p>
     *
     * @param deleteManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteManagedThingResponse> deleteManagedThing(
            Consumer<DeleteManagedThingRequest.Builder> deleteManagedThingRequest) {
        return deleteManagedThing(DeleteManagedThingRequest.builder().applyMutation(deleteManagedThingRequest).build());
    }

    /**
     * <p>
     * Deletes a notification configuration.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest) {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task.
     * </p>
     *
     * @param deleteOtaTaskRequest
     * @return A Java Future containing the result of the DeleteOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException The request exceeds a service limit or quota. Adjust your request parameters
     *         and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOtaTaskResponse> deleteOtaTask(DeleteOtaTaskRequest deleteOtaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOtaTaskRequest#builder()}
     * </p>
     *
     * @param deleteOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException The request exceeds a service limit or quota. Adjust your request parameters
     *         and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOtaTaskResponse> deleteOtaTask(Consumer<DeleteOtaTaskRequest.Builder> deleteOtaTaskRequest) {
        return deleteOtaTask(DeleteOtaTaskRequest.builder().applyMutation(deleteOtaTaskRequest).build());
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task configuration.
     * </p>
     *
     * @param deleteOtaTaskConfigurationRequest
     * @return A Java Future containing the result of the DeleteOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOtaTaskConfigurationResponse> deleteOtaTaskConfiguration(
            DeleteOtaTaskConfigurationRequest deleteOtaTaskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOtaTaskConfigurationResponse> deleteOtaTaskConfiguration(
            Consumer<DeleteOtaTaskConfigurationRequest.Builder> deleteOtaTaskConfigurationRequest) {
        return deleteOtaTaskConfiguration(DeleteOtaTaskConfigurationRequest.builder()
                .applyMutation(deleteOtaTaskConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete a provisioning profile.
     * </p>
     *
     * @param deleteProvisioningProfileRequest
     * @return A Java Future containing the result of the DeleteProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisioningProfileResponse> deleteProvisioningProfile(
            DeleteProvisioningProfileRequest deleteProvisioningProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a provisioning profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeleteProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisioningProfileResponse> deleteProvisioningProfile(
            Consumer<DeleteProvisioningProfileRequest.Builder> deleteProvisioningProfileRequest) {
        return deleteProvisioningProfile(DeleteProvisioningProfileRequest.builder()
                .applyMutation(deleteProvisioningProfileRequest).build());
    }

    /**
     * <p>
     * Deregisters an account association, removing the connection between a managed thing and a third-party account.
     * </p>
     *
     * @param deregisterAccountAssociationRequest
     *        Request for deregister a managed thing from account association
     * @return A Java Future containing the result of the DeregisterAccountAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeregisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeregisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterAccountAssociationResponse> deregisterAccountAssociation(
            DeregisterAccountAssociationRequest deregisterAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an account association, removing the connection between a managed thing and a third-party account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterAccountAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterAccountAssociationRequest#builder()}
     * </p>
     *
     * @param deregisterAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationRequest.Builder}
     *        to create a request. Request for deregister a managed thing from account association
     * @return A Java Future containing the result of the DeregisterAccountAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.DeregisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeregisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterAccountAssociationResponse> deregisterAccountAssociation(
            Consumer<DeregisterAccountAssociationRequest.Builder> deregisterAccountAssociationRequest) {
        return deregisterAccountAssociation(DeregisterAccountAssociationRequest.builder()
                .applyMutation(deregisterAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Get an account association for an Amazon Web Services account linked to a customer-managed destination.
     * </p>
     *
     * @param getAccountAssociationRequest
     * @return A Java Future containing the result of the GetAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetAccountAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountAssociationResponse> getAccountAssociation(
            GetAccountAssociationRequest getAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an account association for an Amazon Web Services account linked to a customer-managed destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountAssociationRequest#builder()}
     * </p>
     *
     * @param getAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetAccountAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountAssociationResponse> getAccountAssociation(
            Consumer<GetAccountAssociationRequest.Builder> getAccountAssociationRequest) {
        return getAccountAssociation(GetAccountAssociationRequest.builder().applyMutation(getAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Gets all the information about a connector for a connector developer.
     * </p>
     *
     * @param getCloudConnectorRequest
     * @return A Java Future containing the result of the GetCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudConnectorResponse> getCloudConnector(GetCloudConnectorRequest getCloudConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the information about a connector for a connector developer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link GetCloudConnectorRequest#builder()}
     * </p>
     *
     * @param getCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudConnectorResponse> getCloudConnector(
            Consumer<GetCloudConnectorRequest.Builder> getCloudConnectorRequest) {
        return getCloudConnector(GetCloudConnectorRequest.builder().applyMutation(getCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Get a connector destination of a cloud-to-cloud (C2C) connector connecting to a customer's Amazon Web Services
     * account.
     * </p>
     *
     * @param getConnectorDestinationRequest
     * @return A Java Future containing the result of the GetConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDestinationResponse> getConnectorDestination(
            GetConnectorDestinationRequest getConnectorDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a connector destination of a cloud-to-cloud (C2C) connector connecting to a customer's Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param getConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectorDestinationResponse> getConnectorDestination(
            Consumer<GetConnectorDestinationRequest.Builder> getConnectorDestinationRequest) {
        return getConnectorDestination(GetConnectorDestinationRequest.builder().applyMutation(getConnectorDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Get information on an existing credential locker
     * </p>
     *
     * @param getCredentialLockerRequest
     * @return A Java Future containing the result of the GetCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialLockerResponse> getCredentialLocker(
            GetCredentialLockerRequest getCredentialLockerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information on an existing credential locker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link GetCredentialLockerRequest#builder()}
     * </p>
     *
     * @param getCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCredentialLocker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialLockerResponse> getCredentialLocker(
            Consumer<GetCredentialLockerRequest.Builder> getCredentialLockerRequest) {
        return getCredentialLocker(GetCredentialLockerRequest.builder().applyMutation(getCredentialLockerRequest).build());
    }

    /**
     * <p>
     * Returns the IoT managed integrations custom endpoint.
     * </p>
     *
     * @param getCustomEndpointRequest
     * @return A Java Future containing the result of the GetCustomEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomEndpointResponse> getCustomEndpoint(GetCustomEndpointRequest getCustomEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the IoT managed integrations custom endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link GetCustomEndpointRequest#builder()}
     * </p>
     *
     * @param getCustomEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCustomEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomEndpointResponse> getCustomEndpoint(
            Consumer<GetCustomEndpointRequest.Builder> getCustomEndpointRequest) {
        return getCustomEndpoint(GetCustomEndpointRequest.builder().applyMutation(getCustomEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param getDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the GetDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultEncryptionConfigurationResponse> getDefaultEncryptionConfiguration(
            GetDefaultEncryptionConfigurationRequest getDefaultEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param getDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultEncryptionConfigurationResponse> getDefaultEncryptionConfiguration(
            Consumer<GetDefaultEncryptionConfigurationRequest.Builder> getDefaultEncryptionConfigurationRequest) {
        return getDefaultEncryptionConfiguration(GetDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(getDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a destination by ID.
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a destination by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest) {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Get the current state of a device discovery.
     * </p>
     *
     * @param getDeviceDiscoveryRequest
     * @return A Java Future containing the result of the GetDeviceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceDiscoveryResponse> getDeviceDiscovery(GetDeviceDiscoveryRequest getDeviceDiscoveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the current state of a device discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDiscoveryRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceDiscoveryRequest#builder()}
     * </p>
     *
     * @param getDeviceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDeviceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceDiscoveryResponse> getDeviceDiscovery(
            Consumer<GetDeviceDiscoveryRequest.Builder> getDeviceDiscoveryRequest) {
        return getDeviceDiscovery(GetDeviceDiscoveryRequest.builder().applyMutation(getDeviceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Get an event log configuration.
     * </p>
     *
     * @param getEventLogConfigurationRequest
     * @return A Java Future containing the result of the GetEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventLogConfigurationResponse> getEventLogConfiguration(
            GetEventLogConfigurationRequest getEventLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an event log configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param getEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventLogConfigurationResponse> getEventLogConfiguration(
            Consumer<GetEventLogConfigurationRequest.Builder> getEventLogConfigurationRequest) {
        return getEventLogConfiguration(GetEventLogConfigurationRequest.builder().applyMutation(getEventLogConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get a hub configuration.
     * </p>
     *
     * @param getHubConfigurationRequest
     * @return A Java Future containing the result of the GetHubConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHubConfigurationResponse> getHubConfiguration(
            GetHubConfigurationRequest getHubConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a hub configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHubConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetHubConfigurationRequest#builder()}
     * </p>
     *
     * @param getHubConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetHubConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHubConfigurationResponse> getHubConfiguration(
            Consumer<GetHubConfigurationRequest.Builder> getHubConfigurationRequest) {
        return getHubConfiguration(GetHubConfigurationRequest.builder().applyMutation(getHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Get the attributes and capabilities associated with a managed thing.
     * </p>
     *
     * @param getManagedThingRequest
     * @return A Java Future containing the result of the GetManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingResponse> getManagedThing(GetManagedThingRequest getManagedThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the attributes and capabilities associated with a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingRequest.Builder} avoiding the need
     * to create one manually via {@link GetManagedThingRequest#builder()}
     * </p>
     *
     * @param getManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingResponse> getManagedThing(
            Consumer<GetManagedThingRequest.Builder> getManagedThingRequest) {
        return getManagedThing(GetManagedThingRequest.builder().applyMutation(getManagedThingRequest).build());
    }

    /**
     * <p>
     * Get the capabilities for a managed thing using the device ID.
     * </p>
     *
     * @param getManagedThingCapabilitiesRequest
     * @return A Java Future containing the result of the GetManagedThingCapabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingCapabilities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCapabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingCapabilitiesResponse> getManagedThingCapabilities(
            GetManagedThingCapabilitiesRequest getManagedThingCapabilitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the capabilities for a managed thing using the device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingCapabilitiesRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedThingCapabilitiesRequest#builder()}
     * </p>
     *
     * @param getManagedThingCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedThingCapabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingCapabilities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCapabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingCapabilitiesResponse> getManagedThingCapabilities(
            Consumer<GetManagedThingCapabilitiesRequest.Builder> getManagedThingCapabilitiesRequest) {
        return getManagedThingCapabilities(GetManagedThingCapabilitiesRequest.builder()
                .applyMutation(getManagedThingCapabilitiesRequest).build());
    }

    /**
     * <p>
     * Get the connectivity status of a managed thing.
     * </p>
     *
     * @param getManagedThingConnectivityDataRequest
     * @return A Java Future containing the result of the GetManagedThingConnectivityData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingConnectivityData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingConnectivityData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingConnectivityDataResponse> getManagedThingConnectivityData(
            GetManagedThingConnectivityDataRequest getManagedThingConnectivityDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the connectivity status of a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingConnectivityDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedThingConnectivityDataRequest#builder()}
     * </p>
     *
     * @param getManagedThingConnectivityDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedThingConnectivityData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingConnectivityData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingConnectivityData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingConnectivityDataResponse> getManagedThingConnectivityData(
            Consumer<GetManagedThingConnectivityDataRequest.Builder> getManagedThingConnectivityDataRequest) {
        return getManagedThingConnectivityData(GetManagedThingConnectivityDataRequest.builder()
                .applyMutation(getManagedThingConnectivityDataRequest).build());
    }

    /**
     * <p>
     * Get the metadata information for a managed thing.
     * </p>
     * <note>
     * <p>
     * The <code>managedThing</code> <code>metadata</code> parameter is used for associating attributes with a
     * <code>managedThing</code> that can be used for grouping over-the-air (OTA) tasks. Name value pairs in
     * <code>metadata</code> can be used in the <code>OtaTargetQueryString</code> parameter for the
     * <code>CreateOtaTask</code> API operation.
     * </p>
     * </note>
     *
     * @param getManagedThingMetaDataRequest
     * @return A Java Future containing the result of the GetManagedThingMetaData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingMetaData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingMetaData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingMetaDataResponse> getManagedThingMetaData(
            GetManagedThingMetaDataRequest getManagedThingMetaDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the metadata information for a managed thing.
     * </p>
     * <note>
     * <p>
     * The <code>managedThing</code> <code>metadata</code> parameter is used for associating attributes with a
     * <code>managedThing</code> that can be used for grouping over-the-air (OTA) tasks. Name value pairs in
     * <code>metadata</code> can be used in the <code>OtaTargetQueryString</code> parameter for the
     * <code>CreateOtaTask</code> API operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingMetaDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetManagedThingMetaDataRequest#builder()}
     * </p>
     *
     * @param getManagedThingMetaDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedThingMetaData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingMetaData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingMetaData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingMetaDataResponse> getManagedThingMetaData(
            Consumer<GetManagedThingMetaDataRequest.Builder> getManagedThingMetaDataRequest) {
        return getManagedThingMetaData(GetManagedThingMetaDataRequest.builder().applyMutation(getManagedThingMetaDataRequest)
                .build());
    }

    /**
     * <p>
     * Returns the managed thing state for the given device Id.
     * </p>
     *
     * @param getManagedThingStateRequest
     * @return A Java Future containing the result of the GetManagedThingState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingStateResponse> getManagedThingState(
            GetManagedThingStateRequest getManagedThingStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the managed thing state for the given device Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetManagedThingStateRequest#builder()}
     * </p>
     *
     * @param getManagedThingStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedThingState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetManagedThingState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedThingStateResponse> getManagedThingState(
            Consumer<GetManagedThingStateRequest.Builder> getManagedThingStateRequest) {
        return getManagedThingState(GetManagedThingStateRequest.builder().applyMutation(getManagedThingStateRequest).build());
    }

    /**
     * <p>
     * Get a notification configuration.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     * @return A Java Future containing the result of the GetNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationConfigurationResponse> getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationConfigurationResponse> getNotificationConfiguration(
            Consumer<GetNotificationConfigurationRequest.Builder> getNotificationConfigurationRequest) {
        return getNotificationConfiguration(GetNotificationConfigurationRequest.builder()
                .applyMutation(getNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Get the over-the-air (OTA) task.
     * </p>
     *
     * @param getOtaTaskRequest
     * @return A Java Future containing the result of the GetOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOtaTaskResponse> getOtaTask(GetOtaTaskRequest getOtaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetOtaTaskRequest#builder()}
     * </p>
     *
     * @param getOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOtaTaskResponse> getOtaTask(Consumer<GetOtaTaskRequest.Builder> getOtaTaskRequest) {
        return getOtaTask(GetOtaTaskRequest.builder().applyMutation(getOtaTaskRequest).build());
    }

    /**
     * <p>
     * Get a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param getOtaTaskConfigurationRequest
     * @return A Java Future containing the result of the GetOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOtaTaskConfigurationResponse> getOtaTaskConfiguration(
            GetOtaTaskConfigurationRequest getOtaTaskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a configuraiton for the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param getOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetOtaTaskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOtaTaskConfigurationResponse> getOtaTaskConfiguration(
            Consumer<GetOtaTaskConfigurationRequest.Builder> getOtaTaskConfigurationRequest) {
        return getOtaTaskConfiguration(GetOtaTaskConfigurationRequest.builder().applyMutation(getOtaTaskConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get a provisioning profile by template name.
     * </p>
     *
     * @param getProvisioningProfileRequest
     * @return A Java Future containing the result of the GetProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetProvisioningProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisioningProfileResponse> getProvisioningProfile(
            GetProvisioningProfileRequest getProvisioningProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a provisioning profile by template name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisioningProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param getProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetProvisioningProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetProvisioningProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisioningProfileResponse> getProvisioningProfile(
            Consumer<GetProvisioningProfileRequest.Builder> getProvisioningProfileRequest) {
        return getProvisioningProfile(GetProvisioningProfileRequest.builder().applyMutation(getProvisioningProfileRequest)
                .build());
    }

    /**
     * <p>
     * Get the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param getRuntimeLogConfigurationRequest
     * @return A Java Future containing the result of the GetRuntimeLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRuntimeLogConfigurationResponse> getRuntimeLogConfiguration(
            GetRuntimeLogConfigurationRequest getRuntimeLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuntimeLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param getRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetRuntimeLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRuntimeLogConfigurationResponse> getRuntimeLogConfiguration(
            Consumer<GetRuntimeLogConfigurationRequest.Builder> getRuntimeLogConfigurationRequest) {
        return getRuntimeLogConfiguration(GetRuntimeLogConfigurationRequest.builder()
                .applyMutation(getRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a schema version with the provided information.
     * </p>
     *
     * @param getSchemaVersionRequest
     * @return A Java Future containing the result of the GetSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionResponse> getSchemaVersion(GetSchemaVersionRequest getSchemaVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a schema version with the provided information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaVersionRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionResponse> getSchemaVersion(
            Consumer<GetSchemaVersionRequest.Builder> getSchemaVersionRequest) {
        return getSchemaVersion(GetSchemaVersionRequest.builder().applyMutation(getSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Lists all account associations, with optional filtering by connector destination ID.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A Java Future containing the result of the ListAccountAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssociationsResponse> listAccountAssociations(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account associations, with optional filtering by connector destination ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAccountAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccountAssociationsResponse> listAccountAssociations(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) {
        return listAccountAssociations(ListAccountAssociationsRequest.builder().applyMutation(listAccountAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsPublisher listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) {
        return new ListAccountAssociationsPublisher(this, listAccountAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsPublisher publisher = client.listAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsPublisher listAccountAssociationsPaginator(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) {
        return listAccountAssociationsPaginator(ListAccountAssociationsRequest.builder()
                .applyMutation(listAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of connectors based on permissions.
     * </p>
     *
     * @param listCloudConnectorsRequest
     * @return A Java Future containing the result of the ListCloudConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudConnectorsResponse> listCloudConnectors(
            ListCloudConnectorsRequest listCloudConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of connectors based on permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudConnectorsRequest#builder()}
     * </p>
     *
     * @param listCloudConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCloudConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudConnectorsResponse> listCloudConnectors(
            Consumer<ListCloudConnectorsRequest.Builder> listCloudConnectorsRequest) {
        return listCloudConnectors(ListCloudConnectorsRequest.builder().applyMutation(listCloudConnectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsPublisher publisher = client.listCloudConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsPublisher publisher = client.listCloudConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsPublisher listCloudConnectorsPaginator(ListCloudConnectorsRequest listCloudConnectorsRequest) {
        return new ListCloudConnectorsPublisher(this, listCloudConnectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsPublisher publisher = client.listCloudConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsPublisher publisher = client.listCloudConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudConnectorsRequest#builder()}
     * </p>
     *
     * @param listCloudConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsPublisher listCloudConnectorsPaginator(
            Consumer<ListCloudConnectorsRequest.Builder> listCloudConnectorsRequest) {
        return listCloudConnectorsPaginator(ListCloudConnectorsRequest.builder().applyMutation(listCloudConnectorsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all connector destinations, with optional filtering by cloud connector ID.
     * </p>
     *
     * @param listConnectorDestinationsRequest
     * @return A Java Future containing the result of the ListConnectorDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDestinationsResponse> listConnectorDestinations(
            ListConnectorDestinationsRequest listConnectorDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all connector destinations, with optional filtering by cloud connector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDestinationsRequest#builder()}
     * </p>
     *
     * @param listConnectorDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListConnectorDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConnectorDestinationsResponse> listConnectorDestinations(
            Consumer<ListConnectorDestinationsRequest.Builder> listConnectorDestinationsRequest) {
        return listConnectorDestinations(ListConnectorDestinationsRequest.builder()
                .applyMutation(listConnectorDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsPublisher publisher = client.listConnectorDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsPublisher publisher = client.listConnectorDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectorDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsPublisher listConnectorDestinationsPaginator(
            ListConnectorDestinationsRequest listConnectorDestinationsRequest) {
        return new ListConnectorDestinationsPublisher(this, listConnectorDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsPublisher publisher = client.listConnectorDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsPublisher publisher = client.listConnectorDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDestinationsRequest#builder()}
     * </p>
     *
     * @param listConnectorDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsPublisher listConnectorDestinationsPaginator(
            Consumer<ListConnectorDestinationsRequest.Builder> listConnectorDestinationsRequest) {
        return listConnectorDestinationsPaginator(ListConnectorDestinationsRequest.builder()
                .applyMutation(listConnectorDestinationsRequest).build());
    }

    /**
     * <p>
     * List information on an existing credential locker.
     * </p>
     *
     * @param listCredentialLockersRequest
     * @return A Java Future containing the result of the ListCredentialLockers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCredentialLockersResponse> listCredentialLockers(
            ListCredentialLockersRequest listCredentialLockersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List information on an existing credential locker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCredentialLockersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCredentialLockersRequest#builder()}
     * </p>
     *
     * @param listCredentialLockersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCredentialLockers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCredentialLockersResponse> listCredentialLockers(
            Consumer<ListCredentialLockersRequest.Builder> listCredentialLockersRequest) {
        return listCredentialLockers(ListCredentialLockersRequest.builder().applyMutation(listCredentialLockersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersPublisher publisher = client.listCredentialLockersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersPublisher publisher = client.listCredentialLockersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCredentialLockersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersPublisher listCredentialLockersPaginator(
            ListCredentialLockersRequest listCredentialLockersRequest) {
        return new ListCredentialLockersPublisher(this, listCredentialLockersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersPublisher publisher = client.listCredentialLockersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersPublisher publisher = client.listCredentialLockersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCredentialLockersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCredentialLockersRequest#builder()}
     * </p>
     *
     * @param listCredentialLockersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersPublisher listCredentialLockersPaginator(
            Consumer<ListCredentialLockersRequest.Builder> listCredentialLockersRequest) {
        return listCredentialLockersPaginator(ListCredentialLockersRequest.builder().applyMutation(listCredentialLockersRequest)
                .build());
    }

    /**
     * <p>
     * List all destination names under one Amazon Web Services account.
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all destination names under one Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(
            Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest) {
        return new ListDestinationsPublisher(this, listDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists all device discovery tasks, with optional filtering by type and status.
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     * @return A Java Future containing the result of the ListDeviceDiscoveries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDiscoveriesResponse> listDeviceDiscoveries(
            ListDeviceDiscoveriesRequest listDeviceDiscoveriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all device discovery tasks, with optional filtering by type and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDiscoveriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDiscoveriesRequest#builder()}
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDeviceDiscoveries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceDiscoveriesResponse> listDeviceDiscoveries(
            Consumer<ListDeviceDiscoveriesRequest.Builder> listDeviceDiscoveriesRequest) {
        return listDeviceDiscoveries(ListDeviceDiscoveriesRequest.builder().applyMutation(listDeviceDiscoveriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesPublisher publisher = client.listDeviceDiscoveriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesPublisher publisher = client.listDeviceDiscoveriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesPublisher listDeviceDiscoveriesPaginator(
            ListDeviceDiscoveriesRequest listDeviceDiscoveriesRequest) {
        return new ListDeviceDiscoveriesPublisher(this, listDeviceDiscoveriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesPublisher publisher = client.listDeviceDiscoveriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesPublisher publisher = client.listDeviceDiscoveriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDiscoveriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDiscoveriesRequest#builder()}
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesPublisher listDeviceDiscoveriesPaginator(
            Consumer<ListDeviceDiscoveriesRequest.Builder> listDeviceDiscoveriesRequest) {
        return listDeviceDiscoveriesPaginator(ListDeviceDiscoveriesRequest.builder().applyMutation(listDeviceDiscoveriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all devices discovered during a specific device discovery task.
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     * @return A Java Future containing the result of the ListDiscoveredDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDiscoveredDevicesResponse> listDiscoveredDevices(
            ListDiscoveredDevicesRequest listDiscoveredDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all devices discovered during a specific device discovery task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDiscoveredDevicesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDiscoveredDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDiscoveredDevicesResponse> listDiscoveredDevices(
            Consumer<ListDiscoveredDevicesRequest.Builder> listDiscoveredDevicesRequest) {
        return listDiscoveredDevices(ListDiscoveredDevicesRequest.builder().applyMutation(listDiscoveredDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesPublisher publisher = client.listDiscoveredDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesPublisher publisher = client.listDiscoveredDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesPublisher listDiscoveredDevicesPaginator(
            ListDiscoveredDevicesRequest listDiscoveredDevicesRequest) {
        return new ListDiscoveredDevicesPublisher(this, listDiscoveredDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesPublisher publisher = client.listDiscoveredDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesPublisher publisher = client.listDiscoveredDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDiscoveredDevicesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesPublisher listDiscoveredDevicesPaginator(
            Consumer<ListDiscoveredDevicesRequest.Builder> listDiscoveredDevicesRequest) {
        return listDiscoveredDevicesPaginator(ListDiscoveredDevicesRequest.builder().applyMutation(listDiscoveredDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List all event log configurations for an account.
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     * @return A Java Future containing the result of the ListEventLogConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventLogConfigurationsResponse> listEventLogConfigurations(
            ListEventLogConfigurationsRequest listEventLogConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all event log configurations for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventLogConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventLogConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListEventLogConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventLogConfigurationsResponse> listEventLogConfigurations(
            Consumer<ListEventLogConfigurationsRequest.Builder> listEventLogConfigurationsRequest) {
        return listEventLogConfigurations(ListEventLogConfigurationsRequest.builder()
                .applyMutation(listEventLogConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsPublisher publisher = client.listEventLogConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsPublisher publisher = client.listEventLogConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsPublisher listEventLogConfigurationsPaginator(
            ListEventLogConfigurationsRequest listEventLogConfigurationsRequest) {
        return new ListEventLogConfigurationsPublisher(this, listEventLogConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsPublisher publisher = client.listEventLogConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsPublisher publisher = client.listEventLogConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventLogConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventLogConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsPublisher listEventLogConfigurationsPaginator(
            Consumer<ListEventLogConfigurationsRequest.Builder> listEventLogConfigurationsRequest) {
        return listEventLogConfigurationsPaginator(ListEventLogConfigurationsRequest.builder()
                .applyMutation(listEventLogConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all account associations for a specific managed thing.
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     * @return A Java Future containing the result of the ListManagedThingAccountAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingAccountAssociationsResponse> listManagedThingAccountAssociations(
            ListManagedThingAccountAssociationsRequest listManagedThingAccountAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account associations for a specific managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingAccountAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedThingAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedThingAccountAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingAccountAssociationsResponse> listManagedThingAccountAssociations(
            Consumer<ListManagedThingAccountAssociationsRequest.Builder> listManagedThingAccountAssociationsRequest) {
        return listManagedThingAccountAssociations(ListManagedThingAccountAssociationsRequest.builder()
                .applyMutation(listManagedThingAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsPublisher publisher = client.listManagedThingAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsPublisher publisher = client.listManagedThingAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsPublisher listManagedThingAccountAssociationsPaginator(
            ListManagedThingAccountAssociationsRequest listManagedThingAccountAssociationsRequest) {
        return new ListManagedThingAccountAssociationsPublisher(this, listManagedThingAccountAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsPublisher publisher = client.listManagedThingAccountAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsPublisher publisher = client.listManagedThingAccountAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingAccountAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedThingAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsPublisher listManagedThingAccountAssociationsPaginator(
            Consumer<ListManagedThingAccountAssociationsRequest.Builder> listManagedThingAccountAssociationsRequest) {
        return listManagedThingAccountAssociationsPaginator(ListManagedThingAccountAssociationsRequest.builder()
                .applyMutation(listManagedThingAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * List schemas associated with a managed thing.
     * </p>
     *
     * @param listManagedThingSchemasRequest
     * @return A Java Future containing the result of the ListManagedThingSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingSchemasResponse> listManagedThingSchemas(
            ListManagedThingSchemasRequest listManagedThingSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List schemas associated with a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingSchemasRequest.Builder} avoiding
     * the need to create one manually via {@link ListManagedThingSchemasRequest#builder()}
     * </p>
     *
     * @param listManagedThingSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedThingSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingSchemasResponse> listManagedThingSchemas(
            Consumer<ListManagedThingSchemasRequest.Builder> listManagedThingSchemasRequest) {
        return listManagedThingSchemas(ListManagedThingSchemasRequest.builder().applyMutation(listManagedThingSchemasRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasPublisher publisher = client.listManagedThingSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasPublisher publisher = client.listManagedThingSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasPublisher listManagedThingSchemasPaginator(
            ListManagedThingSchemasRequest listManagedThingSchemasRequest) {
        return new ListManagedThingSchemasPublisher(this, listManagedThingSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasPublisher publisher = client.listManagedThingSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasPublisher publisher = client.listManagedThingSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingSchemasRequest.Builder} avoiding
     * the need to create one manually via {@link ListManagedThingSchemasRequest#builder()}
     * </p>
     *
     * @param listManagedThingSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasPublisher listManagedThingSchemasPaginator(
            Consumer<ListManagedThingSchemasRequest.Builder> listManagedThingSchemasRequest) {
        return listManagedThingSchemasPaginator(ListManagedThingSchemasRequest.builder()
                .applyMutation(listManagedThingSchemasRequest).build());
    }

    /**
     * <p>
     * Listing all managed things with provision for filters.
     * </p>
     *
     * @param listManagedThingsRequest
     * @return A Java Future containing the result of the ListManagedThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingsResponse> listManagedThings(ListManagedThingsRequest listManagedThingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Listing all managed things with provision for filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedThingsRequest#builder()}
     * </p>
     *
     * @param listManagedThingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListManagedThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedThingsResponse> listManagedThings(
            Consumer<ListManagedThingsRequest.Builder> listManagedThingsRequest) {
        return listManagedThings(ListManagedThingsRequest.builder().applyMutation(listManagedThingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsPublisher publisher = client.listManagedThingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsPublisher publisher = client.listManagedThingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsPublisher listManagedThingsPaginator(ListManagedThingsRequest listManagedThingsRequest) {
        return new ListManagedThingsPublisher(this, listManagedThingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsPublisher publisher = client.listManagedThingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsPublisher publisher = client.listManagedThingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedThingsRequest#builder()}
     * </p>
     *
     * @param listManagedThingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsPublisher listManagedThingsPaginator(
            Consumer<ListManagedThingsRequest.Builder> listManagedThingsRequest) {
        return listManagedThingsPaginator(ListManagedThingsRequest.builder().applyMutation(listManagedThingsRequest).build());
    }

    /**
     * <p>
     * List all notification configurations.
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A Java Future containing the result of the ListNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationConfigurationsResponse> listNotificationConfigurations(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all notification configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationConfigurationsResponse> listNotificationConfigurations(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest) {
        return listNotificationConfigurations(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsPublisher listNotificationConfigurationsPaginator(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) {
        return new ListNotificationConfigurationsPublisher(this, listNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsPublisher listNotificationConfigurationsPaginator(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest) {
        return listNotificationConfigurationsPaginator(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task configurations.
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     * @return A Java Future containing the result of the ListOtaTaskConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTaskConfigurationsResponse> listOtaTaskConfigurations(
            ListOtaTaskConfigurationsRequest listOtaTaskConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOtaTaskConfigurationsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOtaTaskConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTaskConfigurationsResponse> listOtaTaskConfigurations(
            Consumer<ListOtaTaskConfigurationsRequest.Builder> listOtaTaskConfigurationsRequest) {
        return listOtaTaskConfigurations(ListOtaTaskConfigurationsRequest.builder()
                .applyMutation(listOtaTaskConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsPublisher publisher = client.listOtaTaskConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsPublisher publisher = client.listOtaTaskConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsPublisher listOtaTaskConfigurationsPaginator(
            ListOtaTaskConfigurationsRequest listOtaTaskConfigurationsRequest) {
        return new ListOtaTaskConfigurationsPublisher(this, listOtaTaskConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsPublisher publisher = client.listOtaTaskConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsPublisher publisher = client.listOtaTaskConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOtaTaskConfigurationsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsPublisher listOtaTaskConfigurationsPaginator(
            Consumer<ListOtaTaskConfigurationsRequest.Builder> listOtaTaskConfigurationsRequest) {
        return listOtaTaskConfigurationsPaginator(ListOtaTaskConfigurationsRequest.builder()
                .applyMutation(listOtaTaskConfigurationsRequest).build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task executions.
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     * @return A Java Future containing the result of the ListOtaTaskExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTaskExecutionsResponse> listOtaTaskExecutions(
            ListOtaTaskExecutionsRequest listOtaTaskExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOtaTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOtaTaskExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTaskExecutionsResponse> listOtaTaskExecutions(
            Consumer<ListOtaTaskExecutionsRequest.Builder> listOtaTaskExecutionsRequest) {
        return listOtaTaskExecutions(ListOtaTaskExecutionsRequest.builder().applyMutation(listOtaTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsPublisher publisher = client.listOtaTaskExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsPublisher publisher = client.listOtaTaskExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsPublisher listOtaTaskExecutionsPaginator(
            ListOtaTaskExecutionsRequest listOtaTaskExecutionsRequest) {
        return new ListOtaTaskExecutionsPublisher(this, listOtaTaskExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsPublisher publisher = client.listOtaTaskExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsPublisher publisher = client.listOtaTaskExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOtaTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsPublisher listOtaTaskExecutionsPaginator(
            Consumer<ListOtaTaskExecutionsRequest.Builder> listOtaTaskExecutionsRequest) {
        return listOtaTaskExecutionsPaginator(ListOtaTaskExecutionsRequest.builder().applyMutation(listOtaTaskExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) tasks.
     * </p>
     *
     * @param listOtaTasksRequest
     * @return A Java Future containing the result of the ListOtaTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTasksResponse> listOtaTasks(ListOtaTasksRequest listOtaTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListOtaTasksRequest#builder()}
     * </p>
     *
     * @param listOtaTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListOtaTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOtaTasksResponse> listOtaTasks(Consumer<ListOtaTasksRequest.Builder> listOtaTasksRequest) {
        return listOtaTasks(ListOtaTasksRequest.builder().applyMutation(listOtaTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksPublisher publisher = client.listOtaTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksPublisher publisher = client.listOtaTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksPublisher listOtaTasksPaginator(ListOtaTasksRequest listOtaTasksRequest) {
        return new ListOtaTasksPublisher(this, listOtaTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksPublisher publisher = client.listOtaTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksPublisher publisher = client.listOtaTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListOtaTasksRequest#builder()}
     * </p>
     *
     * @param listOtaTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksPublisher listOtaTasksPaginator(Consumer<ListOtaTasksRequest.Builder> listOtaTasksRequest) {
        return listOtaTasksPaginator(ListOtaTasksRequest.builder().applyMutation(listOtaTasksRequest).build());
    }

    /**
     * <p>
     * List the provisioning profiles within the Amazon Web Services account.
     * </p>
     *
     * @param listProvisioningProfilesRequest
     * @return A Java Future containing the result of the ListProvisioningProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningProfilesResponse> listProvisioningProfiles(
            ListProvisioningProfilesRequest listProvisioningProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the provisioning profiles within the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningProfilesRequest#builder()}
     * </p>
     *
     * @param listProvisioningProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListProvisioningProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisioningProfilesResponse> listProvisioningProfiles(
            Consumer<ListProvisioningProfilesRequest.Builder> listProvisioningProfilesRequest) {
        return listProvisioningProfiles(ListProvisioningProfilesRequest.builder().applyMutation(listProvisioningProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesPublisher publisher = client.listProvisioningProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesPublisher publisher = client.listProvisioningProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesPublisher listProvisioningProfilesPaginator(
            ListProvisioningProfilesRequest listProvisioningProfilesRequest) {
        return new ListProvisioningProfilesPublisher(this, listProvisioningProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesPublisher publisher = client.listProvisioningProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesPublisher publisher = client.listProvisioningProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningProfilesRequest#builder()}
     * </p>
     *
     * @param listProvisioningProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesPublisher listProvisioningProfilesPaginator(
            Consumer<ListProvisioningProfilesRequest.Builder> listProvisioningProfilesRequest) {
        return listProvisioningProfilesPaginator(ListProvisioningProfilesRequest.builder()
                .applyMutation(listProvisioningProfilesRequest).build());
    }

    /**
     * <p>
     * Lists schema versions with the provided information.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A Java Future containing the result of the ListSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaVersionsResponse> listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists schema versions with the provided information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaVersionsResponse> listSchemaVersions(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) {
        return listSchemaVersions(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsPublisher listSchemaVersionsPaginator(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        return new ListSchemaVersionsPublisher(this, listSchemaVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsPublisher listSchemaVersionsPaginator(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) {
        return listSchemaVersionsPaginator(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * List tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * AWS IoT SiteWise User Guide.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return A Java Future containing the result of the PutDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDefaultEncryptionConfigurationResponse> putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * AWS IoT SiteWise User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutDefaultEncryptionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDefaultEncryptionConfigurationResponse> putDefaultEncryptionConfiguration(
            Consumer<PutDefaultEncryptionConfigurationRequest.Builder> putDefaultEncryptionConfigurationRequest) {
        return putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(putDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Update a hub configuration.
     * </p>
     *
     * @param putHubConfigurationRequest
     * @return A Java Future containing the result of the PutHubConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutHubConfigurationResponse> putHubConfiguration(
            PutHubConfigurationRequest putHubConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a hub configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutHubConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link PutHubConfigurationRequest#builder()}
     * </p>
     *
     * @param putHubConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutHubConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutHubConfigurationResponse> putHubConfiguration(
            Consumer<PutHubConfigurationRequest.Builder> putHubConfigurationRequest) {
        return putHubConfiguration(PutHubConfigurationRequest.builder().applyMutation(putHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Set the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param putRuntimeLogConfigurationRequest
     * @return A Java Future containing the result of the PutRuntimeLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRuntimeLogConfigurationResponse> putRuntimeLogConfiguration(
            PutRuntimeLogConfigurationRequest putRuntimeLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuntimeLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param putRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutRuntimeLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.PutRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRuntimeLogConfigurationResponse> putRuntimeLogConfiguration(
            Consumer<PutRuntimeLogConfigurationRequest.Builder> putRuntimeLogConfigurationRequest) {
        return putRuntimeLogConfiguration(PutRuntimeLogConfigurationRequest.builder()
                .applyMutation(putRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Registers an account association with a managed thing, establishing a connection between a device and a
     * third-party account.
     * </p>
     *
     * @param registerAccountAssociationRequest
     * @return A Java Future containing the result of the RegisterAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.RegisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterAccountAssociationResponse> registerAccountAssociation(
            RegisterAccountAssociationRequest registerAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an account association with a managed thing, establishing a connection between a device and a
     * third-party account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterAccountAssociationRequest#builder()}
     * </p>
     *
     * @param registerAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RegisterAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.RegisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterAccountAssociationResponse> registerAccountAssociation(
            Consumer<RegisterAccountAssociationRequest.Builder> registerAccountAssociationRequest) {
        return registerAccountAssociation(RegisterAccountAssociationRequest.builder()
                .applyMutation(registerAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Customers can request IoT managed integrations to manage the server trust for them or bring their own external
     * server trusts for the custom domain. Returns an IoT managed integrations endpoint.
     * </p>
     *
     * @param registerCustomEndpointRequest
     * @return A Java Future containing the result of the RegisterCustomEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.RegisterCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterCustomEndpointResponse> registerCustomEndpoint(
            RegisterCustomEndpointRequest registerCustomEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Customers can request IoT managed integrations to manage the server trust for them or bring their own external
     * server trusts for the custom domain. Returns an IoT managed integrations endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCustomEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterCustomEndpointRequest#builder()}
     * </p>
     *
     * @param registerCustomEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RegisterCustomEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.RegisterCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterCustomEndpointResponse> registerCustomEndpoint(
            Consumer<RegisterCustomEndpointRequest.Builder> registerCustomEndpointRequest) {
        return registerCustomEndpoint(RegisterCustomEndpointRequest.builder().applyMutation(registerCustomEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Reset a runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param resetRuntimeLogConfigurationRequest
     * @return A Java Future containing the result of the ResetRuntimeLogConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ResetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ResetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetRuntimeLogConfigurationResponse> resetRuntimeLogConfiguration(
            ResetRuntimeLogConfigurationRequest resetRuntimeLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reset a runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetRuntimeLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ResetRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param resetRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ResetRuntimeLogConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.ResetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ResetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResetRuntimeLogConfigurationResponse> resetRuntimeLogConfiguration(
            Consumer<ResetRuntimeLogConfigurationRequest.Builder> resetRuntimeLogConfigurationRequest) {
        return resetRuntimeLogConfiguration(ResetRuntimeLogConfigurationRequest.builder()
                .applyMutation(resetRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Relays third-party device events for a connector such as a new device or a device state change event.
     * </p>
     *
     * @param sendConnectorEventRequest
     * @return A Java Future containing the result of the SendConnectorEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.SendConnectorEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendConnectorEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendConnectorEventResponse> sendConnectorEvent(SendConnectorEventRequest sendConnectorEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Relays third-party device events for a connector such as a new device or a device state change event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendConnectorEventRequest.Builder} avoiding the
     * need to create one manually via {@link SendConnectorEventRequest#builder()}
     * </p>
     *
     * @param sendConnectorEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SendConnectorEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.SendConnectorEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendConnectorEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendConnectorEventResponse> sendConnectorEvent(
            Consumer<SendConnectorEventRequest.Builder> sendConnectorEventRequest) {
        return sendConnectorEvent(SendConnectorEventRequest.builder().applyMutation(sendConnectorEventRequest).build());
    }

    /**
     * <p>
     * Send the command to the device represented by the managed thing.
     * </p>
     *
     * @param sendManagedThingCommandRequest
     * @return A Java Future containing the result of the SendManagedThingCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.SendManagedThingCommand
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendManagedThingCommand"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendManagedThingCommandResponse> sendManagedThingCommand(
            SendManagedThingCommandRequest sendManagedThingCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send the command to the device represented by the managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendManagedThingCommandRequest.Builder} avoiding
     * the need to create one manually via {@link SendManagedThingCommandRequest#builder()}
     * </p>
     *
     * @param sendManagedThingCommandRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SendManagedThingCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.SendManagedThingCommand
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendManagedThingCommand"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendManagedThingCommandResponse> sendManagedThingCommand(
            Consumer<SendManagedThingCommandRequest.Builder> sendManagedThingCommandRequest) {
        return sendManagedThingCommand(SendManagedThingCommandRequest.builder().applyMutation(sendManagedThingCommandRequest)
                .build());
    }

    /**
     * <p>
     * Initiates a refresh of an existing account association to update its authorization and connection status.
     * </p>
     *
     * @param startAccountAssociationRefreshRequest
     * @return A Java Future containing the result of the StartAccountAssociationRefresh operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.StartAccountAssociationRefresh
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartAccountAssociationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAccountAssociationRefreshResponse> startAccountAssociationRefresh(
            StartAccountAssociationRefreshRequest startAccountAssociationRefreshRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a refresh of an existing account association to update its authorization and connection status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAccountAssociationRefreshRequest.Builder}
     * avoiding the need to create one manually via {@link StartAccountAssociationRefreshRequest#builder()}
     * </p>
     *
     * @param startAccountAssociationRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartAccountAssociationRefresh operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.StartAccountAssociationRefresh
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartAccountAssociationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAccountAssociationRefreshResponse> startAccountAssociationRefresh(
            Consumer<StartAccountAssociationRefreshRequest.Builder> startAccountAssociationRefreshRequest) {
        return startAccountAssociationRefresh(StartAccountAssociationRefreshRequest.builder()
                .applyMutation(startAccountAssociationRefreshRequest).build());
    }

    /**
     * <p>
     * This API is used to start device discovery for hub-connected and third-party-connected devices. The
     * authentication material (install code) is passed as a message to the controller telling it to start the
     * discovery.
     * </p>
     *
     * @param startDeviceDiscoveryRequest
     * @return A Java Future containing the result of the StartDeviceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.StartDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeviceDiscoveryResponse> startDeviceDiscovery(
            StartDeviceDiscoveryRequest startDeviceDiscoveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used to start device discovery for hub-connected and third-party-connected devices. The
     * authentication material (install code) is passed as a message to the controller telling it to start the
     * discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeviceDiscoveryRequest.Builder} avoiding the
     * need to create one manually via {@link StartDeviceDiscoveryRequest#builder()}
     * </p>
     *
     * @param startDeviceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartDeviceDiscovery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.StartDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeviceDiscoveryResponse> startDeviceDiscovery(
            Consumer<StartDeviceDiscoveryRequest.Builder> startDeviceDiscoveryRequest) {
        return startDeviceDiscovery(StartDeviceDiscoveryRequest.builder().applyMutation(startDeviceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Add tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags for the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an existing account association.
     * </p>
     *
     * @param updateAccountAssociationRequest
     * @return A Java Future containing the result of the UpdateAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountAssociationResponse> updateAccountAssociation(
            UpdateAccountAssociationRequest updateAccountAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an existing account association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountAssociationRequest#builder()}
     * </p>
     *
     * @param updateAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAccountAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountAssociationResponse> updateAccountAssociation(
            Consumer<UpdateAccountAssociationRequest.Builder> updateAccountAssociationRequest) {
        return updateAccountAssociation(UpdateAccountAssociationRequest.builder().applyMutation(updateAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Update an existing cloud connector.
     * </p>
     *
     * @param updateCloudConnectorRequest
     * @return A Java Future containing the result of the UpdateCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudConnectorResponse> updateCloudConnector(
            UpdateCloudConnectorRequest updateCloudConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing cloud connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCloudConnectorRequest#builder()}
     * </p>
     *
     * @param updateCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateCloudConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudConnectorResponse> updateCloudConnector(
            Consumer<UpdateCloudConnectorRequest.Builder> updateCloudConnectorRequest) {
        return updateCloudConnector(UpdateCloudConnectorRequest.builder().applyMutation(updateCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an existing connector destination.
     * </p>
     *
     * @param updateConnectorDestinationRequest
     * @return A Java Future containing the result of the UpdateConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorDestinationResponse> updateConnectorDestination(
            UpdateConnectorDestinationRequest updateConnectorDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an existing connector destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param updateConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateConnectorDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorDestinationResponse> updateConnectorDestination(
            Consumer<UpdateConnectorDestinationRequest.Builder> updateConnectorDestinationRequest) {
        return updateConnectorDestination(UpdateConnectorDestinationRequest.builder()
                .applyMutation(updateConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Update a destination specified by id.
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a destination specified by id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(
            Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Update an event log configuration by log configuration ID.
     * </p>
     *
     * @param updateEventLogConfigurationRequest
     * @return A Java Future containing the result of the UpdateEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventLogConfigurationResponse> updateEventLogConfiguration(
            UpdateEventLogConfigurationRequest updateEventLogConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an event log configuration by log configuration ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param updateEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateEventLogConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventLogConfigurationResponse> updateEventLogConfiguration(
            Consumer<UpdateEventLogConfigurationRequest.Builder> updateEventLogConfigurationRequest) {
        return updateEventLogConfiguration(UpdateEventLogConfigurationRequest.builder()
                .applyMutation(updateEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Update the attributes and capabilities associated with a managed thing.
     * </p>
     *
     * @param updateManagedThingRequest
     * @return A Java Future containing the result of the UpdateManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateManagedThingResponse> updateManagedThing(UpdateManagedThingRequest updateManagedThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes and capabilities associated with a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateManagedThingRequest#builder()}
     * </p>
     *
     * @param updateManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateManagedThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictException There is a conflict with the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateManagedThingResponse> updateManagedThing(
            Consumer<UpdateManagedThingRequest.Builder> updateManagedThingRequest) {
        return updateManagedThing(UpdateManagedThingRequest.builder().applyMutation(updateManagedThingRequest).build());
    }

    /**
     * <p>
     * Update a notification configuration.
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     * @return A Java Future containing the result of the UpdateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationConfigurationResponse> updateNotificationConfiguration(
            UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationConfigurationResponse> updateNotificationConfiguration(
            Consumer<UpdateNotificationConfigurationRequest.Builder> updateNotificationConfigurationRequest) {
        return updateNotificationConfiguration(UpdateNotificationConfigurationRequest.builder()
                .applyMutation(updateNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Update an over-the-air (OTA) task.
     * </p>
     *
     * @param updateOtaTaskRequest
     * @return A Java Future containing the result of the UpdateOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOtaTaskResponse> updateOtaTask(UpdateOtaTaskRequest updateOtaTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateOtaTaskRequest#builder()}
     * </p>
     *
     * @param updateOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateOtaTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User is not authorized.</li>
     *         <li>ValidationException A validation error occurred when performing the API request.</li>
     *         <li>InternalServerException Internal error from the service that indicates an unexpected error or that
     *         the service is unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotManagedIntegrationsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample IotManagedIntegrationsAsyncClient.UpdateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOtaTaskResponse> updateOtaTask(Consumer<UpdateOtaTaskRequest.Builder> updateOtaTaskRequest) {
        return updateOtaTask(UpdateOtaTaskRequest.builder().applyMutation(updateOtaTaskRequest).build());
    }

    @Override
    default IotManagedIntegrationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotManagedIntegrationsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotManagedIntegrationsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotManagedIntegrationsAsyncClient}.
     */
    static IotManagedIntegrationsAsyncClientBuilder builder() {
        return new DefaultIotManagedIntegrationsAsyncClientBuilder();
    }
}
