/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one abort config criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbortConfigCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<AbortConfigCriteria.Builder, AbortConfigCriteria> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(AbortConfigCriteria::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureType").getter(getter(AbortConfigCriteria::failureTypeAsString))
            .setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()).build();

    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MinNumberOfExecutedThings")
            .getter(getter(AbortConfigCriteria::minNumberOfExecutedThings)).setter(setter(Builder::minNumberOfExecutedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinNumberOfExecutedThings").build())
            .build();

    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThresholdPercentage").getter(getter(AbortConfigCriteria::thresholdPercentage))
            .setter(setter(Builder::thresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            FAILURE_TYPE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD, THRESHOLD_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String failureType;

    private final Integer minNumberOfExecutedThings;

    private final Double thresholdPercentage;

    private AbortConfigCriteria(BuilderImpl builder) {
        this.action = builder.action;
        this.failureType = builder.failureType;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
        this.thresholdPercentage = builder.thresholdPercentage;
    }

    /**
     * <p>
     * The action taken by the abort configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link AbortCriteriaAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken by the abort configuration.
     * @see AbortCriteriaAction
     */
    public final AbortCriteriaAction action() {
        return AbortCriteriaAction.fromValue(action);
    }

    /**
     * <p>
     * The action taken by the abort configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link AbortCriteriaAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken by the abort configuration.
     * @see AbortCriteriaAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Over-the-air (OTA) task abort criteria failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link AbortCriteriaFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return Over-the-air (OTA) task abort criteria failure type.
     * @see AbortCriteriaFailureType
     */
    public final AbortCriteriaFailureType failureType() {
        return AbortCriteriaFailureType.fromValue(failureType);
    }

    /**
     * <p>
     * Over-the-air (OTA) task abort criteria failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link AbortCriteriaFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return Over-the-air (OTA) task abort criteria failure type.
     * @see AbortCriteriaFailureType
     */
    public final String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The minimum number of things that must receive task execution notifications before the task can be aborted.
     * </p>
     * 
     * @return The minimum number of things that must receive task execution notifications before the task can be
     *         aborted.
     */
    public final Integer minNumberOfExecutedThings() {
        return minNumberOfExecutedThings;
    }

    /**
     * <p>
     * The minimum percentage of over-the-air (OTA) task execution failures that must occur to initiate the last abort.
     * </p>
     * 
     * @return The minimum percentage of over-the-air (OTA) task execution failures that must occur to initiate the last
     *         abort.
     */
    public final Double thresholdPercentage() {
        return thresholdPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minNumberOfExecutedThings());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortConfigCriteria)) {
            return false;
        }
        AbortConfigCriteria other = (AbortConfigCriteria) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(minNumberOfExecutedThings(), other.minNumberOfExecutedThings())
                && Objects.equals(thresholdPercentage(), other.thresholdPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbortConfigCriteria").add("Action", actionAsString()).add("FailureType", failureTypeAsString())
                .add("MinNumberOfExecutedThings", minNumberOfExecutedThings()).add("ThresholdPercentage", thresholdPercentage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "FailureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "MinNumberOfExecutedThings":
            return Optional.ofNullable(clazz.cast(minNumberOfExecutedThings()));
        case "ThresholdPercentage":
            return Optional.ofNullable(clazz.cast(thresholdPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("FailureType", FAILURE_TYPE_FIELD);
        map.put("MinNumberOfExecutedThings", MIN_NUMBER_OF_EXECUTED_THINGS_FIELD);
        map.put("ThresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbortConfigCriteria, T> g) {
        return obj -> g.apply((AbortConfigCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbortConfigCriteria> {
        /**
         * <p>
         * The action taken by the abort configuration.
         * </p>
         * 
         * @param action
         *        The action taken by the abort configuration.
         * @see AbortCriteriaAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortCriteriaAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action taken by the abort configuration.
         * </p>
         * 
         * @param action
         *        The action taken by the abort configuration.
         * @see AbortCriteriaAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortCriteriaAction
         */
        Builder action(AbortCriteriaAction action);

        /**
         * <p>
         * Over-the-air (OTA) task abort criteria failure type.
         * </p>
         * 
         * @param failureType
         *        Over-the-air (OTA) task abort criteria failure type.
         * @see AbortCriteriaFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortCriteriaFailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * Over-the-air (OTA) task abort criteria failure type.
         * </p>
         * 
         * @param failureType
         *        Over-the-air (OTA) task abort criteria failure type.
         * @see AbortCriteriaFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortCriteriaFailureType
         */
        Builder failureType(AbortCriteriaFailureType failureType);

        /**
         * <p>
         * The minimum number of things that must receive task execution notifications before the task can be aborted.
         * </p>
         * 
         * @param minNumberOfExecutedThings
         *        The minimum number of things that must receive task execution notifications before the task can be
         *        aborted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings);

        /**
         * <p>
         * The minimum percentage of over-the-air (OTA) task execution failures that must occur to initiate the last
         * abort.
         * </p>
         * 
         * @param thresholdPercentage
         *        The minimum percentage of over-the-air (OTA) task execution failures that must occur to initiate the
         *        last abort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercentage(Double thresholdPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String failureType;

        private Integer minNumberOfExecutedThings;

        private Double thresholdPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortConfigCriteria model) {
            action(model.action);
            failureType(model.failureType);
            minNumberOfExecutedThings(model.minNumberOfExecutedThings);
            thresholdPercentage(model.thresholdPercentage);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(AbortCriteriaAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getFailureType() {
            return failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(AbortCriteriaFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return minNumberOfExecutedThings;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        @Override
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        public final Double getThresholdPercentage() {
            return thresholdPercentage;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        @Override
        public AbortConfigCriteria build() {
            return new AbortConfigCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
