/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AbortConfigCriteriaListCopier {
    static List<AbortConfigCriteria> copy(Collection<? extends AbortConfigCriteria> abortConfigCriteriaListParam) {
        List<AbortConfigCriteria> list;
        if (abortConfigCriteriaListParam == null || abortConfigCriteriaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AbortConfigCriteria> modifiableList = new ArrayList<>(abortConfigCriteriaListParam.size());
            abortConfigCriteriaListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AbortConfigCriteria> copyFromBuilder(
            Collection<? extends AbortConfigCriteria.Builder> abortConfigCriteriaListParam) {
        List<AbortConfigCriteria> list;
        if (abortConfigCriteriaListParam == null || abortConfigCriteriaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AbortConfigCriteria> modifiableList = new ArrayList<>(abortConfigCriteriaListParam.size());
            abortConfigCriteriaListParam.forEach(entry -> {
                AbortConfigCriteria member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AbortConfigCriteria.Builder> copyToBuilder(Collection<? extends AbortConfigCriteria> abortConfigCriteriaListParam) {
        List<AbortConfigCriteria.Builder> list;
        if (abortConfigCriteriaListParam == null || abortConfigCriteriaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AbortConfigCriteria.Builder> modifiableList = new ArrayList<>(abortConfigCriteriaListParam.size());
            abortConfigCriteriaListParam.forEach(entry -> {
                AbortConfigCriteria.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
