/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updated authentication configuration details for a connector destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthConfigUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthConfigUpdate.Builder, AuthConfigUpdate> {
    private static final SdkField<OAuthUpdate> O_AUTH_UPDATE_FIELD = SdkField.<OAuthUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("oAuthUpdate").getter(getter(AuthConfigUpdate::oAuthUpdate)).setter(setter(Builder::oAuthUpdate))
            .constructor(OAuthUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OAuthUpdate oAuthUpdate;

    private AuthConfigUpdate(BuilderImpl builder) {
        this.oAuthUpdate = builder.oAuthUpdate;
    }

    /**
     * <p>
     * The updated OAuth configuration settings for the authentication configuration.
     * </p>
     * 
     * @return The updated OAuth configuration settings for the authentication configuration.
     */
    public final OAuthUpdate oAuthUpdate() {
        return oAuthUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oAuthUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthConfigUpdate)) {
            return false;
        }
        AuthConfigUpdate other = (AuthConfigUpdate) obj;
        return Objects.equals(oAuthUpdate(), other.oAuthUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthConfigUpdate").add("OAuthUpdate", oAuthUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oAuthUpdate":
            return Optional.ofNullable(clazz.cast(oAuthUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oAuthUpdate", O_AUTH_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthConfigUpdate, T> g) {
        return obj -> g.apply((AuthConfigUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthConfigUpdate> {
        /**
         * <p>
         * The updated OAuth configuration settings for the authentication configuration.
         * </p>
         * 
         * @param oAuthUpdate
         *        The updated OAuth configuration settings for the authentication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthUpdate(OAuthUpdate oAuthUpdate);

        /**
         * <p>
         * The updated OAuth configuration settings for the authentication configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthUpdate.Builder} avoiding the need to
         * create one manually via {@link OAuthUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #oAuthUpdate(OAuthUpdate)}.
         * 
         * @param oAuthUpdate
         *        a consumer that will call methods on {@link OAuthUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthUpdate(OAuthUpdate)
         */
        default Builder oAuthUpdate(Consumer<OAuthUpdate.Builder> oAuthUpdate) {
            return oAuthUpdate(OAuthUpdate.builder().applyMutation(oAuthUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OAuthUpdate oAuthUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthConfigUpdate model) {
            oAuthUpdate(model.oAuthUpdate);
        }

        public final OAuthUpdate.Builder getOAuthUpdate() {
            return oAuthUpdate != null ? oAuthUpdate.toBuilder() : null;
        }

        public final void setOAuthUpdate(OAuthUpdate.BuilderImpl oAuthUpdate) {
            this.oAuthUpdate = oAuthUpdate != null ? oAuthUpdate.build() : null;
        }

        @Override
        public final Builder oAuthUpdate(OAuthUpdate oAuthUpdate) {
            this.oAuthUpdate = oAuthUpdate;
            return this;
        }

        @Override
        public AuthConfigUpdate build() {
            return new AuthConfigUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
