/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint used in the capability report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityReportEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityReportEndpoint.Builder, CapabilityReportEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CapabilityReportEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deviceTypes")
            .getter(getter(CapabilityReportEndpoint::deviceTypes))
            .setter(setter(Builder::deviceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CapabilityReportCapability>> CAPABILITIES_FIELD = SdkField
            .<List<CapabilityReportCapability>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CapabilityReportEndpoint::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapabilityReportCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapabilityReportCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DEVICE_TYPES_FIELD,
            CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<String> deviceTypes;

    private final List<CapabilityReportCapability> capabilities;

    private CapabilityReportEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.deviceTypes = builder.deviceTypes;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The id of the endpoint used in the capability report.
     * </p>
     * 
     * @return The id of the endpoint used in the capability report.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceTypes() {
        return deviceTypes != null && !(deviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceTypes} method.
     * </p>
     * 
     * @return The type of device.
     */
    public final List<String> deviceTypes() {
        return deviceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities used in the capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities used in the capability report.
     */
    public final List<CapabilityReportCapability> capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceTypes() ? deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityReportEndpoint)) {
            return false;
        }
        CapabilityReportEndpoint other = (CapabilityReportEndpoint) obj;
        return Objects.equals(id(), other.id()) && hasDeviceTypes() == other.hasDeviceTypes()
                && Objects.equals(deviceTypes(), other.deviceTypes()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityReportEndpoint").add("Id", id())
                .add("DeviceTypes", hasDeviceTypes() ? deviceTypes() : null)
                .add("Capabilities", hasCapabilities() ? capabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "deviceTypes":
            return Optional.ofNullable(clazz.cast(deviceTypes()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("deviceTypes", DEVICE_TYPES_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityReportEndpoint, T> g) {
        return obj -> g.apply((CapabilityReportEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityReportEndpoint> {
        /**
         * <p>
         * The id of the endpoint used in the capability report.
         * </p>
         * 
         * @param id
         *        The id of the endpoint used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of device.
         * </p>
         * 
         * @param deviceTypes
         *        The type of device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(Collection<String> deviceTypes);

        /**
         * <p>
         * The type of device.
         * </p>
         * 
         * @param deviceTypes
         *        The type of device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(String... deviceTypes);

        /**
         * <p>
         * The capabilities used in the capability report.
         * </p>
         * 
         * @param capabilities
         *        The capabilities used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<CapabilityReportCapability> capabilities);

        /**
         * <p>
         * The capabilities used in the capability report.
         * </p>
         * 
         * @param capabilities
         *        The capabilities used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(CapabilityReportCapability... capabilities);

        /**
         * <p>
         * The capabilities used in the capability report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapability.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapability.Builder#build()}
         * is called immediately and its result is passed to {@link #capabilities(List<CapabilityReportCapability>)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(java.util.Collection<CapabilityReportCapability>)
         */
        Builder capabilities(Consumer<CapabilityReportCapability.Builder>... capabilities);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<CapabilityReportCapability> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityReportEndpoint model) {
            id(model.id);
            deviceTypes(model.deviceTypes);
            capabilities(model.capabilities);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String... deviceTypes) {
            deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final List<CapabilityReportCapability.Builder> getCapabilities() {
            List<CapabilityReportCapability.Builder> result = CapabilityReportCapabilitiesCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<CapabilityReportCapability.BuilderImpl> capabilities) {
            this.capabilities = CapabilityReportCapabilitiesCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<CapabilityReportCapability> capabilities) {
            this.capabilities = CapabilityReportCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(CapabilityReportCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<CapabilityReportCapability.Builder>... capabilities) {
            capabilities(Stream.of(capabilities).map(c -> CapabilityReportCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CapabilityReportEndpoint build() {
            return new CapabilityReportEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
