/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint for a managed thing when sending a command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<CommandEndpoint.Builder, CommandEndpoint> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointId").getter(getter(CommandEndpoint::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointId").build()).build();

    private static final SdkField<List<CommandCapability>> CAPABILITIES_FIELD = SdkField
            .<List<CommandCapability>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CommandEndpoint::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final List<CommandCapability> capabilities;

    private CommandEndpoint(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The id of the endpoint for a managed thing.
     * </p>
     * 
     * @return The id of the endpoint for a managed thing.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
     */
    public final List<CommandCapability> capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandEndpoint)) {
            return false;
        }
        CommandEndpoint other = (CommandEndpoint) obj;
        return Objects.equals(endpointId(), other.endpointId()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandEndpoint").add("EndpointId", endpointId())
                .add("Capabilities", hasCapabilities() ? capabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointId", ENDPOINT_ID_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandEndpoint, T> g) {
        return obj -> g.apply((CommandEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandEndpoint> {
        /**
         * <p>
         * The id of the endpoint for a managed thing.
         * </p>
         * 
         * @param endpointId
         *        The id of the endpoint for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
         * </p>
         * 
         * @param capabilities
         *        Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<CommandCapability> capabilities);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
         * </p>
         * 
         * @param capabilities
         *        Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(CommandCapability... capabilities);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for sending commands.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandCapability.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandCapability.Builder#build()} is
         * called immediately and its result is passed to {@link #capabilities(List<CommandCapability>)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(java.util.Collection<CommandCapability>)
         */
        Builder capabilities(Consumer<CommandCapability.Builder>... capabilities);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private List<CommandCapability> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommandEndpoint model) {
            endpointId(model.endpointId);
            capabilities(model.capabilities);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final List<CommandCapability.Builder> getCapabilities() {
            List<CommandCapability.Builder> result = CommandCapabilitiesCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<CommandCapability.BuilderImpl> capabilities) {
            this.capabilities = CommandCapabilitiesCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<CommandCapability> capabilities) {
            this.capabilities = CommandCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(CommandCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<CommandCapability.Builder>... capabilities) {
            capabilities(Stream.of(capabilities).map(c -> CommandCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CommandEndpoint build() {
            return new CommandEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
