/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotificationConfigurationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<CreateNotificationConfigurationRequest.Builder, CreateNotificationConfigurationRequest> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(CreateNotificationConfigurationRequest::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(CreateNotificationConfigurationRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateNotificationConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateNotificationConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            DESTINATION_NAME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventType;

    private final String destinationName;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.eventType = builder.eventType;
        this.destinationName = builder.destinationName;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The type of event triggering a device notification to the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event triggering a device notification to the customer-managed destination.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event triggering a device notification to the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event triggering a device notification to the customer-managed destination.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The name of the destination for the notification configuration.
     * </p>
     * 
     * @return The name of the destination for the notification configuration.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated Tags has been deprecated from this api
     */
    @Deprecated
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the notification configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the notification configuration.
     * @deprecated Tags has been deprecated from this api
     */
    @Deprecated
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationConfigurationRequest)) {
            return false;
        }
        CreateNotificationConfigurationRequest other = (CreateNotificationConfigurationRequest) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotificationConfigurationRequest").add("EventType", eventTypeAsString())
                .add("DestinationName", destinationName()).add("ClientToken", clientToken())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((CreateNotificationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNotificationConfigurationRequest> {
        /**
         * <p>
         * The type of event triggering a device notification to the customer-managed destination.
         * </p>
         * 
         * @param eventType
         *        The type of event triggering a device notification to the customer-managed destination.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event triggering a device notification to the customer-managed destination.
         * </p>
         * 
         * @param eventType
         *        The type of event triggering a device notification to the customer-managed destination.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The name of the destination for the notification configuration.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination for the notification configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the notification configuration.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the notification configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Tags has been deprecated from this api
         */
        @Deprecated
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String eventType;

        private String destinationName;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationConfigurationRequest model) {
            super(model);
            eventType(model.eventType);
            destinationName(model.destinationName);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationConfigurationRequest build() {
            return new CreateNotificationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
