/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaTaskConfigurationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<CreateOtaTaskConfigurationRequest.Builder, CreateOtaTaskConfigurationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateOtaTaskConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateOtaTaskConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PushConfig> PUSH_CONFIG_FIELD = SdkField.<PushConfig> builder(MarshallingType.SDK_POJO)
            .memberName("PushConfig").getter(getter(CreateOtaTaskConfigurationRequest::pushConfig))
            .setter(setter(Builder::pushConfig)).constructor(PushConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateOtaTaskConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            PUSH_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String name;

    private final PushConfig pushConfig;

    private final String clientToken;

    private CreateOtaTaskConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.pushConfig = builder.pushConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A description of the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return A description of the over-the-air (OTA) task configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The name of the over-the-air (OTA) task.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the type of configuration used for the over-the-air (OTA) task.
     * </p>
     * 
     * @return Describes the type of configuration used for the over-the-air (OTA) task.
     */
    public final PushConfig pushConfig() {
        return pushConfig;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pushConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaTaskConfigurationRequest)) {
            return false;
        }
        CreateOtaTaskConfigurationRequest other = (CreateOtaTaskConfigurationRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(pushConfig(), other.pushConfig()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOtaTaskConfigurationRequest").add("Description", description())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("PushConfig", pushConfig())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PushConfig":
            return Optional.ofNullable(clazz.cast(pushConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PushConfig", PUSH_CONFIG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaTaskConfigurationRequest, T> g) {
        return obj -> g.apply((CreateOtaTaskConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOtaTaskConfigurationRequest> {
        /**
         * <p>
         * A description of the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param description
         *        A description of the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the over-the-air (OTA) task.
         * </p>
         * 
         * @param name
         *        The name of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the type of configuration used for the over-the-air (OTA) task.
         * </p>
         * 
         * @param pushConfig
         *        Describes the type of configuration used for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushConfig(PushConfig pushConfig);

        /**
         * <p>
         * Describes the type of configuration used for the over-the-air (OTA) task.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushConfig.Builder} avoiding the need to
         * create one manually via {@link PushConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #pushConfig(PushConfig)}.
         * 
         * @param pushConfig
         *        a consumer that will call methods on {@link PushConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushConfig(PushConfig)
         */
        default Builder pushConfig(Consumer<PushConfig.Builder> pushConfig) {
            return pushConfig(PushConfig.builder().applyMutation(pushConfig).build());
        }

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String description;

        private String name;

        private PushConfig pushConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaTaskConfigurationRequest model) {
            super(model);
            description(model.description);
            name(model.name);
            pushConfig(model.pushConfig);
            clientToken(model.clientToken);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PushConfig.Builder getPushConfig() {
            return pushConfig != null ? pushConfig.toBuilder() : null;
        }

        public final void setPushConfig(PushConfig.BuilderImpl pushConfig) {
            this.pushConfig = pushConfig != null ? pushConfig.build() : null;
        }

        @Override
        public final Builder pushConfig(PushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaTaskConfigurationRequest build() {
            return new CreateOtaTaskConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
